/***************************************************************************
                          FLFormDB.cpp  -  description
                             -------------------
    begin                : Sat Jul 28 2001
    copyright            : (C) 2001,2002 by Federico Albujer Zornoza
    email                : mail@infosial.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "FLFormDB.h"
#include "FLSqlCursor.h"
#include "FLTableMetaData.h"
#include "FLReceiver.h"

FLFormDB::FLFormDB (const char *name, QWidget * parent, WFlags f, FLReceiver * receiver):
QWidget (parent, 0, f),
layout (0),
mainWidget_ (0),
idMDI_ (QString::null)
{
  cursor_ = new FLSqlCursor (name, true, 0, 0, 0);
  name_ = name;
  receiver_ = receiver;

  setFont (qApp->font ());

  if (cursor_)
	if (!cursor_->metadata ())
	  {
		setCaption (tr ("No hay metadatos"));
		return;
	  }
	else
	  setCaption (cursor_->metadata ()->alias ());
  else
	return;

  if (receiver_)
	receiver_->setCursor (cursor_);
}

FLFormDB::FLFormDB (FLSqlCursor * cursor, QWidget * parent, WFlags f, FLReceiver * receiver):
QWidget (parent, 0, f), cursor_ (cursor), layout (0), mainWidget_ (0), idMDI_ (QString::null)
{
  name_ = QString::null;
  receiver_ = receiver;

  setFont (qApp->font ());

  if (cursor_)
	if (!cursor_->metadata ())
	  {
		setCaption (tr ("No hay metadatos"));
		return;
	  }
	else
	  setCaption (cursor_->metadata ()->alias ());
  else
	return;

  if (receiver_)
	receiver_->setCursor (cursor_);
}

FLFormDB::~FLFormDB ()
{
  disconnect (this, 0, 0, 0);

  if (cursor_ && !name_.isEmpty ())
	delete cursor_;

  if (receiver_)
	delete receiver_;

  if (mainWidget_)
	delete mainWidget_;
}

void
FLFormDB::setMainWidget (QWidget * w)
{
  if (!w)
	return;

  if (layout)
	delete layout;

  w->setFont (qApp->font ());
  layout = new QVBoxLayout (this);
  layout->setSpacing (5);
  layout->setMargin (5);

  layout->add (w);

  mainWidget_ = w;
  setFocusProxy (mainWidget_);
  mainWidget_->setFocusPolicy (QWidget::NoFocus);
  mainWidget_->setFocus ();
  resize (mainWidget_->size ());
  connectButtonClose ();

  if (receiver_)
	receiver_->setSender (this);
}

void
FLFormDB::connectButtonClose ()
{
  QObjectList *ol = (QObjectList *) mainWidget_->children ();

  if (ol)
	{
	  QObject *obj;

	  for (obj = ol->first (); obj != 0; obj = ol->next ())
		{
		  QObjectList *ol2 = (QObjectList *) obj->children ();

		  if (ol2)
			{
			  QObject *obj2;

			  for (obj2 = ol2->first (); obj2 != 0; obj2 = ol2->next ())
				{
				  QString n = obj2->name ();

				  if (n == "toolButtonExit")
					{
					  connect ((QToolButton *) obj2, SIGNAL (clicked ()), this, SLOT (close ()));
					  break;
					}
				}
			}
		}
	}
}

void
FLFormDB::closeEvent (QCloseEvent * e)
{
  emit closed ();
  QWidget::closeEvent (e);
}
