/*
 * etPan! -- a mail user agent
 *
 * Copyright (C) 2001, 2002 - DINH Viet Hoa
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the libEtPan! project nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/*
 * $Id: etpan-header-common.h,v 1.3 2003/11/24 20:04:18 hoa Exp $
 */

#ifndef ETPAN_HEADER_COMMON_H

#define ETPAN_HEADER_COMMON_H

#include "etpan-app-types.h"
#include "etpan-subapp-types.h"
#include "etpan-header-common-types.h"

void etpan_header_common_set_color(struct etpan_subapp * app,
    struct etpan_header_common_state * state);

void etpan_header_common_handle_key(struct etpan_subapp * app,
    struct etpan_header_common_state * state,
    int key);

int etpan_common_header_init(struct etpan_subapp * subapp,
    struct etpan_header_common_state * state);

void etpan_header_common_done(struct etpan_subapp * subapp,
    struct etpan_header_common_state * state);

void etpan_header_common_flush(struct etpan_subapp * app,
    struct etpan_header_common_state * state);

void etpan_header_common_leave(struct etpan_subapp * app,
    struct etpan_header_common_state * state,
    struct etpan_subapp * new_app);

void etpan_header_common_set_fields(struct etpan_subapp * app,
    struct etpan_header_common_state * state,
    struct mailimf_fields * fields);

struct mailimf_fields *
etpan_header_common_get_fields(struct etpan_subapp * app,
    struct etpan_header_common_state * state);

int etpan_header_common_display(struct etpan_subapp * app,
    struct etpan_header_common_state * state,
    WINDOW * w, char * help_str);

void etpan_header_common_fields_adjust(struct etpan_subapp * app,
    struct etpan_header_common_state * state);

#endif
