#include <ethos/ethos.h>
#include <string.h>

static void
test1 (void)
{
	g_assert (ethos_plugin_info_new ());
}

static gchar *plugin_data = "[Test Plugin]\n"
                            "Name=Example\n"
                            "Description=Example Description\n"
                            "Icon=example-icon\n"
                            "Module=example\n";

static void
test2 (void)
{
	EthosPluginInfo *plugin_info;
	gboolean         result;
	gchar           *id,
			*name,
			*description,
			*icon,
			*module;
	gboolean         active;
	GError          *error = NULL;

	plugin_info = ethos_plugin_info_new ();
	g_assert (plugin_info);

	ethos_plugin_info_set_id (plugin_info, "example");
	result = ethos_plugin_info_load_from_data (plugin_info,
	                                           "Test Plugin",
	                                           plugin_data,
	                                           strlen (plugin_data),
	                                           &error);
	if (!result)
		g_error ("%s", error->message);
	g_assert (result == TRUE);

	g_object_get (plugin_info,
	              "id", &id,
	              "name", &name,
	              "description", &description,
	              "icon-name", &icon,
	              "active", &active,
	              "module", &module,
	              NULL);

	g_assert_cmpstr (id, ==, "example");
	g_assert_cmpstr (name, ==, "Example");
	g_assert_cmpstr (description, ==, "Example Description");
	g_assert_cmpstr (module, ==, "example");
	g_assert (active == FALSE);
}

int
main (int argc, char *argv[])
{
	g_type_init ();
	g_test_init (&argc, &argv);

	g_test_add_func ("/plugin-info/new", test1);
	g_test_add_func ("/plugin-info/load_from_data", test2);

	return g_test_run ();
}
