#include <glib.h>
#include <gmodule.h>
#include <ethos/ethos.h>

#define MY_TYPE_PLUGIN				(my_plugin_get_type ())
#define MY_PLUGIN(obj)				(G_TYPE_CHECK_INSTANCE_CAST ((obj), MY_TYPE_PLUGIN, MyPlugin))
#define MY_PLUGIN_CONST(obj)		(G_TYPE_CHECK_INSTANCE_CAST ((obj), MY_TYPE_PLUGIN, MyPlugin const))
#define MY_PLUGIN_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST ((klass), MY_TYPE_PLUGIN, MyPluginClass))
#define MY_IS_PLUGIN(obj)			(G_TYPE_CHECK_INSTANCE_TYPE ((obj), MY_TYPE_PLUGIN))
#define MY_IS_PLUGIN_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass), MY_TYPE_PLUGIN))
#define MY_PLUGIN_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj), MY_TYPE_PLUGIN, MyPluginClass))

typedef struct _MyPlugin		MyPlugin;
typedef struct _MyPluginClass	MyPluginClass;
typedef struct _MyPluginPrivate	MyPluginPrivate;

struct _MyPlugin
{
	EthosPlugin parent;

	MyPluginPrivate *priv;
};

struct _MyPluginClass
{
	EthosPluginClass parent_class;
};

GType        my_plugin_get_type (void) G_GNUC_CONST;
EthosPlugin* my_plugin_new      (void);

struct _MyPluginPrivate
{
	gpointer dummy;
};

G_DEFINE_TYPE (MyPlugin, my_plugin, ETHOS_TYPE_PLUGIN)

static void
my_plugin_finalize (GObject *object)
{
	G_OBJECT_CLASS (my_plugin_parent_class)->finalize (object);
}

static void activated (EthosPlugin *plugin)
{
}

static void deactivated (EthosPlugin *plugin)
{
}

static void
my_plugin_class_init (MyPluginClass *klass)
{
	GObjectClass *object_class = G_OBJECT_CLASS (klass);
	EthosPluginClass *plugin_class = ETHOS_PLUGIN_CLASS (klass);
	
	object_class->finalize = my_plugin_finalize;
	plugin_class->activated = activated;
	plugin_class->deactivated = deactivated;

	g_type_class_add_private (object_class, sizeof(MyPluginPrivate));
}

static void
my_plugin_init (MyPlugin *self)
{
	self->priv = G_TYPE_INSTANCE_GET_PRIVATE (self, MY_TYPE_PLUGIN, MyPluginPrivate);
}

EthosPlugin*
my_plugin_new ()
{
	return g_object_new (MY_TYPE_PLUGIN, NULL);
}

G_MODULE_EXPORT EthosPlugin*
ethos_plugin_register (void)
{
	return my_plugin_new ();
}
