using GLib;
using Gtk;
using Ethos;
using Ethos.UI;

namespace Valethos {
	Ethos.Manager plugins;

	static void main (string[] args) {
		Gtk.init (ref args);

		/* setup the app */
		setup_plugins ();
		setup_ui ();

		/* initialize user plugins */
		plugins.initialize ();

		Gtk.main ();
	}

	void setup_ui () {
		var window = new Gtk.Window (Gtk.WindowType.TOPLEVEL);
		window.title = "Valethos";
		window.delete_event += _ => { Gtk.main_quit (); };
		window.set_default_size(640, 480);
		window.set_border_width (12);
		window.show ();

		var widget = new ManagerWidget ();
		widget.set_manager (plugins);
		window.add (widget);
		widget.show ();
	}

	void setup_plugins () {
		plugins = new Manager ();
		plugins.set_app_name ("Valethos");
		plugins.set_plugin_dirs (new string[] { "plugins" });
	}
}
