using GLib;
using Gtk;
using Ethos;
using Ethos.UI;

class Sample2Plugin: Ethos.Plugin, Ethos.UI.Configurable {
	construct {
		this.activated += _ => {
			debug ("Sample2 activated");
		};

		this.deactivated += _ => {
			debug ("Sample2 deactivated");
		};
	}

	public void configure (Gtk.Widget parent) {
		var win = new Window (WindowType.TOPLEVEL);
		win.title = "Configure Sample2";
		win.border_width = 12;
		win.show ();

		var vbox = new VBox (false, 6);
		win.add (vbox);
		vbox.show ();

		var entry = new Entry ();
		vbox.pack_start (entry, false, true, 0);
		entry.show ();

		var button = new Button.from_stock (STOCK_CLOSE);
		vbox.pack_start (button, true, true, 0);
		button.clicked += button => {
			button.get_toplevel ().destroy ();
		};
		button.show ();
	}
}

public Ethos.Plugin? ethos_plugin_register () {
	return new Sample2Plugin ();
}
