C Copyright 1981-2007 ECMWF
C 
C Licensed under the GNU Lesser General Public License which
C incorporates the terms and conditions of version 3 of the GNU
C General Public License.
C See LICENSE and gpl-3.0.txt for details.
C

      LOGICAL FUNCTION CHEQUAL( HIN, KFIRST, KLAST, HCOMP)
C
C---->
C**** CHEQUAL
C
C     Purpose
C     -------
C
C     Compare two ASCII character strings without regard to case.
C
C
C     Interface
C     ---------
C
C     Input
C     -----
C
C     HIN   - First string
C     KFIRST- position of first character in string for comparison
C     KLAST - position of last character in string for comparison
C     HCOMP - Second string
C
C
C     Method
C     ------
C
C     Compare values as uppercase letters.
C
C
C     Externals
C     ---------
C
C     None.
C
C
C     Author
C     ------
C
C     J.D.Chambers       ECMWF        January 1995.
C
C----<
C
      IMPLICIT NONE
C
C     Function arguments
C
      CHARACTER*(*) HIN, HCOMP
      INTEGER  KFIRST, KLAST, LOOP, ITEMP1, ITEMP2, ITEMPA
#ifdef rs6000

      ITEMPA = ICHAR( 'a' )
#else
      DATA ITEMPA/97/
C                |
C                v
C     ITEMPA = ICHAR( 'a' )
#endif

      CHEQUAL = .FALSE.

      IF( KFIRST .GT. KLAST ) RETURN

      DO 110 LOOP =  KFIRST, KLAST
        ITEMP1 = ICHAR( HIN(LOOP:LOOP) )
        IF ( ITEMP1 .LT. ITEMPA ) ITEMP1 = ITEMP1 + 32

        ITEMP2 = ICHAR( HCOMP(LOOP:LOOP) )
        IF ( ITEMP2 .LT. ITEMPA) ITEMP2 = ITEMP2 + 32

        IF ( ITEMP1 .NE. ITEMP2 ) RETURN
  110 CONTINUE

      CHEQUAL = .TRUE.

      RETURN
      END
