/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.gui.form;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import org.emboss.jemboss.JembossParams;
import org.emboss.jemboss.gui.AdvancedOptions;
import org.emboss.jemboss.gui.BuildProgramMenu;
import org.emboss.jemboss.gui.form.AlignFormat;
import org.emboss.jemboss.gui.form.ApplicationNamePanel;
import org.emboss.jemboss.gui.form.BuildJembossForm;
import org.emboss.jemboss.gui.form.JembossComboPopup;
import org.emboss.jemboss.gui.form.LabelTextBox;
import org.emboss.jemboss.gui.form.ListFilePanel;
import org.emboss.jemboss.gui.form.MultiTextField;
import org.emboss.jemboss.gui.form.ReportFormat;
import org.emboss.jemboss.gui.form.Separator;
import org.emboss.jemboss.gui.form.SetInFileCard;
import org.emboss.jemboss.gui.form.SetOutFileCard;
import org.emboss.jemboss.gui.form.TextFieldFloat;
import org.emboss.jemboss.gui.form.TextFieldInt;
import org.emboss.jemboss.gui.form.TextFieldSink;
import org.emboss.jemboss.gui.sequenceChooser.InputSequenceAttributes;
import org.emboss.jemboss.parser.AcdFunResolve;
import org.emboss.jemboss.parser.AcdVarResolve;
import org.emboss.jemboss.parser.AjaxUtil;
import org.emboss.jemboss.parser.Dependent;
import org.emboss.jemboss.parser.ParseAcd;
import org.emboss.jemboss.programs.RunEmbossApplication2;
import org.emboss.jemboss.soap.CallAjax;
import org.emboss.jemboss.soap.JembossSoapException;

public class SectionPanel {
    private TextFieldSink[] textf;
    private TextFieldInt[] textInt;
    private TextFieldFloat[] textFloat;
    private JCheckBox[] checkBox;
    private InputSequenceAttributes[] inSeqAttr;
    private JembossComboPopup[] fieldOption;
    private JList[] multiOption;
    private SetInFileCard[] inSeq;
    private Box[] lab;
    private String[] db;
    private ParseAcd parseAcd;
    private int numofFields;
    private int nf;
    public static int ajaxLength;
    public static float ajaxWeight;
    public static boolean ajaxProtein;
    private boolean withSoap;
    private String appName = "";
    private JPanel p3;
    private JPanel sectionPane;
    private Box sectionBox;
    private JembossParams mysettings;
    private boolean isInp = false;
    private boolean isReq = false;
    private boolean isAdv = false;
    private boolean isAdd = false;
    private boolean isOut = false;
    private boolean isShadedGUI;
    public static Color labelColor;
    public static Font labfont;
    public static Font labfont2;
    private final int maxSectionWidth = 498;
    private JFrame f;
    private ReportFormat rf = null;
    private AlignFormat af = null;

    protected SectionPanel(JFrame f, JPanel p3, Box fieldPane, ParseAcd parseAcd, int nff, MultiTextField[] multiTextField, final TextFieldSink[] textf, TextFieldInt[] textInt, TextFieldFloat[] textFloat, JTextField[] rangeField, JCheckBox[] checkBox, InputSequenceAttributes[] inSeqAttr, JembossComboPopup[] fieldOption, JList[] multiOption, SetInFileCard[] inSeq, ListFilePanel[] filelist, JComboBox graphics, String[] db, String des, Box[] lab, int numofFields, JembossParams mysettings, boolean withSoap, String[] envp) {
        Border etched = BorderFactory.createEtchedBorder();
        this.isShadedGUI = AdvancedOptions.prefShadeGUI.isSelected();
        this.p3 = p3;
        this.textf = textf;
        this.textInt = textInt;
        this.textFloat = textFloat;
        this.checkBox = checkBox;
        this.inSeqAttr = inSeqAttr;
        this.fieldOption = fieldOption;
        this.multiOption = multiOption;
        this.inSeq = inSeq;
        this.numofFields = numofFields;
        this.db = db;
        this.lab = lab;
        this.parseAcd = parseAcd;
        this.mysettings = mysettings;
        this.withSoap = withSoap;
        this.f = f;
        this.nf = nff;
        String att = parseAcd.getParameterAttribute(this.nf, 0).toLowerCase();
        if (att.startsWith("appl")) {
            this.setAppTitle(des, p3);
            ++this.nf;
            att = parseAcd.getParameterAttribute(this.nf, 0).toLowerCase();
        }
        Box section = new Box(1);
        fieldPane.add(Box.createRigidArea(new Dimension(0, 10)));
        JLabel bxlab = new JLabel();
        bxlab.setFont(labfont);
        this.sectionPane = new JPanel(new GridLayout(1, 1));
        this.sectionPane.setBorder(BorderFactory.createEtchedBorder());
        String nameSect = parseAcd.getParamValueStr(this.nf, 0);
        if (att.equals("section")) {
            TitledBorder title = BorderFactory.createTitledBorder(etched, parseAcd.getInfoParamValue(this.nf).toLowerCase(), 1, 2, new Font("SansSerif", 1, 13), Color.blue);
            this.sectionPane.setBorder(title);
            String secType = parseAcd.getInfoParamValue(this.nf).toLowerCase();
            if (secType.startsWith("advanced ")) {
                this.isAdv = true;
            } else if (secType.startsWith("additional ")) {
                this.isAdd = true;
            } else if (secType.startsWith("input ")) {
                this.isInp = true;
            } else if (secType.startsWith("output ")) {
                this.isOut = true;
            } else if (secType.startsWith("required ")) {
                this.isOut = true;
            } else {
                System.out.println("Unknown section type " + secType);
            }
            ++this.nf;
            att = parseAcd.getParameterAttribute(this.nf, 0).toLowerCase();
        }
        String varName = parseAcd.getParamValueStr(this.nf, 0);
        int numberOfParameters = 0;
        while (!(att.equals("endsection") && varName.equals(nameSect) || this.nf >= numofFields)) {
            if (!att.equals("var") && !att.equals("variable")) {
                Dimension d;
                Box pan2;
                Double val;
                ++numberOfParameters;
                final int h = parseAcd.getGuiHandleNumber(this.nf);
                Box pan = new Box(0);
                section.add(pan);
                String l = this.getMinMaxDefault(null, null, null, this.nf);
                lab[this.nf] = new LabelTextBox(parseAcd.getInfoParamValue(this.nf), parseAcd.getHelpParamValue(this.nf));
                if (l != null && !att.startsWith("bool")) {
                    bxlab = new JLabel(" " + l);
                    bxlab.setFont(labfont2);
                    bxlab.setForeground(Color.blue);
                    lab[this.nf].add(bxlab);
                }
                if (att.startsWith("appl")) {
                    this.setAppTitle(des, p3);
                } else if (att.endsWith("graph")) {
                    Dimension d2 = graphics.getPreferredSize();
                    d2 = new Dimension(150, (int)d2.getHeight());
                    graphics.setMaximumSize(d2);
                    graphics.setPreferredSize(d2);
                    pan.add(graphics);
                    pan.add(new JLabel(" Graph Format"));
                } else if (att.startsWith("int")) {
                    if (parseAcd.isDefaultParamValueStr(this.nf)) {
                        if (!parseAcd.getDefaultParamValueStr(this.nf).startsWith("@") && !parseAcd.getDefaultParamValueStr(this.nf).startsWith("$")) {
                            textInt[h].setValue(Integer.parseInt(parseAcd.getDefaultParamValueStr(this.nf)));
                        }
                    } else {
                        val = new Double(parseAcd.getDefaultParamValueDbl(this.nf));
                        textInt[h].setValue(val.intValue());
                    }
                    pan.add(textInt[h]);
                    pan.add(lab[this.nf]);
                } else if (att.startsWith("float")) {
                    if (parseAcd.isDefaultParamValueStr(this.nf)) {
                        if (!parseAcd.getDefaultParamValueStr(this.nf).startsWith("@") && !parseAcd.getDefaultParamValueStr(this.nf).startsWith("$")) {
                            textFloat[h].setValue(Double.parseDouble(parseAcd.getDefaultParamValueStr(this.nf)));
                        }
                    } else {
                        val = new Double(parseAcd.getDefaultParamValueDbl(this.nf));
                        textFloat[h].setValue(val);
                    }
                    pan.add(textFloat[h]);
                    pan.add(lab[this.nf]);
                } else if (att.startsWith("matrix")) {
                    if (parseAcd.isDefaultParamValueStr(this.nf) && !parseAcd.getDefaultParamValueStr(this.nf).startsWith("@") && !parseAcd.getDefaultParamValueStr(this.nf).startsWith("$")) {
                        textf[h].setText(parseAcd.getDefaultParamValueStr(this.nf));
                    }
                    pan.add(textf[h]);
                    pan.add(lab[this.nf]);
                    pan2 = new Box(0);
                    section.add(pan2);
                    JembossComboPopup selectMatrix = new JembossComboPopup(BuildProgramMenu.getMatrices());
                    selectMatrix.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            JembossComboPopup cb = (JembossComboPopup)e.getSource();
                            String matrix = (String)cb.getSelectedItem();
                            textf[h].setText(matrix);
                        }
                    });
                    d = selectMatrix.getPreferredSize();
                    d = new Dimension(150, (int)d.getHeight());
                    selectMatrix.setMaximumSize(d);
                    selectMatrix.setPreferredSize(d);
                    pan2.add(selectMatrix);
                    pan2.add(Box.createHorizontalGlue());
                } else if (att.startsWith("codon")) {
                    if (parseAcd.isDefaultParamValueStr(this.nf) && !parseAcd.getDefaultParamValueStr(this.nf).startsWith("@") && !parseAcd.getDefaultParamValueStr(this.nf).startsWith("$")) {
                        textf[h].setText(parseAcd.getDefaultParamValueStr(this.nf));
                    }
                    pan.add(textf[h]);
                    pan.add(lab[this.nf]);
                    pan2 = new Box(0);
                    section.add(pan2);
                    JembossComboPopup selectMatrix = new JembossComboPopup(BuildProgramMenu.getCodonUsage());
                    selectMatrix.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            JembossComboPopup cb = (JembossComboPopup)e.getSource();
                            String matrix = (String)cb.getSelectedItem();
                            textf[h].setText(matrix);
                        }
                    });
                    d = selectMatrix.getPreferredSize();
                    d = new Dimension(150, (int)d.getHeight());
                    selectMatrix.setMaximumSize(d);
                    selectMatrix.setPreferredSize(d);
                    pan2.add(selectMatrix);
                    pan2.add(Box.createHorizontalGlue());
                } else if (att.startsWith("dirlist") || att.startsWith("string") || att.startsWith("infile") || att.startsWith("regexp") || att.startsWith("featout")) {
                    if (parseAcd.isDefaultParamValueStr(this.nf) && !parseAcd.getDefaultParamValueStr(this.nf).startsWith("@") && !parseAcd.getDefaultParamValueStr(this.nf).startsWith("$")) {
                        textf[h].setText(parseAcd.getDefaultParamValueStr(this.nf));
                    }
                    pan.add(textf[h]);
                    pan.add(lab[this.nf]);
                } else if (att.startsWith("pattern")) {
                    LabelTextBox[] labs = new LabelTextBox[]{(LabelTextBox)lab[this.nf], new LabelTextBox("Pattern mismatch", "Number of pattern mismatch")};
                    multiTextField[h] = new MultiTextField(2, labs);
                    pan.add(multiTextField[h].getBoxOfTextFields());
                } else if (att.startsWith("seqout")) {
                    new SetOutFileCard(pan, textf[h], labelColor, this.sectionPane);
                } else if (att.startsWith("outfile") || att.startsWith("datafile")) {
                    if (parseAcd.isDefaultParamValueStr(this.nf) && !parseAcd.getDefaultParamValueStr(this.nf).startsWith("@") && !parseAcd.getDefaultParamValueStr(this.nf).startsWith("$")) {
                        textf[h].setText(parseAcd.getDefaultParamValueStr(this.nf));
                    }
                    if (parseAcd.getInfoParamValue(this.nf).equals("")) {
                        bxlab = new JLabel(" " + att + " file name");
                        bxlab.setForeground(labelColor);
                    }
                    lab[this.nf].add(bxlab);
                    pan.add(textf[h]);
                    pan.add(lab[this.nf]);
                } else if (att.startsWith("seqset")) {
                    inSeq[h] = new SetInFileCard(this.sectionPane, h, db, "Multiple Sequence Filename", this.appName, inSeqAttr, true, mysettings);
                    pan.add(inSeq[h]);
                } else if (att.startsWith("sequence") || att.startsWith("seqall")) {
                    String tit = parseAcd.getInfoParamValue(this.nf);
                    if (tit.equals("")) {
                        tit = "Sequence Filename";
                    }
                    inSeq[h] = new SetInFileCard(this.sectionPane, h, db, tit, this.appName, inSeqAttr, true, mysettings);
                    pan.add(inSeq[h]);
                } else if (att.startsWith("filelist")) {
                    filelist[h] = new ListFilePanel(15, mysettings, h == 0);
                    pan.add(filelist[h]);
                    pan.add(Box.createVerticalStrut(100));
                } else if (att.startsWith("range")) {
                    pan.add(rangeField[h]);
                    pan.add(lab[this.nf]);
                } else if (att.startsWith("bool")) {
                    if (parseAcd.isDefaultParamValueStr(this.nf) && (parseAcd.getDefaultParamValueStr(this.nf).equalsIgnoreCase("Y") || parseAcd.getDefaultParamValueStr(this.nf).equalsIgnoreCase("Yes"))) {
                        checkBox[h].setSelected(true);
                    }
                    pan.add(checkBox[h]);
                    pan.add(lab[this.nf]);
                } else if (att.startsWith("report")) {
                    this.rf = new ReportFormat(parseAcd, this.nf);
                    pan.add(this.rf.getComboPopup());
                    pan.add(new LabelTextBox(" Report format (" + this.rf.getDefaultFormat() + ")", ReportFormat.getToolTip()));
                    section.add(this.rf.getReportCheckBox());
                } else if (att.startsWith("align")) {
                    this.af = new AlignFormat(parseAcd, this.nf);
                    pan.add(this.af.getComboPopup());
                    pan.add(new LabelTextBox(" Align format (" + this.af.getDefaultFormat() + ")", this.af.getToolTip()));
                } else if (att.startsWith("list") || att.startsWith("select")) {
                    Vector def;
                    Object[] list = att.startsWith("list") ? parseAcd.getList(this.nf) : parseAcd.getSelect(this.nf);
                    double max = 1.0;
                    if (parseAcd.isMaxParamValue(this.nf)) {
                        max = Double.parseDouble(parseAcd.getMaxParam(this.nf));
                    }
                    if (max > 1.0) {
                        multiOption[h] = new JList<String>(list);
                        multiOption[h].setSelectionMode(2);
                        def = parseAcd.getListOrSelectDefault();
                        int[] selectedIndeces = new int[def.size()];
                        for (int i = 0; i < def.size(); ++i) {
                            selectedIndeces[i] = (Integer)def.get(i);
                        }
                        multiOption[h].setSelectedIndices(selectedIndeces);
                        JScrollPane scrollPane = new JScrollPane(multiOption[h]);
                        Dimension d3 = new Dimension(150, 100);
                        scrollPane.setMinimumSize(d3);
                        scrollPane.setMaximumSize(d3);
                        scrollPane.setPreferredSize(d3);
                        pan.add(scrollPane);
                    } else {
                        fieldOption[h] = new JembossComboPopup(list);
                        def = parseAcd.getListOrSelectDefault();
                        for (int i = 0; i < def.size(); ++i) {
                            fieldOption[h].setSelectedIndex((Integer)def.get(i));
                        }
                        Dimension d4 = fieldOption[h].getPreferredSize();
                        d4 = new Dimension(150, (int)d4.getHeight());
                        fieldOption[h].setMaximumSize(d4);
                        fieldOption[h].setPreferredSize(d4);
                        pan.add(fieldOption[h]);
                    }
                    pan.add(lab[this.nf]);
                }
                pan.add(Box.createHorizontalGlue());
                section.add(Box.createVerticalStrut(10));
            }
            if (AdvancedOptions.prefJNI.isSelected()) {
                this.checkDependents(section, envp);
            }
            if ((att.startsWith("seqset") || att.startsWith("seqall") || att.startsWith("sequence")) && !this.isInp) {
                section.add(new Separator(new Dimension(350, 10)));
                section.add(Box.createVerticalStrut(10));
            }
            ++this.nf;
            if (this.nf >= numofFields) continue;
            att = parseAcd.getParameterAttribute(this.nf, 0).toLowerCase();
            varName = parseAcd.getParamValueStr(this.nf, 0);
        }
        ++this.nf;
        if (numberOfParameters > 0) {
            this.sectionPane.add(section);
            this.sectionBox = new Box(0);
            this.sectionResize(this.sectionPane);
            this.sectionBox.add(Box.createRigidArea(new Dimension(2, 0)));
            this.sectionBox.add(this.sectionPane);
            this.sectionBox.add(Box.createHorizontalGlue());
        }
    }

    protected ReportFormat getReportFormat() {
        return this.rf;
    }

    protected boolean isReportFormat() {
        return this.rf != null;
    }

    protected AlignFormat getAlignFormat() {
        return this.af;
    }

    protected boolean isAlignFormat() {
        return this.af != null;
    }

    protected JPanel getSectionPanel() {
        return this.sectionPane;
    }

    protected Box getSectionBox() {
        return this.sectionBox;
    }

    protected boolean isInputSection() {
        return this.isInp;
    }

    protected boolean isOutputSection() {
        return this.isOut;
    }

    protected boolean isRequiredSection() {
        return this.isReq;
    }

    protected boolean isAdvancedSection() {
        return this.isAdv;
    }

    protected boolean isAdditionalSection() {
        return this.isAdd;
    }

    protected int getFieldNum() {
        return this.nf;
    }

    private void setAppTitle(String des, JPanel p3) {
        this.appName = this.parseAcd.getParamValueStr(this.nf, 0).toUpperCase();
        Box bylabP = new Box(1);
        Box bxlabP = new Box(0);
        JScrollPane mainScroller = (JScrollPane)p3.getParent().getParent();
        JPanel jTitle = new JPanel(new BorderLayout());
        jTitle.setBackground(Color.white);
        ApplicationNamePanel namePanel = new ApplicationNamePanel(this.appName, 10, 18, 18);
        bxlabP.add(namePanel);
        bxlabP.add(Box.createHorizontalGlue());
        bylabP.add(bxlabP);
        JLabel labP = new JLabel(des);
        labP.setFont(labfont);
        bxlabP = new Box(0);
        bxlabP.add(Box.createHorizontalStrut(10));
        bxlabP.add(labP);
        bxlabP.add(Box.createHorizontalGlue());
        bylabP.add(bxlabP);
        jTitle.add((Component)bylabP, "West");
        mainScroller.setColumnHeaderView(jTitle);
    }

    private String getMinMaxDefault(String min, String max, String def, int nfield) {
        String l = new String("");
        if (this.parseAcd.isMinParamValue(nfield) && min == null) {
            min = this.parseAcd.getMinParam(nfield);
        }
        if (this.parseAcd.isMaxParamValue(nfield) && max == null) {
            max = this.parseAcd.getMaxParam(nfield);
        }
        if (this.parseAcd.isDefaultParamValueStr(nfield) && def == null) {
            def = this.parseAcd.getDefaultParamValueStr(nfield);
        }
        if (min != null && !min.startsWith("$") && !min.startsWith("@")) {
            l = l.concat("(min:" + min);
            if (this.parseAcd.isMaxParamValue(nfield) && !max.startsWith("$") && !max.startsWith("@")) {
                l = l.concat(" max:" + max);
            }
            l = this.parseAcd.isDefaultParamValueStr(nfield) && !def.startsWith("$") && !def.startsWith("@") && !def.equals("") ? l.concat(" default:" + def + ") ") : l.concat(") ");
        } else if (this.parseAcd.isMaxParamValue(nfield) && !max.startsWith("$") && !max.startsWith("@")) {
            l = l.concat("(max:" + max);
            l = this.parseAcd.isDefaultParamValueStr(nfield) && !def.startsWith("$") && !def.startsWith("@") && !def.equals("") ? l.concat(" default:" + def + ") ") : l.concat(") ");
        } else {
            l = this.parseAcd.isDefaultParamValueStr(nfield) && !def.startsWith("$") && !def.startsWith("@") && !def.equals("") ? l.concat("(default:" + def + ") ") : (this.parseAcd.isMinParamValue(nfield) || this.parseAcd.isMaxParamValue(nfield) || this.parseAcd.isDefaultParamValueStr(nfield) ? "" : null);
        }
        return l;
    }

    private void checkDependents(Box section, final String[] envp) {
        final Cursor cbusy = new Cursor(3);
        final Cursor cdone = new Cursor(0);
        final String att = this.parseAcd.getParameterAttribute(this.nf, 0).toLowerCase();
        final String varName = this.parseAcd.getParamValueStr(this.nf, 0);
        String valS = this.parseAcd.getParamValueStr(this.nf, 0).toLowerCase();
        final int nff = this.nf;
        if (this.parseAcd.isDependents(valS, this.nf, this.numofFields)) {
            final int h = this.parseAcd.getGuiHandleNumber(this.nf);
            final int nod = this.parseAcd.getNumOfDependents();
            final Dependent[] dep = this.parseAcd.getDependents();
            if (att.startsWith("seqset") || att.startsWith("seqall") || att.startsWith("sequence")) {
                Box left = new Box(0);
                JButton upload = new JButton("LOAD SEQUENCE ATTRIBUTES");
                upload.setToolTipText("After entering your sequence above, click here. This\nwill display the input parameters for " + this.appName + "\n" + "that are dependent on the sequence attributes.");
                upload.setForeground(Color.red);
                left.add(upload);
                left.add(Box.createHorizontalGlue());
                section.add(left);
                section.add(Box.createVerticalStrut(10));
                final SetInFileCard sifc = this.inSeq[h];
                upload.addActionListener(new ActionListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void actionPerformed(ActionEvent e) {
                        block20: {
                            String fc = null;
                            SectionPanel.this.f.setCursor(cbusy);
                            try {
                                if (sifc.isFileName() || sifc.isListFile()) {
                                    String fname = sifc.isListFile() ? sifc.getSequence(1) : sifc.getFileChosen();
                                    fc = AjaxUtil.getFileOrDatabaseForAjax(fname, SectionPanel.this.db, SectionPanel.this.f, SectionPanel.this.withSoap);
                                } else {
                                    fc = sifc.getCutNPasteText();
                                    if (!SectionPanel.this.withSoap) {
                                        String cwd = System.getProperty("user.dir");
                                        String tmp = null;
                                        try {
                                            File tf;
                                            try {
                                                tmp = JembossParams.isCygwin() ? JembossParams.getCygwinRoot() + System.getProperty("file.separator") + "tmp" : System.getProperty("java.io.tmpdir");
                                                tf = File.createTempFile("attr", ".jembosstmp", new File(tmp));
                                            }
                                            catch (IOException ioe) {
                                                tf = File.createTempFile("attr", ".jembosstmp", new File(cwd));
                                            }
                                            PrintWriter out = new PrintWriter(new FileWriter(tf));
                                            out.println(fc);
                                            out.close();
                                            fc = tf.getCanonicalPath();
                                        }
                                        catch (IOException ioe) {
                                            JOptionPane.showMessageDialog(null, "Cannot write to\n" + tmp + "\n" + "or\n" + cwd, "Problem creating a temporary file!", 0);
                                        }
                                    }
                                }
                                if (!SectionPanel.this.withSoap && fc != null) {
                                    boolean ok = SectionPanel.this.getSeqAttr(fc, envp, att);
                                    if (ok) {
                                        if (SectionPanel.this.updateBeginEnd(SectionPanel.this.inSeqAttr[h].getBegSeq(), SectionPanel.this.inSeqAttr[h].getEndSeq()) && !att.startsWith("seqset") && !att.startsWith("seqall")) {
                                            SectionPanel.this.inSeqAttr[h].setBegSeq(1);
                                            SectionPanel.this.inSeqAttr[h].setEndSeq(ajaxLength);
                                        }
                                        SectionPanel.this.resolveDependents(nod, dep, sifc.getFileChosen(), varName);
                                    } else {
                                        JOptionPane.showMessageDialog(SectionPanel.this.sectionPane, "Sequence not found.\nCheck the sequence entered.", "Error Message", 0);
                                    }
                                    break block20;
                                }
                                if (fc == null) break block20;
                                try {
                                    CallAjax ca = new CallAjax(fc, att, SectionPanel.this.mysettings);
                                    if (ca.getStatus().equals("0") && ca.getLength() > 0) {
                                        ajaxLength = ca.getLength();
                                        ajaxWeight = ca.getWeight();
                                        ajaxProtein = ca.isProtein();
                                        int seqLen = ca.getLength();
                                        if (SectionPanel.this.updateBeginEnd(SectionPanel.this.inSeqAttr[h].getBegSeq(), SectionPanel.this.inSeqAttr[h].getEndSeq()) && !att.startsWith("seqset") && !att.startsWith("seqall")) {
                                            SectionPanel.this.inSeqAttr[h].setBegSeq(1);
                                            SectionPanel.this.inSeqAttr[h].setEndSeq(seqLen);
                                        }
                                        SectionPanel.this.resolveDependents(nod, dep, sifc.getFileChosen(), varName);
                                        break block20;
                                    }
                                    JOptionPane.showMessageDialog(SectionPanel.this.sectionPane, "Sequence not found.\nCheck the sequence entered.", "Error Message", 0);
                                }
                                catch (JembossSoapException eae) {
                                    System.out.println("Call to Ajax library failed");
                                }
                            }
                            catch (Exception exp) {
                                JOptionPane.showMessageDialog(SectionPanel.this.sectionPane, "Error while loading sequence options:\n" + exp.getMessage(), "Error", 0);
                            }
                            finally {
                                SectionPanel.this.f.setCursor(cdone);
                            }
                        }
                    }
                });
            } else if (att.startsWith("list") || att.startsWith("select")) {
                double max = 1.0;
                if (this.parseAcd.isMaxParamValue(nff)) {
                    max = Double.parseDouble(this.parseAcd.getMaxParam(nff));
                }
                if (max <= 1.0) {
                    this.fieldOption[h].addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            String sel = "";
                            int index = SectionPanel.this.fieldOption[h].getSelectedIndex();
                            if (att.startsWith("select")) {
                                sel = new String(new Integer(index + 1).toString());
                            } else if (att.startsWith("list")) {
                                sel = new String(SectionPanel.this.parseAcd.getListLabel(nff, index));
                            }
                            SectionPanel.this.resolveDependents(nod, dep, sel, varName);
                        }
                    });
                }
            } else if (att.startsWith("bool")) {
                this.checkBox[h].addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        String sel = "";
                        sel = SectionPanel.this.checkBox[h].isSelected() ? new String("true") : new String("false");
                        SectionPanel.this.resolveDependents(nod, dep, sel, varName);
                    }
                });
                String sel = "";
                sel = this.checkBox[h].isSelected() ? new String("true") : new String("false");
                this.resolveDependents(nod, dep, sel, varName);
            }
        }
    }

    private boolean getSeqAttr(String fc, String[] envp, String att) throws Exception {
        String infoseqcmd = this.mysettings.getEmbossBin() + "infoseq";
        String[] infoseqcmdA = new String[]{infoseqcmd, "-only", "-type", "-length", "-nohead", "-auto", fc};
        RunEmbossApplication2 rea = new RunEmbossApplication2(infoseqcmdA, envp, null);
        if (rea.getStatus().equals("1")) {
            String error = rea.getInitialIOError();
            if (error == null) {
                error = rea.getProcessStderr();
            }
            throw new Exception(error);
        }
        rea.waitFor();
        String stdout = rea.getProcessStdout();
        if (stdout.trim().equals("")) {
            return false;
        }
        StringTokenizer stok = new StringTokenizer(stdout, "\n ");
        ajaxProtein = stok.nextToken().trim().equalsIgnoreCase("P");
        ajaxLength = Integer.parseInt(stok.nextToken().trim());
        if (att.startsWith("seqset")) {
            String infoaligncmd = this.mysettings.getEmbossBin() + "infoalign";
            String[] infoaligncmdA = new String[]{infoaligncmd, "-only", "-weight", "-nohead", "-out", "stdout", "-auto", fc};
            rea = new RunEmbossApplication2(infoaligncmdA, envp, null);
            rea.waitFor();
            stok = new StringTokenizer(rea.getProcessStdout(), "\n");
            ajaxWeight = 0.0f;
            while (stok.hasMoreTokens()) {
                ajaxWeight += Float.parseFloat(stok.nextToken());
            }
        }
        return true;
    }

    private boolean updateBeginEnd(String s, String e) {
        int n;
        return (s == null || s.equals("")) && (e == null || e.equals("")) || (n = JOptionPane.showConfirmDialog(this.f, "Overwrite the input sequence \nstart :" + s + "\n" + "end :" + e + "\n" + "values already set?", "Confirm", 0)) != 1;
    }

    private void resolveDependents(int nod, Dependent[] dep, String textVal, String varName) {
        for (int i = 0; i < nod; ++i) {
            String exp = dep[i].getDependentExp();
            int field = dep[i].getDependentField();
            try {
                AcdVarResolve avr = new AcdVarResolve(exp, textVal, varName, this.parseAcd, this.numofFields, this.textf, this.textInt, this.textFloat, this.fieldOption, this.checkBox);
                exp = avr.getResult();
            }
            catch (NullPointerException npe) {
                continue;
            }
            AcdFunResolve afr = new AcdFunResolve(exp);
            String result = afr.getResult();
            String att = this.parseAcd.getParameterAttribute(dep[i].getDependentField(), 0).toLowerCase();
            String type = dep[i].getDependentType();
            int h = this.parseAcd.getGuiHandleNumber(field);
            if ((att.equals("list") || att.equals("select")) && (type.startsWith("stand") || type.startsWith("add"))) {
                double max = 1.0;
                if (this.parseAcd.isMaxParamValue(field)) {
                    max = Double.parseDouble(this.parseAcd.getMaxParam(field));
                }
                if (max <= 1.0) {
                    if (result.equals("false")) {
                        this.setShadingAndVisibility(this.fieldOption[h], false, field);
                    } else {
                        this.setShadingAndVisibility(this.fieldOption[h], true, field);
                    }
                } else if (result.equals("false")) {
                    this.setShadingAndVisibility(this.multiOption[h], false, field);
                } else {
                    this.setShadingAndVisibility(this.multiOption[h], true, field);
                }
            } else if (att.startsWith("datafile") || att.startsWith("featout") || att.startsWith("string") || att.startsWith("seqout") || att.startsWith("outfile") || att.startsWith("matrix") || att.startsWith("infile") || att.startsWith("regexp") || att.startsWith("codon") || att.startsWith("dirlist")) {
                if ((type.startsWith("add") || type.startsWith("stand")) && result.equals("false")) {
                    this.setShadingAndVisibility(this.textf[h], false, field);
                } else if ((type.startsWith("add") || type.startsWith("stand")) && result.equals("true")) {
                    this.setShadingAndVisibility(this.textf[h], true, field);
                }
                if (type.startsWith("def")) {
                    if (att.startsWith("matrix")) {
                        Vector mat = BuildProgramMenu.getMatrices();
                        Enumeration en = mat.elements();
                        while (en.hasMoreElements()) {
                            String m = (String)en.nextElement();
                            if (!result.equalsIgnoreCase(m)) continue;
                            this.textf[h].setText(m);
                            break;
                        }
                    } else {
                        this.textf[h].setText(result);
                    }
                }
            } else if (att.startsWith("int")) {
                if ((type.startsWith("add") || type.startsWith("stand")) && result.equals("false")) {
                    this.setShadingAndVisibility(this.textInt[h], false, field);
                } else if ((type.startsWith("add") || type.startsWith("stand")) && result.equals("true")) {
                    this.setShadingAndVisibility(this.textInt[h], true, field);
                }
                if (type.startsWith("def")) {
                    this.textInt[h].setValue(Integer.parseInt(result));
                }
            } else if (att.startsWith("float")) {
                if ((type.startsWith("add") || type.startsWith("stand")) && result.equals("false")) {
                    this.setShadingAndVisibility(this.textFloat[h], false, field);
                } else if ((type.startsWith("add") || type.startsWith("stand")) && result.equals("true")) {
                    this.setShadingAndVisibility(this.textFloat[h], true, field);
                }
                if (type.startsWith("def")) {
                    this.textFloat[h].setValue(Double.parseDouble(result));
                }
            } else if (att.startsWith("bool")) {
                if (type.startsWith("add") || type.startsWith("stand")) {
                    if (result.equals("false")) {
                        this.setShadingAndVisibility(this.checkBox[h], false, field);
                    } else {
                        this.setShadingAndVisibility(this.checkBox[h], true, field);
                    }
                } else if (type.startsWith("def")) {
                    if (result.equals("false")) {
                        this.checkBox[h].setSelected(false);
                    } else {
                        this.checkBox[h].setSelected(true);
                    }
                }
            }
            if (type.startsWith("def") && !att.startsWith("bool")) {
                String l = this.getMinMaxDefault(null, null, result, field);
                if (this.lab[field] == null) continue;
                ((JLabel)this.lab[field].getComponent(1)).setText(" " + l);
                continue;
            }
            if (type.startsWith("min")) {
                String l = this.getMinMaxDefault(result, null, null, field);
                if (this.lab[field] == null) continue;
                ((JLabel)this.lab[field].getComponent(1)).setText(" " + l);
                continue;
            }
            if (!type.startsWith("max")) continue;
            String l = this.getMinMaxDefault(null, result, null, field);
            if (this.lab[field] == null) continue;
            ((JLabel)this.lab[field].getComponent(1)).setText(" " + l);
        }
        if (!this.isShadedGUI) {
            this.sectionResize(BuildJembossForm.addSection);
            this.sectionResize(BuildJembossForm.advSection);
            this.sectionResize(BuildJembossForm.reqdSection);
            this.sectionResize(BuildJembossForm.outSection);
        }
        this.p3.setVisible(false);
        this.p3.setVisible(true);
    }

    private void setShadingAndVisibility(Component c, boolean useThis, int field) {
        if (c != null) {
            if (this.isShadedGUI) {
                c.setEnabled(useThis);
            } else {
                c.setVisible(useThis);
                if (this.lab[field] != null) {
                    this.lab[field].setVisible(useThis);
                }
            }
        }
    }

    private void sectionResize(JPanel p) {
        if (p != null) {
            Dimension min = p.getMinimumSize();
            int w = 498;
            int h = (int)min.getHeight();
            Dimension d = new Dimension(w, h);
            p.setMaximumSize(d);
            p.setPreferredSize(d);
            p.setVisible(false);
            p.setVisible(true);
        }
    }

    static {
        labelColor = new Color(0, 0, 0);
        labfont = new Font("SansSerif", 1, 12);
        labfont2 = new Font("SansSerif", 1, 11);
    }
}

