/*
 * Decompiled with CFR 0.152.
 */
package org.adl.datamodels.cmi;

import java.io.Serializable;
import java.lang.reflect.Field;
import org.adl.datamodels.Element;
import org.adl.datamodels.cmi.CMICategory;
import org.adl.datamodels.cmi.CMIRequest;
import org.adl.datamodels.cmi.CMIScore;
import org.adl.datamodels.cmi.DMErrorManager;
import org.adl.util.debug.DebugIndicator;

public class CMIObjectiveData
extends CMICategory
implements Serializable {
    public Element id = new Element("", "checkIdentifier", "NULL", true, true, false);
    public CMIScore score = new CMIScore();
    public Element status = new Element("", "checkVocabulary", "Status", true, true, false);
    private boolean initialized;
    static int CMIOBJECTIVEDATA_MIN_NUM_TOKENS = 3;

    public CMIObjectiveData() {
        super(true);
    }

    public Element getStatus() {
        return this.status;
    }

    public CMIScore getScore() {
        return this.score;
    }

    public Element getId() {
        return this.id;
    }

    public void setStatus(String inStatus) {
        this.status.setValue(inStatus);
    }

    public void setScore(CMIScore inScore) {
        this.score.getRaw().setValue(inScore.getRaw().getValue());
        this.score.getMin().setValue(inScore.getMin().getValue());
        this.score.getMax().setValue(inScore.getMax().getValue());
    }

    public void setId(String inID) {
        this.id.setValue(inID);
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public String performGet(CMIRequest theRequest, DMErrorManager dmErrorMgr) {
        if (DebugIndicator.ON) {
            System.out.println("CMIObjectiveData::performGet()");
        }
        String result = new String("");
        if (this.isValidObjectiveDataRequest(theRequest)) {
            String token = theRequest.getNextToken();
            if (DebugIndicator.ON) {
                System.out.println("Token: " + token);
            }
            result = theRequest.hasMoreTokensToProcess() ? this.processSubcategory(theRequest, token, dmErrorMgr) : (theRequest.isAChildrenRequest() ? this.getChildren() : this.determineElementValue(this, token, dmErrorMgr));
        } else {
            if (DebugIndicator.ON) {
                System.out.println("Error - Data Model Element not implemented");
                System.out.println("Request being processed: " + theRequest.getRequest() + "\nis not a valid request for the CMI Objective\n" + "Data Model Category");
            }
            dmErrorMgr.recNotImplementedError(theRequest);
        }
        theRequest.done();
        return result;
    }

    public String getChildren() {
        String children = "id,status,score";
        return children;
    }

    public void performSet(CMIRequest theRequest, DMErrorManager dmErrorMgr) {
        if (this.isValidObjectiveDataRequest(theRequest)) {
            String token = theRequest.getNextToken();
            if (theRequest.hasMoreTokensToProcess()) {
                String result = this.processSubcategory(theRequest, token, dmErrorMgr);
            } else {
                String value = theRequest.getValue();
                if (theRequest.isAKeywordRequest()) {
                    dmErrorMgr.recKeyWordError(token);
                } else {
                    this.doSet(this, token, value, dmErrorMgr);
                    this.initialized = true;
                }
            }
        } else {
            if (DebugIndicator.ON) {
                System.out.println("Error - Data Model Element not implemented");
                System.out.println("Request being processed: " + theRequest.getRequest() + "\nis not a valid request for the CMI Objective\n" + "Data Model Category");
            }
            dmErrorMgr.recNotImplementedError(theRequest);
        }
        theRequest.done();
    }

    private String processSubcategory(CMIRequest theRequest, String theElement, DMErrorManager dmErrorMgr) {
        if (DebugIndicator.ON) {
            System.out.println("In CMIObjectiveData::processSubcategory()");
            System.out.println("The Element: " + theElement);
        }
        String result = new String("");
        try {
            Field tmpField = this.getClass().getField(theElement);
            if (theRequest.isForASetRequest()) {
                if (theRequest.isAKeywordRequest()) {
                    dmErrorMgr.recKeyWordError(theRequest.getElement());
                } else {
                    this.score.performSet(theRequest, dmErrorMgr);
                }
            } else if (theElement.equals("score")) {
                result = this.score.performGet(theRequest, dmErrorMgr);
            } else if (theRequest.isAKeywordRequest()) {
                dmErrorMgr.recGetKeyWordError(theRequest.getElement());
            } else {
                dmErrorMgr.recNotImplementedError(theRequest);
            }
        }
        catch (NoSuchFieldException nsfe) {
            if (DebugIndicator.ON) {
                System.out.println("Error - Data Model Element not implemented");
                System.out.println("Element being processed: " + theElement + "is not a valid sub category of the CMI " + "Objectives\nData Model Category");
            }
            dmErrorMgr.SetCurrentErrorCode("401");
        }
        catch (SecurityException se) {
            if (DebugIndicator.ON) {
                System.out.println(se);
                System.out.println("Access to the information is denied");
            }
            dmErrorMgr.SetCurrentErrorCode("101");
        }
        return result;
    }

    private boolean isValidObjectiveDataRequest(CMIRequest theRequest) {
        boolean rtrnFlag = false;
        if (theRequest.getTotalNumTokens() >= CMIOBJECTIVEDATA_MIN_NUM_TOKENS) {
            rtrnFlag = true;
        }
        return rtrnFlag;
    }

    public String isValidRequest(CMIRequest theRequest, DMErrorManager dmErrorMgr) {
        boolean flag = false;
        String result = new String("");
        if (theRequest.getTotalNumTokens() <= 5) {
            String token = theRequest.getNextToken();
            if (DebugIndicator.ON) {
                System.out.println("token: " + token);
            }
            if (token.equals("id") || token.equals("status")) {
                if (theRequest.hasMoreTokensToProcess()) {
                    flag = false;
                    dmErrorMgr.recNotImplementedError(theRequest);
                } else {
                    dmErrorMgr.SetCurrentErrorCode("0");
                }
            } else if (token.equals("score")) {
                flag = this.score.isValidRequest(theRequest);
                if (theRequest.isAChildrenRequest()) {
                    result = this.score.getChildren();
                }
            }
        } else {
            dmErrorMgr.recNotImplementedError(theRequest);
        }
        return result;
    }

    public void showData() {
        if (DebugIndicator.ON) {
            System.out.println("CMI Objective Data Object:");
            System.out.println("\tid: " + this.getId().getValue());
            System.out.println("\tstatus: " + this.getStatus().getValue());
            System.out.println("\tscore.raw: " + this.getScore().getRaw().getValue());
            System.out.println("\tscore.min: " + this.getScore().getMin().getValue());
            System.out.println("\tscore.max: " + this.getScore().getMax().getValue());
        }
    }
}

