__author__ = "Anders Logg (logg@simula.no)"
__date__ = "2008-12-02 -- 2009-12-11"
__copyright__ = "Copyright (C) 2008-2009 Anders Logg"
__license__  = "GNU LGPL Version 2.1"

# Modified by Johan Hake, 2008.

__all__ = ["Constant"]

# Import UFL and SWIG-generated extension module (DOLFIN C++)
import ufl
import dolfin.cpp as cpp

class Constant(ufl.Coefficient, cpp.Constant):

    def __init__(self, value):
        """Create constant-valued function with given value.

        The value may be either a single scalar value or a tuple/list of
        values for vector-valued functions."""

        # Create UFL element
        if isinstance(value, (float, int)):
            self._ufl_element = ufl.FiniteElement("Discontinuous Lagrange", None, 0)
        elif isinstance(value, (tuple, list)):
            self._ufl_element = ufl.VectorElement("Discontinuous Lagrange", None, 0, len(value))
        else:
            cpp.error("Unable to handle tensor-valued constants (should be possible to fix).")

        # Initialize base classes
        ufl.Coefficient.__init__(self, self._ufl_element)
        cpp.Constant.__init__(self, _to_float(value))

def _to_float(value):
    "Convert to float or a (nested) list of floats."

    if isinstance(value, (float, int)):
        return float(value)
    elif isinstance(value, (tuple, list)):
        return [_to_float(v) for v in value]
    else:
        cpp.error("Unable to interpret value for constant: " + str(value))
