/* ****************************************************************************
 *
 * Copyright (c) Microsoft Corporation. 
 *
 * This source code is subject to terms and conditions of the Microsoft Public License. A 
 * copy of the license can be found in the License.html file at the root of this distribution. If 
 * you cannot locate the  Microsoft Public License, please send an email to 
 * dlr@microsoft.com. By using this source code in any fashion, you are agreeing to be bound 
 * by the terms of the Microsoft Public License.
 *
 * You must not remove this notice, or any other, from this software.
 *
 *
 * ***************************************************************************/

using IronPython.Runtime.Exceptions;
using IronPython.Runtime.Types;

namespace IronPython.Modules {
    public static partial class Builtin {
        #region Generated builtin exceptions

        // *** BEGIN GENERATED CODE ***
        // generated by function: builtin_gen from: generate_exceptions.py

        public static PythonType GeneratorExit {
            get { return PythonExceptions.GeneratorExit; }
        }
        public static PythonType SystemExit {
            get { return PythonExceptions.SystemExit; }
        }
        public static PythonType KeyboardInterrupt {
            get { return PythonExceptions.KeyboardInterrupt; }
        }
        public static PythonType Exception {
            get { return PythonExceptions.Exception; }
        }
        public static PythonType StopIteration {
            get { return PythonExceptions.StopIteration; }
        }
        public static PythonType StandardError {
            get { return PythonExceptions.StandardError; }
        }
        public static PythonType BufferError {
            get { return PythonExceptions.BufferError; }
        }
        public static PythonType ArithmeticError {
            get { return PythonExceptions.ArithmeticError; }
        }
        public static PythonType FloatingPointError {
            get { return PythonExceptions.FloatingPointError; }
        }
        public static PythonType OverflowError {
            get { return PythonExceptions.OverflowError; }
        }
        public static PythonType ZeroDivisionError {
            get { return PythonExceptions.ZeroDivisionError; }
        }
        public static PythonType AssertionError {
            get { return PythonExceptions.AssertionError; }
        }
        public static PythonType AttributeError {
            get { return PythonExceptions.AttributeError; }
        }
        public static PythonType EnvironmentError {
            get { return PythonExceptions.EnvironmentError; }
        }
        public static PythonType IOError {
            get { return PythonExceptions.IOError; }
        }
        public static PythonType OSError {
            get { return PythonExceptions.OSError; }
        }
        public static PythonType WindowsError {
            get { return PythonExceptions.WindowsError; }
        }
        public static PythonType EOFError {
            get { return PythonExceptions.EOFError; }
        }
        public static PythonType ImportError {
            get { return PythonExceptions.ImportError; }
        }
        public static PythonType LookupError {
            get { return PythonExceptions.LookupError; }
        }
        public static PythonType IndexError {
            get { return PythonExceptions.IndexError; }
        }
        public static PythonType KeyError {
            get { return PythonExceptions.KeyError; }
        }
        public static PythonType MemoryError {
            get { return PythonExceptions.MemoryError; }
        }
        public static PythonType NameError {
            get { return PythonExceptions.NameError; }
        }
        public static PythonType UnboundLocalError {
            get { return PythonExceptions.UnboundLocalError; }
        }
        public static PythonType ReferenceError {
            get { return PythonExceptions.ReferenceError; }
        }
        public static PythonType RuntimeError {
            get { return PythonExceptions.RuntimeError; }
        }
        public static PythonType NotImplementedError {
            get { return PythonExceptions.NotImplementedError; }
        }
        public static PythonType SyntaxError {
            get { return PythonExceptions.SyntaxError; }
        }
        public static PythonType IndentationError {
            get { return PythonExceptions.IndentationError; }
        }
        public static PythonType TabError {
            get { return PythonExceptions.TabError; }
        }
        public static PythonType SystemError {
            get { return PythonExceptions.SystemError; }
        }
        public static PythonType TypeError {
            get { return PythonExceptions.TypeError; }
        }
        public static PythonType ValueError {
            get { return PythonExceptions.ValueError; }
        }
        public static PythonType UnicodeError {
            get { return PythonExceptions.UnicodeError; }
        }

#if !SILVERLIGHT
        public static PythonType UnicodeDecodeError {
            get { return PythonExceptions.UnicodeDecodeError; }
        }
#endif // !SILVERLIGHT


#if !SILVERLIGHT
        public static PythonType UnicodeEncodeError {
            get { return PythonExceptions.UnicodeEncodeError; }
        }
#endif // !SILVERLIGHT

        public static PythonType UnicodeTranslateError {
            get { return PythonExceptions.UnicodeTranslateError; }
        }
        public static PythonType Warning {
            get { return PythonExceptions.Warning; }
        }
        public static PythonType DeprecationWarning {
            get { return PythonExceptions.DeprecationWarning; }
        }
        public static PythonType PendingDeprecationWarning {
            get { return PythonExceptions.PendingDeprecationWarning; }
        }
        public static PythonType RuntimeWarning {
            get { return PythonExceptions.RuntimeWarning; }
        }
        public static PythonType SyntaxWarning {
            get { return PythonExceptions.SyntaxWarning; }
        }
        public static PythonType UserWarning {
            get { return PythonExceptions.UserWarning; }
        }
        public static PythonType FutureWarning {
            get { return PythonExceptions.FutureWarning; }
        }
        public static PythonType ImportWarning {
            get { return PythonExceptions.ImportWarning; }
        }
        public static PythonType UnicodeWarning {
            get { return PythonExceptions.UnicodeWarning; }
        }
        public static PythonType BytesWarning {
            get { return PythonExceptions.BytesWarning; }
        }

        // *** END GENERATED CODE ***

        #endregion

    }
}
