#ifndef _LINEPROCESSOR_H_INCLUDED
#define _LINEPROCESSOR_H_INCLUDED

#include "jacklow.h"

class Effect;

class LineProcessor : public Processor
{
public:
	LineProcessor(Port *in_left, Port *in_right, Port *out_left, Port *out_right);
	~LineProcessor();

	void setGain(float g);
	void addEffect(Effect *);
	void removeEffect(Effect *);
	void addPostFaderEffect(Effect *);
	void removePostFaderEffect(Effect *);
protected:
	Port *p_in_left;
	Port *p_in_right;
	Port *p_out_left;
	Port *p_out_right;
	float p_gain;
	int process(jack_nframes_t nsamples, void *arg);
	QValueList<Effect *> effects;
	QValueList<Effect *> postfader_effects;

	friend class Client;
};

#endif
