#!/bin/sh
### BEGIN INIT INFO
# Provides:		dhcp-probe
# Required-Start:    $remote_fs $network $syslog
# Required-Stop:     $remote_fs $network $syslog
# Default-Start:     2 3 4 5
# Default-Stop:      0 1 6
# Short-Description: dhcp-probe daemon to survey DHCP/BootP server on LAN
### END INIT INFO


PATH=/usr/local/sbin:/usr/local/bin:/sbin:/bin:/usr/sbin:/usr/bin
DAEMON=/usr/sbin/dhcp_probe
NAME="dhcp-probe"
PIDFILE="dhcp_probe.pid"
BASE_RUNNING="/var/run"
BASEPIDFILE="$BASE_RUNNING/$NAME"
INITPIDFILE="$BASEPIDFILE/$PIDFILE"
DESC="$NAME daemon"
ETC="/etc"
#DEFAULT="$ETC/default"
LOGDIR="/var/log/$NAME.log"
DODTIME=2   

test -x $DAEMON || exit 0

set -e

if [ -f /lib/lsb/init-functions ]; then 
	. /lib/lsb/init-functions
fi

running_pid() {
    # Check if a given process pid's cmdline matches a given name
    pid=$1
    name=$2
    [ -z "$pid" ] && return 1
    [ ! -d /proc/$pid ] &&  return 1
    cmd=`cat /proc/$pid/cmdline | tr "\000" "\n"|head -n 1 |cut -d : -f 1`
    # Is this the expected child?
    [ "$cmd" != "$name" ] &&  return 1
    return 0
}

running() {
	# Check if the process is running looking at /proc (works for all users)
  sleep 1
	INTERFACE=$1
	PIDFILE="$INITPIDFILE.$INTERFACE"
  # No pidfile, probably no daemon present
	if [ -f "$PIDFILE" ]; then
 	  pid=`cat "$PIDFILE"`
	  running_pid $pid $DAEMON || return 1
    return 0
  else
    return 1
  fi
  # Obtain the pid and check it against the binary name
}

force_stop() {
# Forcefully kill the process
	for config_file in `find $ETC/$NAME/ -type f -print`
	do
		. $config_file
		PIDFILE="$INITPIDFILE.$INTERFACE"
    [ ! -f "$PIDFILE" ] && return
    if running $INTERFACE; then
        start-start_daemon -K 15 --quiet --pidfile $PIDFILE \
				--exec $DAEMON -- $DAEMON_OPTS
        # Is it really dead?
        [ -n "$DODTIME" ] && sleep "$DODTIME"s
        if running $INTERFACE; then
						start-start_daemon -K 9 --quiet --pidfile $PIDFILE \
						--exec $DAEMON -- $DAEMON_OPTS
            [ -n "$DODTIME" ] && sleep "$DODTIME"s
            if running $INTERFACE; then
                echo "Cannot kill $LABEL (pid=$pid)!"
                exit 1
            fi
        fi
    fi
    rm -f $PIDFILE
	done
  return 0
}

start_daemon() {
# Start one daemon for each network interface
	for config_file in `find $ETC/$NAME/ -type f -print`
	do
		. $config_file
		PIDFILE="$INITPIDFILE.$INTERFACE"
		DAEMON_OPTS="-T -p $PIDFILE $INTERFACE"
		echo -n "Starting $DESC on interface $INTERFACE: "
		start-stop-daemon --start --quiet --pidfile $PIDFILE \
		--exec $DAEMON -- $DAEMON_OPTS
		if running $INTERFACE; then
			echo " Done."
		else
			echo " Failed!"
		fi
	done
}

stop_daemon() {
# Stop all existing dhcp_probe daemon
	for config_file in `find $ETC/$NAME/ -type f -print`
	do
		. $config_file
		PIDFILE="$INITPIDFILE.$INTERFACE"
		if [ -f $PIDFILE ]; then
			echo -n "Stopping $DESC on interface $INTERFACE: "
			start-stop-daemon --stop --quiet --pidfile $PIDFILE 
			echo "$NAME."
			rm -f $PIDFILE
		fi
	done
}




case "$1" in
  start)
		start_daemon
	;;

  stop)
		stop_daemon
	;;

  force-stop)
		for config_file in `find $ETC/$NAME/ -type f -print`
		do
			. $config_file
			PIDFILE="$INITPIDFILE.$INTERFACE"
			echo -n "Forcefully stopping $DESC: "
			force_stop
			if ! running $INTERFACE; then
				echo "$NAME on interface $INTERFACE."
			else
				echo " ERROR."
			fi
		done
	;;

	force-reload)	# Need to be improved
    echo "Reload operation is not supported -- use restart."
		exit 1
	;;

  restart)
    echo -n "Restarting $DESC: "
		stop_daemon
		[ -n "$DODTIME" ] && sleep $DODTIME
		start_daemon
		echo "$NAME."
	;;

  status)
		for config_file in `find $ETC/$NAME/ -type f -print`
		do
			. $config_file
			PIDFILE="$INITPIDFILE.$INTERFACE"
			echo -n "$LABEL is "
			if running $INTERFACE;  then
					echo "running on interface $INTERFACE"
			else
					echo " not running."
					exit 1
			fi
		done
    ;;

  *)
	N=/etc/init.d/$NAME
	echo "Usage: $N {start|stop|restart|status|force-stop}" >&2
	exit 1
	;;
esac

exit 0
