# Copyright 2009-2010 Canonical Ltd.
#
# This file is part of desktopcouch-notes.
#
#  desktopcouch is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License version 3
# as published by the Free Software Foundation.
#
# desktopcouch is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with desktopcouch.  If not, see <http://www.gnu.org/licenses/>.
#
# Authors: Nicola Larosa <nicola.larosa@canonical.com>
#          Rodrigo Moya <rodrigo.moya@canonical.com>

"""Tests for the NoteDocument class"""

import testtools
from time import (strftime, gmtime)
from desktopcouch.notes import record as note_mod

class TestNoteRecord(testtools.TestCase):
    """Test the Note Record object."""

    def test_note_record(self):
        """Test that we get the correct record type."""
        note = note_mod.Note()
        self.assertEqual(note_mod.NOTE_RECORD_TYPE, note.record_type)
        for field_name in note_mod.FIELDS:
            field_type = note_mod.FIELDS[field_name]
            if field_type == 'string':
                setattr(note, field_name, 'value')
                self.assertEqual('value', note._data[field_name])
                self.assertEqual(getattr(note, field_name), 'value')
            elif field_type == 'date':
                current_time = strftime("%Y-%m-%dT%H:%M:%S", gmtime())
                setattr(note, field_name, current_time)
                self.assertEqual(current_time, note._data[field_name])
                self.assertEqual(getattr(note, field_name), current_time)
            else:
                self.fail('Unknown field type: %s' % field_type)

        # Check all keys
        all_keys = set(note_mod.FIELDS)
        all_keys.add('record_type')
        self.assertEqual(set(note.keys()), all_keys)
