/* AssistantOperation.c generated by valac, the Vala compiler
 * generated from AssistantOperation.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*- */
/*
    This file is part of Déjà Dup.
    © 2008,2009 Michael Terry <mike@mterry.name>

    Déjà Dup is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Déjà Dup is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Déjà Dup.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <common.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gdk-pixbuf/gdk-pixdata.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>
#include <pango/pango.h>
#include <gconf/gconf-client.h>
#include <gdk/gdk.h>
#include <gnome-keyring.h>
#include <chacks.h>
#include <config.h>


#define TYPE_ASSISTANT (assistant_get_type ())
#define ASSISTANT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ASSISTANT, Assistant))
#define ASSISTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ASSISTANT, AssistantClass))
#define IS_ASSISTANT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ASSISTANT))
#define IS_ASSISTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ASSISTANT))
#define ASSISTANT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ASSISTANT, AssistantClass))

typedef struct _Assistant Assistant;
typedef struct _AssistantClass AssistantClass;
typedef struct _AssistantPrivate AssistantPrivate;

#define TYPE_ASSISTANT_OPERATION (assistant_operation_get_type ())
#define ASSISTANT_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ASSISTANT_OPERATION, AssistantOperation))
#define ASSISTANT_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ASSISTANT_OPERATION, AssistantOperationClass))
#define IS_ASSISTANT_OPERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ASSISTANT_OPERATION))
#define IS_ASSISTANT_OPERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ASSISTANT_OPERATION))
#define ASSISTANT_OPERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ASSISTANT_OPERATION, AssistantOperationClass))

typedef struct _AssistantOperation AssistantOperation;
typedef struct _AssistantOperationClass AssistantOperationClass;
typedef struct _AssistantOperationPrivate AssistantOperationPrivate;

#define TYPE_STATUS_ICON (status_icon_get_type ())
#define STATUS_ICON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STATUS_ICON, StatusIcon))
#define STATUS_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STATUS_ICON, StatusIconClass))
#define IS_STATUS_ICON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STATUS_ICON))
#define IS_STATUS_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STATUS_ICON))
#define STATUS_ICON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STATUS_ICON, StatusIconClass))

typedef struct _StatusIcon StatusIcon;
typedef struct _StatusIconClass StatusIconClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define ASSISTANT_TYPE_TYPE (assistant_type_get_type ())

#define TYPE_MOUNT_OPERATION_ASSISTANT (mount_operation_assistant_get_type ())
#define MOUNT_OPERATION_ASSISTANT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MOUNT_OPERATION_ASSISTANT, MountOperationAssistant))
#define MOUNT_OPERATION_ASSISTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MOUNT_OPERATION_ASSISTANT, MountOperationAssistantClass))
#define IS_MOUNT_OPERATION_ASSISTANT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MOUNT_OPERATION_ASSISTANT))
#define IS_MOUNT_OPERATION_ASSISTANT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MOUNT_OPERATION_ASSISTANT))
#define MOUNT_OPERATION_ASSISTANT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MOUNT_OPERATION_ASSISTANT, MountOperationAssistantClass))

typedef struct _MountOperationAssistant MountOperationAssistant;
typedef struct _MountOperationAssistantClass MountOperationAssistantClass;

struct _Assistant {
	GtkDialog parent_instance;
	AssistantPrivate * priv;
	GtkImage* header_icon;
	GtkEventBox* page_box;
};

struct _AssistantClass {
	GtkDialogClass parent_class;
};

struct _AssistantOperation {
	Assistant parent_instance;
	AssistantOperationPrivate * priv;
	gboolean succeeded;
	GtkLabel* summary_label;
	DejaDupOperation* op;
	GMountOperation* mount_op;
};

struct _AssistantOperationClass {
	AssistantClass parent_class;
	GtkWidget* (*make_confirm_page) (AssistantOperation* self);
	void (*add_setup_pages) (AssistantOperation* self);
	void (*add_custom_config_pages) (AssistantOperation* self);
	DejaDupOperation* (*create_op) (AssistantOperation* self);
	char* (*get_progress_file_prefix) (AssistantOperation* self);
	void (*set_op_icon_name) (AssistantOperation* self);
	GtkWidget* (*make_progress_page) (AssistantOperation* self);
	void (*show_error) (AssistantOperation* self, const char* _error_, const char* detail);
	GtkWidget* (*make_summary_page) (AssistantOperation* self);
	void (*do_prepare) (AssistantOperation* self, Assistant* assist, GtkWidget* page);
	void (*do_close) (AssistantOperation* self);
};

struct _AssistantOperationPrivate {
	GtkWidget* _confirm_page;
	gboolean _automatic;
	StatusIcon* status_icon;
	GtkEntry* encrypt_entry;
	GtkCheckButton* encrypt_remember;
	GtkWidget* _password_page;
	GtkLabel* question_label;
	GtkWidget* _question_page;
	GtkLabel* progress_label;
	GtkLabel* progress_file_label;
	GtkLabel* secondary_label;
	GtkProgressBar* progress_bar;
	GtkTextView* progress_text;
	GtkScrolledWindow* progress_scroll;
	GtkExpander* progress_expander;
	GtkWidget* _progress_page;
	GtkWidget* error_widget;
	GtkTextView* error_text_view;
	GtkWidget* _summary_page;
	GdkPixbuf* _op_icon;
	guint timeout_id;
	gboolean _error_occurred;
	gboolean gives_progress;
	gboolean saved_pos;
	gint saved_x;
	gint saved_y;
};

typedef enum  {
	ASSISTANT_TYPE_NORMAL,
	ASSISTANT_TYPE_INTERRUPT,
	ASSISTANT_TYPE_SUMMARY,
	ASSISTANT_TYPE_PROGRESS,
	ASSISTANT_TYPE_FINISH
} AssistantType;


static gpointer assistant_operation_parent_class = NULL;

GType assistant_get_type (void);
GType assistant_operation_get_type (void);
GType status_icon_get_type (void);
#define ASSISTANT_OPERATION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_ASSISTANT_OPERATION, AssistantOperationPrivate))
enum  {
	ASSISTANT_OPERATION_DUMMY_PROPERTY,
	ASSISTANT_OPERATION_CONFIRM_PAGE,
	ASSISTANT_OPERATION_AUTOMATIC,
	ASSISTANT_OPERATION_PASSWORD_PAGE,
	ASSISTANT_OPERATION_QUESTION_PAGE,
	ASSISTANT_OPERATION_PROGRESS_PAGE,
	ASSISTANT_OPERATION_SUMMARY_PAGE,
	ASSISTANT_OPERATION_OP_ICON,
	ASSISTANT_OPERATION_ERROR_OCCURRED
};
GtkWidget* assistant_operation_make_confirm_page (AssistantOperation* self);
static GtkWidget* assistant_operation_real_make_confirm_page (AssistantOperation* self);
void assistant_operation_add_setup_pages (AssistantOperation* self);
static void assistant_operation_real_add_setup_pages (AssistantOperation* self);
void assistant_operation_add_custom_config_pages (AssistantOperation* self);
static void assistant_operation_real_add_custom_config_pages (AssistantOperation* self);
DejaDupOperation* assistant_operation_create_op (AssistantOperation* self);
static DejaDupOperation* assistant_operation_real_create_op (AssistantOperation* self);
char* assistant_operation_get_progress_file_prefix (AssistantOperation* self);
static char* assistant_operation_real_get_progress_file_prefix (AssistantOperation* self);
void assistant_operation_set_op_icon_name (AssistantOperation* self);
static void assistant_operation_real_set_op_icon_name (AssistantOperation* self);
GdkPixbuf* assistant_operation_make_op_icon (AssistantOperation* self);
static gboolean assistant_operation_pulse (AssistantOperation* self);
static void assistant_operation_show_progress (AssistantOperation* self, DejaDupOperation* op, double percent);
static void assistant_operation_set_progress_label (AssistantOperation* self, DejaDupOperation* op, const char* label);
static void assistant_operation_set_progress_label_file (AssistantOperation* self, DejaDupOperation* op, GFile* file, gboolean actual);
GtkWidget* assistant_operation_get_progress_page (AssistantOperation* self);
static void assistant_operation_set_secondary_label (AssistantOperation* self, DejaDupOperation* op, const char* text);
GtkWidget* assistant_operation_make_progress_page (AssistantOperation* self);
static GtkWidget* assistant_operation_real_make_progress_page (AssistantOperation* self);
static void assistant_operation_set_error_occurred (AssistantOperation* self, gboolean value);
void assistant_go_to_page (Assistant* self, GtkWidget* page);
GtkWidget* assistant_operation_get_summary_page (AssistantOperation* self);
void assistant_set_header_icon (Assistant* self, const char* name);
void assistant_operation_show_error (AssistantOperation* self, const char* _error_, const char* detail);
static void assistant_operation_real_show_error (AssistantOperation* self, const char* _error_, const char* detail);
static void _lambda5_ (GtkToggleButton* button, AssistantOperation* self);
static void __lambda5__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
GtkWidget* assistant_operation_make_password_page (AssistantOperation* self);
GtkWidget* assistant_operation_make_question_page (AssistantOperation* self);
GtkWidget* assistant_operation_make_summary_page (AssistantOperation* self);
static GtkWidget* assistant_operation_real_make_summary_page (AssistantOperation* self);
static void assistant_operation_add_config_pages_if_needed (AssistantOperation* self);
GType assistant_type_get_type (void);
void assistant_append_page (Assistant* self, GtkWidget* page, AssistantType type);
void assistant_set_page_title (Assistant* self, GtkWidget* page, const char* title);
static void assistant_operation_set_confirm_page (AssistantOperation* self, GtkWidget* value);
static void assistant_operation_add_confirm_page (AssistantOperation* self);
static void assistant_operation_set_progress_page (AssistantOperation* self, GtkWidget* value);
static void assistant_operation_add_progress_page (AssistantOperation* self);
static void assistant_operation_set_password_page (AssistantOperation* self, GtkWidget* value);
static void assistant_operation_add_password_page (AssistantOperation* self);
static void assistant_operation_set_question_page (AssistantOperation* self, GtkWidget* value);
static void assistant_operation_add_question_page (AssistantOperation* self);
static void assistant_operation_set_summary_page (AssistantOperation* self, GtkWidget* value);
static void assistant_operation_add_summary_page (AssistantOperation* self);
void assistant_operation_do_close (AssistantOperation* self);
void assistant_operation_force_visible (AssistantOperation* self, gboolean user_click);
static void assistant_operation_apply_finished (AssistantOperation* self, DejaDupOperation* op, gboolean success, gboolean cancelled);
MountOperationAssistant* mount_operation_assistant_new (AssistantOperation* assist);
MountOperationAssistant* mount_operation_assistant_construct (GType object_type, AssistantOperation* assist);
GType mount_operation_assistant_get_type (void);
static void _assistant_operation_apply_finished_deja_dup_operation_done (DejaDupOperation* _sender, gboolean success, gboolean cancelled, gpointer self);
static void _lambda13_ (DejaDupOperation* o, const char* e, const char* d, AssistantOperation* self);
static void __lambda13__deja_dup_operation_raise_error (DejaDupOperation* _sender, const char* errstr, const char* detail, gpointer self);
void assistant_operation_get_passphrase (AssistantOperation* self);
static void _assistant_operation_get_passphrase_deja_dup_operation_passphrase_required (DejaDupOperation* _sender, gpointer self);
static void _assistant_operation_set_progress_label_deja_dup_operation_action_desc_changed (DejaDupOperation* _sender, const char* action, gpointer self);
static void _assistant_operation_set_progress_label_file_deja_dup_operation_action_file_changed (DejaDupOperation* _sender, GFile* file, gboolean actual, gpointer self);
static void _assistant_operation_show_progress_deja_dup_operation_progress (DejaDupOperation* _sender, double percent, gpointer self);
static void assistant_operation_show_question (AssistantOperation* self, DejaDupOperation* op, const char* title, const char* message);
static void _assistant_operation_show_question_deja_dup_operation_question (DejaDupOperation* _sender, const char* title, const char* msg, gpointer self);
static void _assistant_operation_set_secondary_label_deja_dup_operation_secondary_desc_changed (DejaDupOperation* _sender, const char* msg, gpointer self);
static void assistant_operation_pause_op (AssistantOperation* self, DejaDupBackend* back, const char* header, const char* msg);
static void _assistant_operation_pause_op_deja_dup_backend_pause_op (DejaDupBackend* _sender, const char* header, const char* msg, gpointer self);
gboolean assistant_operation_get_automatic (AssistantOperation* self);
StatusIcon* status_icon_new (GtkWindow* window, DejaDupOperation* op, gboolean automatic);
StatusIcon* status_icon_construct (GType object_type, GtkWindow* window, DejaDupOperation* op, gboolean automatic);
static void assistant_operation_toggle_window (AssistantOperation* self, guint time, gboolean user_click);
static void _lambda14_ (StatusIcon* s, AssistantOperation* self);
static void __lambda14__status_icon_toggle_window (StatusIcon* _sender, gpointer self);
void assistant_operation_hide_everything (AssistantOperation* self);
static void _lambda15_ (StatusIcon* s, AssistantOperation* self);
static void __lambda15__status_icon_hide_all (StatusIcon* _sender, gpointer self);
static void assistant_operation_do_apply (AssistantOperation* self);
GtkWidget* assistant_operation_get_confirm_page (AssistantOperation* self);
static gboolean _assistant_operation_pulse_gsource_func (gpointer self);
void assistant_operation_provide_password (AssistantOperation* self);
GtkWidget* assistant_operation_get_password_page (AssistantOperation* self);
void assistant_operation_do_prepare (AssistantOperation* self, Assistant* assist, GtkWidget* page);
static void assistant_operation_real_do_prepare (AssistantOperation* self, Assistant* assist, GtkWidget* page);
static void assistant_operation_do_cancel (AssistantOperation* self);
static gboolean _lambda6_ (AssistantOperation* self);
static gboolean __lambda6__gsource_func (gpointer self);
static void assistant_operation_real_do_close (AssistantOperation* self);
static void assistant_operation_show_to_user (AssistantOperation* self, GtkWindow* win, guint time, gboolean user_click);
static gboolean assistant_operation_user_focused (AssistantOperation* self, GtkWidget* win, GdkEventFocus* e);
static gboolean _assistant_operation_user_focused_gtk_widget_focus_in_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self);
static void assistant_operation_ask_passphrase (AssistantOperation* self);
static void assistant_operation_found_passphrase (AssistantOperation* self, GnomeKeyringResult _result_, const char* str);
static void _assistant_operation_found_passphrase_gnome_keyring_operation_get_string_callback (GnomeKeyringResult _result_, const char* str, gpointer self);
static void assistant_operation_save_password_callback (AssistantOperation* self, GnomeKeyringResult _result_);
void assistant_interrupt (Assistant* self, GtkWidget* page, gboolean can_continue);
static void _assistant_operation_save_password_callback_gnome_keyring_operation_done_callback (GnomeKeyringResult _result_, gpointer self);
static void assistant_operation_stop_question (AssistantOperation* self, GtkDialog* dlg, gint resp);
static void _assistant_operation_stop_question_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
GtkWidget* assistant_operation_get_question_page (AssistantOperation* self);
AssistantOperation* assistant_operation_construct (GType object_type);
static void assistant_operation_set_automatic (AssistantOperation* self, gboolean value);
GdkPixbuf* assistant_operation_get_op_icon (AssistantOperation* self);
static void assistant_operation_set_op_icon (AssistantOperation* self, GdkPixbuf* value);
gboolean assistant_operation_get_error_occurred (AssistantOperation* self);
static void _assistant_operation_do_cancel_assistant_canceled (Assistant* _sender, gpointer self);
static void _assistant_operation_do_close_assistant_closed (Assistant* _sender, gpointer self);
static void _assistant_operation_do_prepare_assistant_prepare (Assistant* _sender, GtkWidget* page, gpointer self);
static GObject * assistant_operation_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void assistant_operation_finalize (GObject* obj);
static void assistant_operation_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void assistant_operation_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static int _vala_strcmp0 (const char * str1, const char * str2);



static GtkWidget* assistant_operation_real_make_confirm_page (AssistantOperation* self) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `assistant_operation_make_confirm_page'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


GtkWidget* assistant_operation_make_confirm_page (AssistantOperation* self) {
	return ASSISTANT_OPERATION_GET_CLASS (self)->make_confirm_page (self);
}


static void assistant_operation_real_add_setup_pages (AssistantOperation* self) {
	g_return_if_fail (self != NULL);
}


void assistant_operation_add_setup_pages (AssistantOperation* self) {
	ASSISTANT_OPERATION_GET_CLASS (self)->add_setup_pages (self);
}


static void assistant_operation_real_add_custom_config_pages (AssistantOperation* self) {
	g_return_if_fail (self != NULL);
}


void assistant_operation_add_custom_config_pages (AssistantOperation* self) {
	ASSISTANT_OPERATION_GET_CLASS (self)->add_custom_config_pages (self);
}


static DejaDupOperation* assistant_operation_real_create_op (AssistantOperation* self) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `assistant_operation_create_op'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


DejaDupOperation* assistant_operation_create_op (AssistantOperation* self) {
	return ASSISTANT_OPERATION_GET_CLASS (self)->create_op (self);
}


static char* assistant_operation_real_get_progress_file_prefix (AssistantOperation* self) {
	g_return_val_if_fail (self != NULL, NULL);
	g_critical ("Type `%s' does not implement abstract method `assistant_operation_get_progress_file_prefix'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


char* assistant_operation_get_progress_file_prefix (AssistantOperation* self) {
	return ASSISTANT_OPERATION_GET_CLASS (self)->get_progress_file_prefix (self);
}


static void assistant_operation_real_set_op_icon_name (AssistantOperation* self) {
	g_return_if_fail (self != NULL);
}


void assistant_operation_set_op_icon_name (AssistantOperation* self) {
	ASSISTANT_OPERATION_GET_CLASS (self)->set_op_icon_name (self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


GdkPixbuf* assistant_operation_make_op_icon (AssistantOperation* self) {
	GdkPixbuf* result = NULL;
	GError * _inner_error_;
	g_return_val_if_fail (self != NULL, NULL);
	_inner_error_ = NULL;
	if (gtk_window_get_icon_name ((GtkWindow*) self) == NULL) {
		result = NULL;
		return result;
	}
	{
		GtkIconTheme* theme;
		GdkPixbuf* _tmp0_;
		theme = _g_object_ref0 (gtk_icon_theme_get_for_screen (gtk_window_get_screen ((GtkWindow*) self)));
		_tmp0_ = gtk_icon_theme_load_icon (theme, gtk_window_get_icon_name ((GtkWindow*) self), 48, GTK_ICON_LOOKUP_FORCE_SIZE, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (theme);
			goto __catch2_g_error;
		}
		result = _g_object_ref0 (_tmp0_);
		_g_object_unref0 (theme);
		return result;
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("AssistantOperation.vala:100: %s\n", e->message);
			result = NULL;
			_g_error_free0 (e);
			return result;
		}
	}
	__finally2:
	{
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static gboolean assistant_operation_pulse (AssistantOperation* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (!self->priv->gives_progress) {
		gtk_progress_bar_pulse (self->priv->progress_bar);
	}
	result = TRUE;
	return result;
}


static void assistant_operation_show_progress (AssistantOperation* self, DejaDupOperation* op, double percent) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (op != NULL);
	gtk_progress_bar_set_fraction (self->priv->progress_bar, percent);
	self->priv->gives_progress = TRUE;
}


static void assistant_operation_set_progress_label (AssistantOperation* self, DejaDupOperation* op, const char* label) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (op != NULL);
	g_return_if_fail (label != NULL);
	gtk_label_set_label (self->priv->progress_label, label);
	gtk_label_set_label (self->priv->progress_file_label, "");
}


static void assistant_operation_set_progress_label_file (AssistantOperation* self, DejaDupOperation* op, GFile* file, gboolean actual) {
	char* parse_name;
	char* prefix;
	char* _tmp4_;
	char* _tmp5_;
	char* log_line;
	gboolean adjustment_at_end;
	GtkAdjustment* adjust;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	GtkTextBuffer* buffer;
	gboolean _tmp9_ = FALSE;
	GtkTextIter iter = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (op != NULL);
	g_return_if_fail (file != NULL);
	parse_name = g_file_get_parse_name (file);
	prefix = NULL;
	if (actual) {
		char* _tmp0_;
		char* _tmp1_;
		char* _tmp2_;
		prefix = (_tmp0_ = assistant_operation_get_progress_file_prefix (self), _g_free0 (prefix), _tmp0_);
		gtk_label_set_label (self->priv->progress_label, _tmp1_ = g_strconcat (prefix, " ", NULL));
		_g_free0 (_tmp1_);
		gtk_label_set_label (self->priv->progress_file_label, _tmp2_ = g_path_get_basename (parse_name));
		_g_free0 (_tmp2_);
	} else {
		char* _tmp3_;
		prefix = (_tmp3_ = g_strdup (_ ("Scanning:")), _g_free0 (prefix), _tmp3_);
		gtk_label_set_label (self->priv->progress_label, _ ("Scanning…"));
		gtk_label_set_label (self->priv->progress_file_label, "");
	}
	log_line = (_tmp5_ = g_strconcat (_tmp4_ = g_strconcat (prefix, " ", NULL), parse_name, NULL), _g_free0 (_tmp4_), _tmp5_);
	adjustment_at_end = FALSE;
	adjust = _g_object_ref0 (self->priv->progress_text->vadjustment);
	if (gtk_adjustment_get_value (adjust) >= (gtk_adjustment_get_upper (adjust) - gtk_adjustment_get_page_size (adjust))) {
		_tmp7_ = TRUE;
	} else {
		_tmp7_ = gtk_adjustment_get_page_size (adjust) == 0;
	}
	if (_tmp7_) {
		_tmp6_ = TRUE;
	} else {
		_tmp6_ = !gtk_expander_get_expanded (self->priv->progress_expander);
	}
	if (_tmp6_) {
		adjustment_at_end = TRUE;
	}
	buffer = _g_object_ref0 (gtk_text_view_get_buffer (self->priv->progress_text));
	if (gtk_text_buffer_get_char_count (buffer) > 0) {
		char* _tmp8_;
		log_line = (_tmp8_ = g_strconcat ("\n", log_line, NULL), _g_free0 (log_line), _tmp8_);
	}
	if (gtk_text_buffer_get_line_count (buffer) >= 100) {
		_tmp9_ = adjustment_at_end;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		GtkTextIter start = {0};
		GtkTextIter line100 = {0};
		gtk_text_buffer_get_start_iter (buffer, &start);
		gtk_text_buffer_get_iter_at_line (buffer, &line100, gtk_text_buffer_get_line_count (buffer) - 100);
		gtk_text_buffer_delete (buffer, &start, &line100);
	}
	gtk_text_buffer_get_end_iter (buffer, &iter);
	g_signal_emit_by_name (buffer, "insert-text", &iter, log_line, (gint) strlen (log_line));
	if (adjustment_at_end) {
		gtk_adjustment_set_value (adjust, gtk_adjustment_get_upper (adjust));
	}
	_g_free0 (parse_name);
	_g_free0 (prefix);
	_g_free0 (log_line);
	_g_object_unref0 (adjust);
	_g_object_unref0 (buffer);
}


static void assistant_operation_set_secondary_label (AssistantOperation* self, DejaDupOperation* op, const char* text) {
	GtkVBox* page;
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (op != NULL);
	g_return_if_fail (text != NULL);
	page = _g_object_ref0 (GTK_VBOX (self->priv->_progress_page));
	if (text != NULL) {
		_tmp0_ = _vala_strcmp0 (text, "") != 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		char* _tmp2_;
		char* _tmp1_;
		gtk_label_set_label (self->priv->secondary_label, _tmp2_ = g_strconcat (_tmp1_ = g_strconcat ("<i>", text, NULL), "</i>", NULL));
		_g_free0 (_tmp2_);
		_g_free0 (_tmp1_);
		gtk_widget_show ((GtkWidget*) self->priv->secondary_label);
		gtk_container_add ((GtkContainer*) page, (GtkWidget*) self->priv->secondary_label);
		gtk_box_reorder_child ((GtkBox*) page, (GtkWidget*) self->priv->secondary_label, 1);
		gtk_container_child_set ((GtkContainer*) page, (GtkWidget*) self->priv->secondary_label, "expand", FALSE, NULL);
	} else {
		gtk_container_remove ((GtkContainer*) page, (GtkWidget*) self->priv->secondary_label);
	}
	_g_object_unref0 (page);
}


static GtkWidget* assistant_operation_real_make_progress_page (AssistantOperation* self) {
	GtkWidget* result = NULL;
	GtkLabel* _tmp0_;
	GtkLabel* _tmp1_;
	GtkHBox* progress_hbox;
	GtkProgressBar* _tmp2_;
	GtkLabel* _tmp3_;
	GtkTextView* _tmp4_;
	GtkScrolledWindow* _tmp5_;
	GtkExpander* _tmp6_;
	GtkVBox* page;
	g_return_val_if_fail (self != NULL, NULL);
	self->priv->progress_label = (_tmp0_ = g_object_ref_sink ((GtkLabel*) gtk_label_new ("")), _g_object_unref0 (self->priv->progress_label), _tmp0_);
	g_object_set ((GObject*) self->priv->progress_label, "xalign", 0.0f, NULL);
	self->priv->progress_file_label = (_tmp1_ = g_object_ref_sink ((GtkLabel*) gtk_label_new ("")), _g_object_unref0 (self->priv->progress_file_label), _tmp1_);
	g_object_set ((GObject*) self->priv->progress_file_label, "xalign", 0.0f, "ellipsize", PANGO_ELLIPSIZE_MIDDLE, NULL);
	progress_hbox = g_object_ref_sink ((GtkHBox*) gtk_hbox_new (FALSE, 0));
	g_object_set ((GObject*) progress_hbox, "child", self->priv->progress_label, "child", self->priv->progress_file_label, NULL);
	gtk_container_child_set ((GtkContainer*) progress_hbox, (GtkWidget*) self->priv->progress_label, "expand", FALSE, NULL);
	self->priv->progress_bar = (_tmp2_ = g_object_ref_sink ((GtkProgressBar*) gtk_progress_bar_new ()), _g_object_unref0 (self->priv->progress_bar), _tmp2_);
	self->priv->secondary_label = (_tmp3_ = g_object_ref_sink ((GtkLabel*) gtk_label_new ("")), _g_object_unref0 (self->priv->secondary_label), _tmp3_);
	g_object_set ((GObject*) self->priv->secondary_label, "xalign", 0.0f, "wrap", TRUE, "use-markup", TRUE, NULL);
	self->priv->progress_text = (_tmp4_ = g_object_ref_sink ((GtkTextView*) gtk_text_view_new ()), _g_object_unref0 (self->priv->progress_text), _tmp4_);
	gtk_text_view_set_editable (self->priv->progress_text, FALSE);
	self->priv->progress_scroll = (_tmp5_ = g_object_ref_sink ((GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL)), _g_object_unref0 (self->priv->progress_scroll), _tmp5_);
	g_object_set ((GObject*) self->priv->progress_scroll, "child", self->priv->progress_text, "hscrollbar-policy", GTK_POLICY_AUTOMATIC, "vscrollbar-policy", GTK_POLICY_AUTOMATIC, "border-width", 0, NULL);
	self->priv->progress_expander = (_tmp6_ = g_object_ref_sink ((GtkExpander*) gtk_expander_new_with_mnemonic (_ ("_Details"))), _g_object_unref0 (self->priv->progress_expander), _tmp6_);
	g_object_set ((GObject*) self->priv->progress_expander, "child", self->priv->progress_scroll, NULL);
	page = g_object_ref_sink ((GtkVBox*) gtk_vbox_new (FALSE, 6));
	g_object_set ((GObject*) page, "child", progress_hbox, "child", self->priv->progress_bar, "child", self->priv->progress_expander, "border-width", 12, NULL);
	gtk_container_child_set ((GtkContainer*) page, (GtkWidget*) progress_hbox, "expand", FALSE, NULL);
	gtk_container_child_set ((GtkContainer*) page, (GtkWidget*) self->priv->progress_bar, "expand", FALSE, NULL);
	result = (GtkWidget*) page;
	_g_object_unref0 (progress_hbox);
	return result;
}


GtkWidget* assistant_operation_make_progress_page (AssistantOperation* self) {
	return ASSISTANT_OPERATION_GET_CLASS (self)->make_progress_page (self);
}


static void assistant_operation_real_show_error (AssistantOperation* self, const char* _error_, const char* detail) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (_error_ != NULL);
	assistant_operation_set_error_occurred (self, TRUE);
	gtk_label_set_label (self->summary_label, _error_);
	g_object_set (self->summary_label, "wrap", TRUE, NULL);
	gtk_label_set_selectable (self->summary_label, TRUE);
	if (detail != NULL) {
		gtk_widget_set_size_request ((GtkWidget*) ((Assistant*) self)->page_box, 300, 200);
		gtk_widget_set_no_show_all (self->priv->error_widget, FALSE);
		gtk_widget_show_all (self->priv->error_widget);
		gtk_text_buffer_set_text (gtk_text_view_get_buffer (self->priv->error_text_view), detail, -1);
	}
	assistant_go_to_page ((Assistant*) self, self->priv->_summary_page);
	assistant_set_header_icon ((Assistant*) self, GTK_STOCK_DIALOG_ERROR);
	gtk_widget_queue_resize ((GtkWidget*) ((Assistant*) self)->page_box);
}


void assistant_operation_show_error (AssistantOperation* self, const char* _error_, const char* detail) {
	ASSISTANT_OPERATION_GET_CLASS (self)->show_error (self, _error_, detail);
}


static void _lambda5_ (GtkToggleButton* button, AssistantOperation* self) {
	g_return_if_fail (button != NULL);
	gtk_entry_set_visibility (self->priv->encrypt_entry, gtk_toggle_button_get_active (button));
}


static void __lambda5__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	_lambda5_ (_sender, self);
}


GtkWidget* assistant_operation_make_password_page (AssistantOperation* self) {
	GtkWidget* result = NULL;
	gint rows;
	GtkWidget* w;
	GtkWidget* label;
	GtkTable* page;
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	GtkEntry* _tmp2_;
	GtkWidget* _tmp3_;
	GtkWidget* _tmp4_;
	GtkCheckButton* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	rows = 0;
	w = NULL;
	label = NULL;
	page = g_object_ref_sink ((GtkTable*) gtk_table_new ((guint) rows, (guint) 2, FALSE));
	g_object_set ((GObject*) page, "row-spacing", 6, "column-spacing", 6, "border-width", 12, NULL);
	w = (_tmp0_ = (GtkWidget*) g_object_ref_sink ((GtkEntry*) gtk_entry_new ()), _g_object_unref0 (w), _tmp0_);
	g_object_set ((GObject*) w, "visibility", FALSE, "activates-default", TRUE, NULL);
	label = (_tmp1_ = (GtkWidget*) g_object_ref_sink ((GtkLabel*) gtk_label_new (_ ("E_ncryption password:"))), _g_object_unref0 (label), _tmp1_);
	g_object_set ((GObject*) label, "mnemonic-widget", w, "use-underline", TRUE, "xalign", 0.0f, NULL);
	gtk_table_attach (page, label, (guint) 0, (guint) 1, (guint) rows, (guint) (rows + 1), GTK_FILL, GTK_FILL, (guint) 0, (guint) 0);
	gtk_table_attach (page, w, (guint) 1, (guint) 2, (guint) rows, (guint) (rows + 1), GTK_FILL | GTK_EXPAND, GTK_FILL, (guint) 0, (guint) 0);
	rows = rows + 1;
	self->priv->encrypt_entry = (_tmp2_ = _g_object_ref0 (GTK_ENTRY (w)), _g_object_unref0 (self->priv->encrypt_entry), _tmp2_);
	w = (_tmp3_ = (GtkWidget*) g_object_ref_sink ((GtkCheckButton*) gtk_check_button_new_with_mnemonic (_ ("_Show password"))), _g_object_unref0 (w), _tmp3_);
	g_signal_connect_object ((GtkToggleButton*) GTK_CHECK_BUTTON (w), "toggled", (GCallback) __lambda5__gtk_toggle_button_toggled, self, 0);
	gtk_table_attach (page, w, (guint) 0, (guint) 2, (guint) rows, (guint) (rows + 1), GTK_FILL, GTK_FILL, (guint) 0, (guint) 0);
	rows = rows + 1;
	w = (_tmp4_ = (GtkWidget*) g_object_ref_sink ((GtkCheckButton*) gtk_check_button_new_with_mnemonic (_ ("_Remember password"))), _g_object_unref0 (w), _tmp4_);
	gtk_table_attach (page, w, (guint) 0, (guint) 2, (guint) rows, (guint) (rows + 1), GTK_FILL | GTK_EXPAND, GTK_FILL, (guint) 0, (guint) 0);
	rows = rows + 1;
	self->priv->encrypt_remember = (_tmp5_ = _g_object_ref0 (GTK_CHECK_BUTTON (w)), _g_object_unref0 (self->priv->encrypt_remember), _tmp5_);
	result = (GtkWidget*) page;
	_g_object_unref0 (w);
	_g_object_unref0 (label);
	return result;
}


GtkWidget* assistant_operation_make_question_page (AssistantOperation* self) {
	GtkWidget* result = NULL;
	gint rows;
	GtkTable* page;
	GtkLabel* label;
	GtkLabel* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	rows = 0;
	page = g_object_ref_sink ((GtkTable*) gtk_table_new ((guint) rows, (guint) 2, FALSE));
	g_object_set ((GObject*) page, "row-spacing", 6, "column-spacing", 6, "border-width", 12, NULL);
	label = g_object_ref_sink ((GtkLabel*) gtk_label_new (""));
	g_object_set ((GObject*) label, "use-underline", TRUE, "wrap", TRUE, "xalign", 0.0f, NULL);
	gtk_table_attach (page, (GtkWidget*) label, (guint) 0, (guint) 1, (guint) rows, (guint) (rows + 1), GTK_FILL | GTK_EXPAND, GTK_FILL, (guint) 0, (guint) 0);
	rows = rows + 1;
	self->priv->question_label = (_tmp0_ = _g_object_ref0 (label), _g_object_unref0 (self->priv->question_label), _tmp0_);
	result = (GtkWidget*) page;
	_g_object_unref0 (label);
	return result;
}


static GtkWidget* assistant_operation_real_make_summary_page (AssistantOperation* self) {
	GtkWidget* result = NULL;
	GtkLabel* _tmp0_;
	GtkTextView* _tmp1_;
	GtkScrolledWindow* scroll;
	GtkWidget* _tmp2_;
	GtkVBox* page;
	g_return_val_if_fail (self != NULL, NULL);
	self->summary_label = (_tmp0_ = g_object_ref_sink ((GtkLabel*) gtk_label_new ("")), _g_object_unref0 (self->summary_label), _tmp0_);
	g_object_set ((GObject*) self->summary_label, "xalign", 0.0f, NULL);
	self->priv->error_text_view = (_tmp1_ = g_object_ref_sink ((GtkTextView*) gtk_text_view_new ()), _g_object_unref0 (self->priv->error_text_view), _tmp1_);
	gtk_text_view_set_editable (self->priv->error_text_view, FALSE);
	gtk_text_view_set_wrap_mode (self->priv->error_text_view, GTK_WRAP_WORD);
	g_object_set ((GtkWidget*) self->priv->error_text_view, "height-request", 150, NULL);
	scroll = g_object_ref_sink ((GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL));
	gtk_container_add ((GtkContainer*) scroll, (GtkWidget*) self->priv->error_text_view);
	gtk_widget_set_no_show_all ((GtkWidget*) scroll, TRUE);
	self->priv->error_widget = (_tmp2_ = _g_object_ref0 ((GtkWidget*) scroll), _g_object_unref0 (self->priv->error_widget), _tmp2_);
	page = g_object_ref_sink ((GtkVBox*) gtk_vbox_new (FALSE, 6));
	g_object_set ((GObject*) page, "child", self->summary_label, "child", self->priv->error_widget, "border-width", 12, NULL);
	gtk_container_child_set ((GtkContainer*) page, (GtkWidget*) self->summary_label, "expand", FALSE, NULL);
	result = (GtkWidget*) page;
	_g_object_unref0 (scroll);
	return result;
}


GtkWidget* assistant_operation_make_summary_page (AssistantOperation* self) {
	return ASSISTANT_OPERATION_GET_CLASS (self)->make_summary_page (self);
}


static void assistant_operation_add_config_pages_if_needed (AssistantOperation* self) {
	GError * _inner_error_;
	GConfClient* client;
	char* val;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	client = deja_dup_get_gconf_client ();
	val = NULL;
	{
		char* _tmp0_;
		char* _tmp1_;
		gboolean _tmp2_ = FALSE;
		_tmp0_ = gconf_client_get_string (client, DEJA_DUP_LAST_RUN_KEY, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch3_g_error;
		}
		val = (_tmp1_ = _tmp0_, _g_free0 (val), _tmp1_);
		if (val != NULL) {
			_tmp2_ = _vala_strcmp0 (val, "") != 0;
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			_g_object_unref0 (client);
			_g_free0 (val);
			return;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("AssistantOperation.vala:333: %s\n", e->message);
			_g_error_free0 (e);
			_g_object_unref0 (client);
			_g_free0 (val);
			return;
		}
	}
	__finally3:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (client);
		_g_free0 (val);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	assistant_operation_add_custom_config_pages (self);
	_g_object_unref0 (client);
	_g_free0 (val);
}


static void assistant_operation_add_confirm_page (AssistantOperation* self) {
	GtkWidget* page;
	g_return_if_fail (self != NULL);
	page = assistant_operation_make_confirm_page (self);
	if (page == NULL) {
		_g_object_unref0 (page);
		return;
	}
	assistant_append_page ((Assistant*) self, page, ASSISTANT_TYPE_SUMMARY);
	assistant_set_page_title ((Assistant*) self, page, _ ("Summary"));
	assistant_operation_set_confirm_page (self, page);
	_g_object_unref0 (page);
}


static void assistant_operation_add_progress_page (AssistantOperation* self) {
	GtkWidget* page;
	g_return_if_fail (self != NULL);
	page = assistant_operation_make_progress_page (self);
	assistant_append_page ((Assistant*) self, page, ASSISTANT_TYPE_PROGRESS);
	assistant_operation_set_progress_page (self, page);
	_g_object_unref0 (page);
}


static void assistant_operation_add_password_page (AssistantOperation* self) {
	GtkWidget* page;
	g_return_if_fail (self != NULL);
	page = assistant_operation_make_password_page (self);
	assistant_append_page ((Assistant*) self, page, ASSISTANT_TYPE_INTERRUPT);
	assistant_set_page_title ((Assistant*) self, page, _ ("Password needed"));
	assistant_operation_set_password_page (self, page);
	_g_object_unref0 (page);
}


static void assistant_operation_add_question_page (AssistantOperation* self) {
	GtkWidget* page;
	g_return_if_fail (self != NULL);
	page = assistant_operation_make_question_page (self);
	assistant_append_page ((Assistant*) self, page, ASSISTANT_TYPE_INTERRUPT);
	assistant_operation_set_question_page (self, page);
	_g_object_unref0 (page);
}


static void assistant_operation_add_summary_page (AssistantOperation* self) {
	GtkWidget* page;
	g_return_if_fail (self != NULL);
	page = assistant_operation_make_summary_page (self);
	assistant_append_page ((Assistant*) self, page, ASSISTANT_TYPE_FINISH);
	assistant_operation_set_summary_page (self, page);
	_g_object_unref0 (page);
}


static void assistant_operation_apply_finished (AssistantOperation* self, DejaDupOperation* op, gboolean success, gboolean cancelled) {
	StatusIcon* _tmp0_;
	DejaDupOperation* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (op != NULL);
	self->priv->status_icon = (_tmp0_ = NULL, _g_object_unref0 (self->priv->status_icon), _tmp0_);
	self->op = (_tmp1_ = NULL, _g_object_unref0 (self->op), _tmp1_);
	if (cancelled) {
		if (success) {
			gtk_main_quit ();
		} else {
			assistant_operation_do_close (self);
		}
	} else {
		if (success) {
			self->succeeded = TRUE;
			assistant_go_to_page ((Assistant*) self, self->priv->_summary_page);
		} else {
			assistant_operation_force_visible (self, FALSE);
		}
	}
}


static void _assistant_operation_apply_finished_deja_dup_operation_done (DejaDupOperation* _sender, gboolean success, gboolean cancelled, gpointer self) {
	assistant_operation_apply_finished (self, _sender, success, cancelled);
}


static void _lambda13_ (DejaDupOperation* o, const char* e, const char* d, AssistantOperation* self) {
	g_return_if_fail (o != NULL);
	g_return_if_fail (e != NULL);
	assistant_operation_show_error (self, e, d);
}


static void __lambda13__deja_dup_operation_raise_error (DejaDupOperation* _sender, const char* errstr, const char* detail, gpointer self) {
	_lambda13_ (_sender, errstr, detail, self);
}


static void _assistant_operation_get_passphrase_deja_dup_operation_passphrase_required (DejaDupOperation* _sender, gpointer self) {
	assistant_operation_get_passphrase (self);
}


static void _assistant_operation_set_progress_label_deja_dup_operation_action_desc_changed (DejaDupOperation* _sender, const char* action, gpointer self) {
	assistant_operation_set_progress_label (self, _sender, action);
}


static void _assistant_operation_set_progress_label_file_deja_dup_operation_action_file_changed (DejaDupOperation* _sender, GFile* file, gboolean actual, gpointer self) {
	assistant_operation_set_progress_label_file (self, _sender, file, actual);
}


static void _assistant_operation_show_progress_deja_dup_operation_progress (DejaDupOperation* _sender, double percent, gpointer self) {
	assistant_operation_show_progress (self, _sender, percent);
}


static void _assistant_operation_show_question_deja_dup_operation_question (DejaDupOperation* _sender, const char* title, const char* msg, gpointer self) {
	assistant_operation_show_question (self, _sender, title, msg);
}


static void _assistant_operation_set_secondary_label_deja_dup_operation_secondary_desc_changed (DejaDupOperation* _sender, const char* msg, gpointer self) {
	assistant_operation_set_secondary_label (self, _sender, msg);
}


static void _assistant_operation_pause_op_deja_dup_backend_pause_op (DejaDupBackend* _sender, const char* header, const char* msg, gpointer self) {
	assistant_operation_pause_op (self, _sender, header, msg);
}


static void _lambda14_ (StatusIcon* s, AssistantOperation* self) {
	g_return_if_fail (s != NULL);
	assistant_operation_toggle_window (self, (guint) 0, TRUE);
}


static void __lambda14__status_icon_toggle_window (StatusIcon* _sender, gpointer self) {
	_lambda14_ (_sender, self);
}


static void _lambda15_ (StatusIcon* s, AssistantOperation* self) {
	g_return_if_fail (s != NULL);
	assistant_operation_hide_everything (self);
}


static void __lambda15__status_icon_hide_all (StatusIcon* _sender, gpointer self) {
	_lambda15_ (_sender, self);
}


static void assistant_operation_do_apply (AssistantOperation* self) {
	GError * _inner_error_;
	DejaDupOperation* _tmp1_;
	StatusIcon* _tmp2_;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	if (self->mount_op == NULL) {
		GMountOperation* _tmp0_;
		self->mount_op = (_tmp0_ = (GMountOperation*) mount_operation_assistant_new (self), _g_object_unref0 (self->mount_op), _tmp0_);
	}
	self->op = (_tmp1_ = assistant_operation_create_op (self), _g_object_unref0 (self->op), _tmp1_);
	g_signal_connect_object (self->op, "done", (GCallback) _assistant_operation_apply_finished_deja_dup_operation_done, self, 0);
	g_signal_connect_object (self->op, "raise-error", (GCallback) __lambda13__deja_dup_operation_raise_error, self, 0);
	g_signal_connect_object (self->op, "passphrase-required", (GCallback) _assistant_operation_get_passphrase_deja_dup_operation_passphrase_required, self, 0);
	g_signal_connect_object (self->op, "action-desc-changed", (GCallback) _assistant_operation_set_progress_label_deja_dup_operation_action_desc_changed, self, 0);
	g_signal_connect_object (self->op, "action-file-changed", (GCallback) _assistant_operation_set_progress_label_file_deja_dup_operation_action_file_changed, self, 0);
	g_signal_connect_object (self->op, "progress", (GCallback) _assistant_operation_show_progress_deja_dup_operation_progress, self, 0);
	g_signal_connect_object (self->op, "question", (GCallback) _assistant_operation_show_question_deja_dup_operation_question, self, 0);
	g_signal_connect_object (self->op, "secondary-desc-changed", (GCallback) _assistant_operation_set_secondary_label_deja_dup_operation_secondary_desc_changed, self, 0);
	deja_dup_backend_set_mount_op (deja_dup_operation_get_backend (self->op), self->mount_op);
	g_signal_connect_object (deja_dup_operation_get_backend (self->op), "pause-op", (GCallback) _assistant_operation_pause_op_deja_dup_backend_pause_op, self, 0);
	self->priv->status_icon = (_tmp2_ = status_icon_new ((GtkWindow*) self, self->op, self->priv->_automatic), _g_object_unref0 (self->priv->status_icon), _tmp2_);
	g_signal_connect_object (self->priv->status_icon, "toggle-window", (GCallback) __lambda14__status_icon_toggle_window, self, 0);
	g_signal_connect_object (self->priv->status_icon, "hide-all", (GCallback) __lambda15__status_icon_hide_all, self, 0);
	{
		deja_dup_operation_start (self->op, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch4_g_error;
		}
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("AssistantOperation.vala:425: %s\n", e->message);
			assistant_operation_show_error (self, e->message, NULL);
			assistant_operation_apply_finished (self, self->op, FALSE, FALSE);
			_g_error_free0 (e);
		}
	}
	__finally4:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static gboolean _assistant_operation_pulse_gsource_func (gpointer self) {
	return assistant_operation_pulse (self);
}


static void assistant_operation_real_do_prepare (AssistantOperation* self, Assistant* assist, GtkWidget* page) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (assist != NULL);
	g_return_if_fail (page != NULL);
	if (self->priv->timeout_id > 0) {
		g_source_remove (self->priv->timeout_id);
		self->priv->timeout_id = (guint) 0;
	}
	if (page == self->priv->_confirm_page) {
		if (self->op != NULL) {
			guint _tmp0_;
			DejaDupOperation* _tmp1_;
			g_signal_parse_name ("done", DEJA_DUP_TYPE_OPERATION, &_tmp0_, NULL, FALSE);
			g_signal_handlers_disconnect_matched (self->op, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _assistant_operation_apply_finished_deja_dup_operation_done, self);
			deja_dup_operation_cancel (self->op);
			self->op = (_tmp1_ = NULL, _g_object_unref0 (self->op), _tmp1_);
		}
	} else {
		if (page == self->priv->_progress_page) {
			gboolean _tmp2_ = FALSE;
			gtk_progress_bar_set_fraction (self->priv->progress_bar, (double) 0);
			self->priv->timeout_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 250, _assistant_operation_pulse_gsource_func, g_object_ref (self), g_object_unref);
			if (self->op != NULL) {
				_tmp2_ = deja_dup_operation_get_needs_password (self->op);
			} else {
				_tmp2_ = FALSE;
			}
			if (_tmp2_) {
				assistant_operation_provide_password (self);
			} else {
				if (self->op == NULL) {
					assistant_operation_do_apply (self);
				}
			}
		} else {
			if (page == self->priv->_password_page) {
				assistant_set_header_icon ((Assistant*) self, GTK_STOCK_DIALOG_AUTHENTICATION);
			}
		}
	}
}


void assistant_operation_do_prepare (AssistantOperation* self, Assistant* assist, GtkWidget* page) {
	ASSISTANT_OPERATION_GET_CLASS (self)->do_prepare (self, assist, page);
}


void assistant_operation_hide_everything (AssistantOperation* self) {
	StatusIcon* _tmp0_;
	g_return_if_fail (self != NULL);
	gtk_widget_hide ((GtkWidget*) self);
	self->priv->status_icon = (_tmp0_ = NULL, _g_object_unref0 (self->priv->status_icon), _tmp0_);
}


static void assistant_operation_do_cancel (AssistantOperation* self) {
	g_return_if_fail (self != NULL);
	assistant_operation_hide_everything (self);
	if (self->op != NULL) {
		deja_dup_operation_cancel (self->op);
	} else {
		assistant_operation_do_close (self);
	}
}


static gboolean _lambda6_ (AssistantOperation* self) {
	gboolean result = FALSE;
	gtk_object_destroy ((GtkObject*) self);
	result = FALSE;
	return result;
}


static gboolean __lambda6__gsource_func (gpointer self) {
	return _lambda6_ (self);
}


static void assistant_operation_real_do_close (AssistantOperation* self) {
	g_return_if_fail (self != NULL);
	if (self->priv->timeout_id > 0) {
		g_source_remove (self->priv->timeout_id);
		self->priv->timeout_id = (guint) 0;
	}
	g_signal_emit_by_name (self, "closing", self->succeeded);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, __lambda6__gsource_func, g_object_ref (self), g_object_unref);
}


void assistant_operation_do_close (AssistantOperation* self) {
	ASSISTANT_OPERATION_GET_CLASS (self)->do_close (self);
}


void assistant_operation_force_visible (AssistantOperation* self, gboolean user_click) {
	g_return_if_fail (self != NULL);
	if (!gtk_widget_get_visible ((GtkWidget*) self)) {
		assistant_operation_toggle_window (self, (guint) 0, user_click);
	} else {
		assistant_operation_show_to_user (self, (GtkWindow*) self, (guint) 0, user_click);
	}
}


static gboolean _assistant_operation_user_focused_gtk_widget_focus_in_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self) {
	return assistant_operation_user_focused (self, _sender, event);
}


static gboolean assistant_operation_user_focused (AssistantOperation* self, GtkWidget* win, GdkEventFocus* e) {
	gboolean result = FALSE;
	guint _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (win != NULL, FALSE);
	gtk_window_set_urgency_hint (GTK_WINDOW (win), FALSE);
	g_signal_parse_name ("focus-in-event", GTK_TYPE_WIDGET, &_tmp0_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (win, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _assistant_operation_user_focused_gtk_widget_focus_in_event, self);
	result = FALSE;
	return result;
}


static void assistant_operation_show_to_user (AssistantOperation* self, GtkWindow* win, guint time, gboolean user_click) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (win != NULL);
	gtk_window_set_focus_on_map (win, user_click);
	if (self->priv->saved_pos) {
		gtk_window_move (win, self->priv->saved_x, self->priv->saved_y);
	}
	if (user_click) {
		gtk_window_present_with_time (win, (guint32) time);
	} else {
		gboolean _tmp0_;
		if (!(g_object_get (win, "is-active", &_tmp0_, NULL), _tmp0_)) {
			gtk_window_set_urgency_hint (win, TRUE);
			g_signal_connect_object ((GtkWidget*) win, "focus-in-event", (GCallback) _assistant_operation_user_focused_gtk_widget_focus_in_event, self, 0);
			gtk_widget_show ((GtkWidget*) win);
		}
	}
}


static void assistant_operation_toggle_window (AssistantOperation* self, guint time, gboolean user_click) {
	gboolean will_hide;
	g_return_if_fail (self != NULL);
	will_hide = gtk_widget_get_visible ((GtkWidget*) self);
	if (time == 0) {
		time = (guint) gtk_get_current_event_time ();
	}
	if (will_hide) {
		self->priv->saved_pos = TRUE;
		gtk_window_get_position ((GtkWindow*) self, &self->priv->saved_x, &self->priv->saved_y);
		gtk_widget_hide ((GtkWidget*) self);
	} else {
		assistant_operation_show_to_user (self, (GtkWindow*) self, time, user_click);
	}
}


static void assistant_operation_found_passphrase (AssistantOperation* self, GnomeKeyringResult _result_, const char* str) {
	g_return_if_fail (self != NULL);
	if (str != NULL) {
		deja_dup_operation_continue_with_passphrase (self->op, str);
	} else {
		assistant_operation_ask_passphrase (self);
	}
}


static void _assistant_operation_found_passphrase_gnome_keyring_operation_get_string_callback (GnomeKeyringResult _result_, const char* str, gpointer self) {
	assistant_operation_found_passphrase (self, _result_, str);
}


void assistant_operation_get_passphrase (AssistantOperation* self) {
	char* testing;
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	testing = g_strdup (g_getenv ("DEJA_DUP_TESTING"));
	if (testing == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = _vala_strcmp0 (testing, "") == 0;
	}
	if (_tmp0_) {
		gnome_keyring_find_password (PASSPHRASE_SCHEMA, _assistant_operation_found_passphrase_gnome_keyring_operation_get_string_callback, g_object_ref (self), g_object_unref, "owner", PACKAGE, "type", "passphrase", NULL);
	} else {
		assistant_operation_ask_passphrase (self);
	}
	_g_free0 (testing);
}


static void assistant_operation_save_password_callback (AssistantOperation* self, GnomeKeyringResult _result_) {
	g_return_if_fail (self != NULL);
}


static void assistant_operation_ask_passphrase (AssistantOperation* self) {
	g_return_if_fail (self != NULL);
	assistant_interrupt ((Assistant*) self, self->priv->_password_page, TRUE);
	assistant_operation_force_visible (self, FALSE);
}


static char* string_strip (const char* self) {
	char* result = NULL;
	char* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_result_ = g_strdup (self);
	g_strstrip (_result_);
	result = _result_;
	return result;
}


static void _assistant_operation_save_password_callback_gnome_keyring_operation_done_callback (GnomeKeyringResult _result_, gpointer self) {
	assistant_operation_save_password_callback (self, _result_);
}


void assistant_operation_provide_password (AssistantOperation* self) {
	char* passphrase;
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	passphrase = g_strdup (gtk_entry_get_text (self->priv->encrypt_entry));
	passphrase = (_tmp0_ = string_strip (passphrase), _g_free0 (passphrase), _tmp0_);
	if (_vala_strcmp0 (passphrase, "") != 0) {
		if (gtk_toggle_button_get_active ((GtkToggleButton*) self->priv->encrypt_remember)) {
			gnome_keyring_store_password (PASSPHRASE_SCHEMA, GNOME_KEYRING_DEFAULT, _ ("Déjà Dup backup passphrase"), passphrase, _assistant_operation_save_password_callback_gnome_keyring_operation_done_callback, g_object_ref (self), g_object_unref, "owner", PACKAGE, "type", "passphrase", NULL);
		}
	}
	deja_dup_operation_continue_with_passphrase (self->op, passphrase);
	_g_free0 (passphrase);
}


static void _assistant_operation_stop_question_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	assistant_operation_stop_question (self, _sender, response_id);
}


static void assistant_operation_stop_question (AssistantOperation* self, GtkDialog* dlg, gint resp) {
	guint _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dlg != NULL);
	gtk_main_quit ();
	g_signal_parse_name ("response", GTK_TYPE_DIALOG, &_tmp0_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GtkDialog*) self, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _assistant_operation_stop_question_gtk_dialog_response, self);
}


static void assistant_operation_show_question (AssistantOperation* self, DejaDupOperation* op, const char* title, const char* message) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (op != NULL);
	g_return_if_fail (title != NULL);
	g_return_if_fail (message != NULL);
	assistant_set_page_title ((Assistant*) self, self->priv->_question_page, title);
	gtk_label_set_label (self->priv->question_label, message);
	assistant_interrupt ((Assistant*) self, self->priv->_question_page, TRUE);
	assistant_operation_force_visible (self, FALSE);
	g_signal_connect_object ((GtkDialog*) self, "response", (GCallback) _assistant_operation_stop_question_gtk_dialog_response, self, 0);
	gtk_main ();
}


static void assistant_operation_pause_op (AssistantOperation* self, DejaDupBackend* back, const char* header, const char* msg) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (back != NULL);
	g_return_if_fail (header != NULL);
	g_return_if_fail (msg != NULL);
	assistant_set_page_title ((Assistant*) self, self->priv->_question_page, header);
	gtk_label_set_label (self->priv->question_label, msg);
	assistant_interrupt ((Assistant*) self, self->priv->_question_page, FALSE);
	assistant_operation_force_visible (self, FALSE);
}


AssistantOperation* assistant_operation_construct (GType object_type) {
	AssistantOperation * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


GtkWidget* assistant_operation_get_confirm_page (AssistantOperation* self) {
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_confirm_page;
	return result;
}


static void assistant_operation_set_confirm_page (AssistantOperation* self, GtkWidget* value) {
	GtkWidget* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_confirm_page = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_confirm_page), _tmp0_);
	g_object_notify ((GObject *) self, "confirm-page");
}


gboolean assistant_operation_get_automatic (AssistantOperation* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_automatic;
	return result;
}


static void assistant_operation_set_automatic (AssistantOperation* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_automatic = value;
	g_object_notify ((GObject *) self, "automatic");
}


GtkWidget* assistant_operation_get_password_page (AssistantOperation* self) {
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_password_page;
	return result;
}


static void assistant_operation_set_password_page (AssistantOperation* self, GtkWidget* value) {
	GtkWidget* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_password_page = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_password_page), _tmp0_);
	g_object_notify ((GObject *) self, "password-page");
}


GtkWidget* assistant_operation_get_question_page (AssistantOperation* self) {
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_question_page;
	return result;
}


static void assistant_operation_set_question_page (AssistantOperation* self, GtkWidget* value) {
	GtkWidget* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_question_page = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_question_page), _tmp0_);
	g_object_notify ((GObject *) self, "question-page");
}


GtkWidget* assistant_operation_get_progress_page (AssistantOperation* self) {
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_progress_page;
	return result;
}


static void assistant_operation_set_progress_page (AssistantOperation* self, GtkWidget* value) {
	GtkWidget* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_progress_page = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_progress_page), _tmp0_);
	g_object_notify ((GObject *) self, "progress-page");
}


GtkWidget* assistant_operation_get_summary_page (AssistantOperation* self) {
	GtkWidget* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_summary_page;
	return result;
}


static void assistant_operation_set_summary_page (AssistantOperation* self, GtkWidget* value) {
	GtkWidget* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_summary_page = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_summary_page), _tmp0_);
	g_object_notify ((GObject *) self, "summary-page");
}


GdkPixbuf* assistant_operation_get_op_icon (AssistantOperation* self) {
	GdkPixbuf* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_op_icon;
	return result;
}


static void assistant_operation_set_op_icon (AssistantOperation* self, GdkPixbuf* value) {
	GdkPixbuf* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_op_icon = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_op_icon), _tmp0_);
	g_object_notify ((GObject *) self, "op-icon");
}


gboolean assistant_operation_get_error_occurred (AssistantOperation* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_error_occurred;
	return result;
}


static void assistant_operation_set_error_occurred (AssistantOperation* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_error_occurred = value;
	g_object_notify ((GObject *) self, "error-occurred");
}


static void _assistant_operation_do_cancel_assistant_canceled (Assistant* _sender, gpointer self) {
	assistant_operation_do_cancel (self);
}


static void _assistant_operation_do_close_assistant_closed (Assistant* _sender, gpointer self) {
	assistant_operation_do_close (self);
}


static void _assistant_operation_do_prepare_assistant_prepare (Assistant* _sender, GtkWidget* page, gpointer self) {
	assistant_operation_do_prepare (self, _sender, page);
}


static GObject * assistant_operation_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	AssistantOperation * self;
	parent_class = G_OBJECT_CLASS (assistant_operation_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = ASSISTANT_OPERATION (obj);
	{
		GdkPixbuf* _tmp0_;
		assistant_operation_set_op_icon_name (self);
		assistant_operation_set_op_icon (self, _tmp0_ = assistant_operation_make_op_icon (self));
		_g_object_unref0 (_tmp0_);
		g_object_set (((Assistant*) self)->header_icon, "pixbuf", self->priv->_op_icon, NULL);
		assistant_operation_add_config_pages_if_needed (self);
		assistant_operation_add_setup_pages (self);
		assistant_operation_add_confirm_page (self);
		assistant_operation_add_password_page (self);
		assistant_operation_add_question_page (self);
		assistant_operation_add_progress_page (self);
		assistant_operation_add_summary_page (self);
		g_signal_connect_object ((Assistant*) self, "canceled", (GCallback) _assistant_operation_do_cancel_assistant_canceled, self, 0);
		g_signal_connect_object ((Assistant*) self, "closed", (GCallback) _assistant_operation_do_close_assistant_closed, self, 0);
		g_signal_connect_object ((Assistant*) self, "prepare", (GCallback) _assistant_operation_do_prepare_assistant_prepare, self, 0);
	}
	return obj;
}


static void assistant_operation_class_init (AssistantOperationClass * klass) {
	assistant_operation_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (AssistantOperationPrivate));
	ASSISTANT_OPERATION_CLASS (klass)->make_confirm_page = assistant_operation_real_make_confirm_page;
	ASSISTANT_OPERATION_CLASS (klass)->add_setup_pages = assistant_operation_real_add_setup_pages;
	ASSISTANT_OPERATION_CLASS (klass)->add_custom_config_pages = assistant_operation_real_add_custom_config_pages;
	ASSISTANT_OPERATION_CLASS (klass)->create_op = assistant_operation_real_create_op;
	ASSISTANT_OPERATION_CLASS (klass)->get_progress_file_prefix = assistant_operation_real_get_progress_file_prefix;
	ASSISTANT_OPERATION_CLASS (klass)->set_op_icon_name = assistant_operation_real_set_op_icon_name;
	ASSISTANT_OPERATION_CLASS (klass)->make_progress_page = assistant_operation_real_make_progress_page;
	ASSISTANT_OPERATION_CLASS (klass)->show_error = assistant_operation_real_show_error;
	ASSISTANT_OPERATION_CLASS (klass)->make_summary_page = assistant_operation_real_make_summary_page;
	ASSISTANT_OPERATION_CLASS (klass)->do_prepare = assistant_operation_real_do_prepare;
	ASSISTANT_OPERATION_CLASS (klass)->do_close = assistant_operation_real_do_close;
	G_OBJECT_CLASS (klass)->get_property = assistant_operation_get_property;
	G_OBJECT_CLASS (klass)->set_property = assistant_operation_set_property;
	G_OBJECT_CLASS (klass)->constructor = assistant_operation_constructor;
	G_OBJECT_CLASS (klass)->finalize = assistant_operation_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ASSISTANT_OPERATION_CONFIRM_PAGE, g_param_spec_object ("confirm-page", "confirm-page", "confirm-page", GTK_TYPE_WIDGET, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ASSISTANT_OPERATION_AUTOMATIC, g_param_spec_boolean ("automatic", "automatic", "automatic", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ASSISTANT_OPERATION_PASSWORD_PAGE, g_param_spec_object ("password-page", "password-page", "password-page", GTK_TYPE_WIDGET, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ASSISTANT_OPERATION_QUESTION_PAGE, g_param_spec_object ("question-page", "question-page", "question-page", GTK_TYPE_WIDGET, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ASSISTANT_OPERATION_PROGRESS_PAGE, g_param_spec_object ("progress-page", "progress-page", "progress-page", GTK_TYPE_WIDGET, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ASSISTANT_OPERATION_SUMMARY_PAGE, g_param_spec_object ("summary-page", "summary-page", "summary-page", GTK_TYPE_WIDGET, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ASSISTANT_OPERATION_OP_ICON, g_param_spec_object ("op-icon", "op-icon", "op-icon", GDK_TYPE_PIXBUF, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), ASSISTANT_OPERATION_ERROR_OCCURRED, g_param_spec_boolean ("error-occurred", "error-occurred", "error-occurred", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_signal_new ("closing", TYPE_ASSISTANT_OPERATION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
}


static void assistant_operation_instance_init (AssistantOperation * self) {
	self->priv = ASSISTANT_OPERATION_GET_PRIVATE (self);
	self->priv->_automatic = FALSE;
	self->succeeded = FALSE;
}


static void assistant_operation_finalize (GObject* obj) {
	AssistantOperation * self;
	self = ASSISTANT_OPERATION (obj);
	_g_object_unref0 (self->priv->_confirm_page);
	_g_object_unref0 (self->priv->status_icon);
	_g_object_unref0 (self->priv->encrypt_entry);
	_g_object_unref0 (self->priv->encrypt_remember);
	_g_object_unref0 (self->priv->_password_page);
	_g_object_unref0 (self->priv->question_label);
	_g_object_unref0 (self->priv->_question_page);
	_g_object_unref0 (self->priv->progress_label);
	_g_object_unref0 (self->priv->progress_file_label);
	_g_object_unref0 (self->priv->secondary_label);
	_g_object_unref0 (self->priv->progress_bar);
	_g_object_unref0 (self->priv->progress_text);
	_g_object_unref0 (self->priv->progress_scroll);
	_g_object_unref0 (self->priv->progress_expander);
	_g_object_unref0 (self->priv->_progress_page);
	_g_object_unref0 (self->summary_label);
	_g_object_unref0 (self->priv->error_widget);
	_g_object_unref0 (self->priv->error_text_view);
	_g_object_unref0 (self->priv->_summary_page);
	_g_object_unref0 (self->priv->_op_icon);
	_g_object_unref0 (self->op);
	_g_object_unref0 (self->mount_op);
	G_OBJECT_CLASS (assistant_operation_parent_class)->finalize (obj);
}


GType assistant_operation_get_type (void) {
	static volatile gsize assistant_operation_type_id__volatile = 0;
	if (g_once_init_enter (&assistant_operation_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (AssistantOperationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) assistant_operation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AssistantOperation), 0, (GInstanceInitFunc) assistant_operation_instance_init, NULL };
		GType assistant_operation_type_id;
		assistant_operation_type_id = g_type_register_static (TYPE_ASSISTANT, "AssistantOperation", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&assistant_operation_type_id__volatile, assistant_operation_type_id);
	}
	return assistant_operation_type_id__volatile;
}


static void assistant_operation_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	AssistantOperation * self;
	self = ASSISTANT_OPERATION (object);
	switch (property_id) {
		case ASSISTANT_OPERATION_CONFIRM_PAGE:
		g_value_set_object (value, assistant_operation_get_confirm_page (self));
		break;
		case ASSISTANT_OPERATION_AUTOMATIC:
		g_value_set_boolean (value, assistant_operation_get_automatic (self));
		break;
		case ASSISTANT_OPERATION_PASSWORD_PAGE:
		g_value_set_object (value, assistant_operation_get_password_page (self));
		break;
		case ASSISTANT_OPERATION_QUESTION_PAGE:
		g_value_set_object (value, assistant_operation_get_question_page (self));
		break;
		case ASSISTANT_OPERATION_PROGRESS_PAGE:
		g_value_set_object (value, assistant_operation_get_progress_page (self));
		break;
		case ASSISTANT_OPERATION_SUMMARY_PAGE:
		g_value_set_object (value, assistant_operation_get_summary_page (self));
		break;
		case ASSISTANT_OPERATION_OP_ICON:
		g_value_set_object (value, assistant_operation_get_op_icon (self));
		break;
		case ASSISTANT_OPERATION_ERROR_OCCURRED:
		g_value_set_boolean (value, assistant_operation_get_error_occurred (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void assistant_operation_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	AssistantOperation * self;
	self = ASSISTANT_OPERATION (object);
	switch (property_id) {
		case ASSISTANT_OPERATION_CONFIRM_PAGE:
		assistant_operation_set_confirm_page (self, g_value_get_object (value));
		break;
		case ASSISTANT_OPERATION_AUTOMATIC:
		assistant_operation_set_automatic (self, g_value_get_boolean (value));
		break;
		case ASSISTANT_OPERATION_PASSWORD_PAGE:
		assistant_operation_set_password_page (self, g_value_get_object (value));
		break;
		case ASSISTANT_OPERATION_QUESTION_PAGE:
		assistant_operation_set_question_page (self, g_value_get_object (value));
		break;
		case ASSISTANT_OPERATION_PROGRESS_PAGE:
		assistant_operation_set_progress_page (self, g_value_get_object (value));
		break;
		case ASSISTANT_OPERATION_SUMMARY_PAGE:
		assistant_operation_set_summary_page (self, g_value_get_object (value));
		break;
		case ASSISTANT_OPERATION_OP_ICON:
		assistant_operation_set_op_icon (self, g_value_get_object (value));
		break;
		case ASSISTANT_OPERATION_ERROR_OCCURRED:
		assistant_operation_set_error_occurred (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




