using System;
using System.Collections.Generic;
using System.Text;
using Db4objects.Db4o;

namespace CSTest
{
    class NQExample
    {
        public readonly static string YapFileName = "formula1.yap";
        public static void main()
        {
            IObjectContainer db = Db4o.OpenFile(YapFileName);
            try
            {
                PrimitiveQuery(db);
            }
            finally
            {
                db.Close();
            }
        }
        // end Main

        public static void PrimitiveQuery(IObjectContainer db)
        {
            IList<Pilot> pilots = db.Query<Pilot>(delegate(Pilot pilot)
            {
                return pilot.Points == 100;
            });
        }
        // end PrimitiveQuery

        public static void AdvancedQuery(IObjectContainer db)
        {
            IList<Pilot> result = db.Query<Pilot>(delegate(Pilot pilot)
            {
                return pilot.Points > 99
                    && pilot.Points < 199
                    || pilot.Name == "Rubens Barrichello";
            });
        }
        // end AdvancedQuery
    }
}
