' Copyright (C) 2004 - 2007 db4objects Inc. http:'www.db4o.com 
Imports System
Imports System.Runtime.Serialization

' Test class. Defines an object to be persisted to db4o through
' .NET Remoting interface. The object is passed over the network
' by value.

Namespace RemotingClasses

    ' Implement ISerializable interface to be able to serialize 
    ' the object to transfer over the network
    <Serializable()> Public Class TestValue
        Implements ISerializable 

        Private _data As String

        Public Function GetData() As String
            Return _data
        End Function
        ' end GetData

        Public Sub ChangeData(ByVal data As String)
            _data = data
        End Sub
        ' end ChangeData

        Public Sub New()
            _data = "no data"
        End Sub
        ' end New

        Public Sub New(ByVal info As SerializationInfo, ByVal context As StreamingContext)
            _data = info.GetString("_data")
        End Sub
        ' end New

        Public Sub GetObjectData(ByVal info As SerializationInfo, ByVal context As StreamingContext) Implements ISerializable.GetObjectData
            info.AddValue("_data", _data)
        End Sub
        ' end GetObjectData

    End Class
End Namespace
