/* Copyright (C) 2004 - 2007 db4objects Inc. http://www.db4o.com */

using System;
using System.IO;
using System.Collections.Generic;

using Db4objects.Db4o;
using Db4objects.Db4o.Config;

/**
 * This example shows how to use the same db4o database between 
 * Java and .NET application. Pilot objects are originally saved in .NET,
 * then they are read and modified in Java application and read again 
 * in .NET
 *
 */

namespace Db4objects.Db4odoc.Aliases
{

    public class InterLanguageExample2
    {

        private const string Db4oFileName = "reference.db4o";

        public static void Main(string[] args)
        {
            //SaveObjects();
            // use Java version to retrieve and modify the objects 
            // and read from .NET again. Note, as the objects were set
            // originally in .NET, you do not need to use alias.
            ReadObjects();
        }
        // end Main

        private static void SaveObjects()
        {
            File.Delete(Db4oFileName);
            IObjectContainer container = Db4oFactory.OpenFile(Db4oFileName);
            try
            {
                Pilot pilot = new Pilot("David Barrichello", 99);
                container.Set(pilot);
                pilot = new Pilot("Michael Schumacher", 100);
                container.Set(pilot);
            }
            finally
            {
                container.Close();
            }
        }
        // end SaveObjects

        private static void ReadObjects()
        {
            IObjectContainer container = Db4oFactory.OpenFile(Db4oFileName);
            try
            {
                IList<Pilot> result = container.Query<Pilot>();
                ListResult(result);
            }
            finally
            {
                container.Close();
            }
        }
        // end ReadObjects 

        private static void ListResult<T>(IList<T> result)
        {
            Console.WriteLine(result.Count);
            for (int i = 0; i < result.Count; i++)
            {
                Console.WriteLine(result[i]);
            }
        }
        // end ListResult
    }
}
