' Copyright (C) 2007 db4objects Inc. http://www.db4o.com 

Imports System
Imports System.IO
Imports System.Collections.Generic

Imports Db4objects.Db4o
Imports Db4objects.Db4o.Query
Imports Db4objects.Db4o.Ext
Imports Db4objects.Db4o.Config
Imports System.Collections


Namespace Db4objects.Db4odoc.BuiltInTranslators
    Class BuiltInTranslatorsExample
        Private Const Db4oFileName As String = "reference.db4o"

        Private Shared _container As IObjectContainer = Nothing

        Public Shared Sub Main(ByVal args As String())
            TestTNull()
            TestSerializable()
        End Sub
        ' end Main

        Private Shared Function Database() As IObjectContainer
            If _container Is Nothing Then
                Try
                    _container = Db4oFactory.OpenFile(Db4oFileName)
                Catch ex As DatabaseFileLockedException
                    System.Console.WriteLine(ex.Message)
                End Try
            End If
            Return _container
        End Function

        ' end Database

        Private Shared Function Database(ByVal configuration As IConfiguration) As IObjectContainer
            If _container Is Nothing Then
                Try
                    _container = Db4oFactory.OpenFile(configuration, Db4oFileName)
                Catch ex As DatabaseFileLockedException
                    System.Console.WriteLine(ex.Message)
                End Try
            End If
            Return _container
        End Function

        ' end Database

        Private Shared Sub CloseDatabase()
            If _container IsNot Nothing Then
                _container.Close()
                _container = Nothing
            End If
        End Sub

        ' end CloseDatabase


        Public Shared Sub SaveNotStorable()
            File.Delete(Db4oFileName)
            Dim configuration As IConfiguration = Db4oFactory.NewConfiguration()
            ' Configure NotStorable class with TNull translator to prevent its storage
            configuration.ObjectClass(GetType(NotStorable)).Translate(New TNull())
            Dim container As IObjectContainer = Database(configuration)
            If container IsNot Nothing Then
                Try
                    Dim ns As New NotStorable("test1")
                    container.[Set](ns)
                    ns = New NotStorable("test2")
                    container.[Set](ns)
                Catch ex As Db4oException
                    System.Console.WriteLine("Db4o Exception: " + ex.Message)
                Catch ex As Exception
                    System.Console.WriteLine("System Exception: " + ex.Message)
                Finally
                    CloseDatabase()
                End Try
            End If
        End Sub
        ' end SaveNotStorable

        Public Shared Sub TestTNull()
            SaveNotStorable()
            Dim container As IObjectContainer = Database()
            If container IsNot Nothing Then
                Try
                    ' Trying to retrieve
                    Dim result As IList(Of NotStorable) = container.Query(Of NotStorable)()
                    ' As the class is configured with TNull, the data should be null
                    ListResult(result)
                Catch ex As Db4oException
                    System.Console.WriteLine("Db4o Exception: " + ex.Message)
                Catch ex As Exception
                    System.Console.WriteLine("System Exception: " + ex.Message)
                Finally
                    CloseDatabase()
                End Try
            End If
        End Sub
        ' end TestTNull

        Public Shared Sub TestSerializable()
            SaveSerializable()
            Dim configuration As IConfiguration = Db4oFactory.NewConfiguration()
            ' configure class as serializable to retrieve correctly
            configuration.ObjectClass(GetType(Pilot)).Translate(New TSerializable())
            Dim container As IObjectContainer = Database(configuration)
            If container IsNot Nothing Then
                Try
                    System.Console.WriteLine("Retrieving pilots by name:")
                    Dim query As IQuery = container.Query()
                    query.Constrain(GetType(Pilot))
                    query.Descend("_name").Constrain("Test Pilot 1")
                    Dim resultByName As IObjectSet = query.Execute()
                    ListResult(resultByName)

                    System.Console.WriteLine("Retrieve all pilot objects:")
                    Dim result As IList(Of Pilot) = container.Query(Of Pilot)()
                    ListResult(result)
                Catch ex As Db4oException
                    System.Console.WriteLine("Db4o Exception: " + ex.Message)
                Catch ex As Exception
                    System.Console.WriteLine("System Exception: " + ex.Message)
                Finally
                    CloseDatabase()
                End Try
            End If
        End Sub
        ' end TestSerializable

        Public Shared Sub SaveSerializable()
            File.Delete(Db4oFileName)
            Dim configuration As IConfiguration = Db4oFactory.NewConfiguration()
            ' configure class as serializable
            configuration.ObjectClass(GetType(Pilot)).Translate(New TSerializable())
            Dim container As IObjectContainer = Database(configuration)
            If container IsNot Nothing Then
                Try
                    Dim pilot As New Pilot("Test Pilot 1", 99)
                    container.[Set](pilot)
                    pilot = New Pilot("Test Pilot 2", 100)
                    container.[Set](pilot)
                Catch ex As Db4oException
                    System.Console.WriteLine("Db4o Exception: " + ex.Message)
                Catch ex As Exception
                    System.Console.WriteLine("System Exception: " + ex.Message)
                Finally
                    CloseDatabase()
                End Try
            End If

        End Sub
        ' end SaveSerializable


        Private Shared Sub ListResult(ByVal result As IObjectSet)
            System.Console.WriteLine(result.Count)
            For i As Integer = 0 To result.Count - 1
                System.Console.WriteLine(result(i))
            Next
        End Sub

        ' end ListResult

        Private Shared Sub ListResult(Of T)(ByVal result As IList(Of T))
            System.Console.WriteLine(result.Count)
            For i As Integer = 0 To result.Count - 1
                System.Console.WriteLine(result(i))
            Next
        End Sub

        ' end ListResult
    End Class
End Namespace