import java.io.File;
import java.util.ArrayList;
import java.util.List;

import com.db4o.Db4o;
import com.db4o.ObjectContainer;
import com.db4o.ObjectSet;

public class Db4oModule {

	public static final String DB_FILE = "Test.yap";

	public List readData() {
		ObjectContainer container = Db4o.openFile(DB_FILE);
		List result = new ArrayList();
		try {
			ObjectSet pilots = container.query(Pilot.class);
			while (pilots.hasNext()) {
				Pilot pilot = (Pilot) pilots.next();
				result.add(new String[] { pilot.getName(),
						String.format("%3d", pilot.getPoints()) });
			}
		} finally {
			container.close();
		}
		return (result);
	}
	// end readData

	public void storeData() {
		new File(DB_FILE).delete();
		ObjectContainer container = Db4o.openFile(DB_FILE);
		try {
			Pilot pilot = new Pilot("Michael Schumacher", 100);
			container.set(pilot);
			pilot = new Pilot("Rubens Barrichello", 99);
			container.set(pilot);
			pilot = new Pilot("Kimi Raikonnen", 100);
			container.set(pilot);
		} finally {
			container.close();
		}
	}
	// end storeData

	public static void main(String[] args) {
		Db4oModule sc = new Db4oModule();
		sc.storeData();
		List result = sc.readData();
		for (int i = 0; i < result.size(); i++) {
			String[] sa = (String[]) result.get(i);
			System.out.println(sa[0] + "--" + sa[1]);
		}
	}
	// end main
}