/* This file is part of the db4o object database http://www.db4o.com

Copyright (C) 2004 - 2009  Versant Corporation http://www.versant.com

db4o is free software; you can redistribute it and/or modify it under
the terms of version 3 of the GNU General Public License as published
by the Free Software Foundation.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program.  If not, see http://www.gnu.org/licenses/. */
using System.Collections;
using Db4oUnit;
using Db4objects.Drs.Tests;

namespace Db4objects.Drs.Tests
{
	public class CustomArrayListTestCase : DrsTestCase
	{
		public class NamedList : DelegatingList
		{
			private string _name;

			public NamedList(string name) : base(new ArrayList())
			{
				_name = name;
			}

			public virtual string Name()
			{
				return _name;
			}
		}

		public virtual void Test()
		{
			CustomArrayListTestCase.NamedList original = new CustomArrayListTestCase.NamedList
				("foo");
			original.Add("bar");
			A().Provider().StoreNew(original);
			A().Provider().Commit();
			ReplicateAll(A().Provider(), B().Provider());
			CustomArrayListTestCase.NamedList replicated = (CustomArrayListTestCase.NamedList
				)B().Provider().GetStoredObjects(typeof(CustomArrayListTestCase.NamedList))[0];
			Assert.AreEqual(original.Name(), replicated.Name());
			CollectionAssert.AreEqual(original, replicated);
		}
	}
}
