/* This file is part of the db4o object database http://www.db4o.com

Copyright (C) 2004 - 2009  Versant Corporation http://www.versant.com

db4o is free software; you can redistribute it and/or modify it under
the terms of version 3 of the GNU General Public License as published
by the Free Software Foundation.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program.  If not, see http://www.gnu.org/licenses/. */
using Db4oTool.Core;
using Db4oTool.Tests.Core;
using Db4oUnit;
using Mono.Cecil;

namespace Db4oTool.Tests.TA
{
	internal abstract class TATestCaseBase : ITestCase
	{
		protected AssemblyDefinition GenerateAssembly(string resourceName)
		{
			return AssemblyFactory.GetAssembly(
						CompilationServices.EmitAssemblyFromResource(
							ResourceServices.CompleteResourceName(
													GetType(),
													resourceName)));
		}

		protected static void InstrumentAssembly(AssemblyDefinition testAssembly)
		{
			InstrumentationContext context = new InstrumentationContext(Configuration(testAssembly.MainModule.Image.FileInformation.FullName), testAssembly);
			new Db4oTool.TA.TAInstrumentation().Run(context);
		}

		protected static Configuration Configuration(string assemblyLocation)
		{
			return new Configuration(assemblyLocation);
		}
	}
}
