/* This file is part of the db4o object database http://www.db4o.com

Copyright (C) 2004 - 2009  Versant Corporation http://www.versant.com

db4o is free software; you can redistribute it and/or modify it under
the terms of version 3 of the GNU General Public License as published
by the Free Software Foundation.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program.  If not, see http://www.gnu.org/licenses/. */
using System;
using System.Threading;

using Sharpen.Lang;

namespace Db4objects.Db4o.Foundation
{
	public sealed class SimpleTimer
	{
		private readonly Timer _timer;
		private bool _started = false;

		public SimpleTimer(IRunnable runnable, int interval, string name)
		{
			_timer = new Timer(new TimerCallback(Run), runnable, 0, interval);
		}

		public void Start()
		{
			_started = true;
		}

		private void Run(object state)
		{
			if (!_started) return;
			((IRunnable)state).Run();
		}

		public void Stop()
		{
			_timer.Dispose();
		}
	}
}
