/* This file is part of the db4o object database http://www.db4o.com

Copyright (C) 2004 - 2009  Versant Corporation http://www.versant.com

db4o is free software; you can redistribute it and/or modify it under
the terms of version 3 of the GNU General Public License as published
by the Free Software Foundation.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program.  If not, see http://www.gnu.org/licenses/. */
using Db4objects.Db4o.Internal;
using Db4objects.Db4o.Internal.Slots;

namespace Db4objects.Db4o.Internal
{
	/// <summary>TODO: Check if all time-consuming stuff is overridden!</summary>
	internal class TransactionObjectCarrier : LocalTransaction
	{
		internal TransactionObjectCarrier(ObjectContainerBase container, Db4objects.Db4o.Internal.Transaction
			 parentTransaction, IReferenceSystem referenceSystem) : base(container, parentTransaction
			, referenceSystem)
		{
		}

		public override void Commit()
		{
		}

		// do nothing
		public override void SlotFreeOnCommit(int id, Slot slot)
		{
		}

		//      do nothing
		public override void SlotFreeOnRollback(int id, Slot slot)
		{
		}

		//      do nothing
		internal override void ProduceUpdateSlotChange(int id, Slot slot)
		{
			SetPointer(id, slot);
		}

		internal override void SlotFreeOnRollbackCommitSetPointer(int id, Slot slot, bool
			 forFreespace)
		{
			SetPointer(id, slot);
		}

		internal override void SlotFreePointerOnCommit(int a_id, Slot slot)
		{
		}

		//      do nothing
		public override void SlotFreePointerOnCommit(int a_id)
		{
		}

		// do nothing
		public override void SetPointer(int a_id, Slot slot)
		{
			WritePointer(a_id, slot);
		}

		internal override bool SupportsVirtualFields()
		{
			return false;
		}
	}
}
