' Copyright (C) 2004 - 2007 db4objects Inc. http://www.db4o.com 

Imports System
Imports System.IO
Imports System.Collections
Imports Db4objects.Db4o
Imports Db4objects.Db4o.Ext
Imports Db4objects.Db4o.Query

Namespace Db4objects.Db4odoc.Soda
    Class SodaExample

        Private Const Db4oFileName As String = "reference.db4o"

        Private Const ObjectCount As Integer = 10

        Private Shared _container As IObjectContainer = Nothing

        Public Shared Sub Main(ByVal args As String())
            TestIdentity()
            TestContains()
            TestLike()
            TestStartsEnds()
        End Sub
        ' end Main

        Private Shared Function Database() As IObjectContainer
            If _container Is Nothing Then
                Try
                    _container = Db4oFactory.OpenFile(Db4oFileName)
                Catch ex As DatabaseFileLockedException
                    System.Console.WriteLine(ex.Message)
                End Try
            End If
            Return _container
        End Function

        ' end Database

        Private Shared Sub CloseDatabase()
            If _container IsNot Nothing Then
                _container.Close()
                _container = Nothing
            End If
        End Sub

        ' end CloseDatabase


        Public Shared Sub TestLike()
            File.Delete(Db4oFileName)
            Dim container As IObjectContainer = Database()
            If container IsNot Nothing Then
                Try
                    Dim pilot As New Pilot("Test Pilot1", 100)
                    container.[Set](pilot)
                    pilot = New Pilot("Test Pilot2", 102)
                    container.[Set](pilot)

                    ' Simple.IQuery
                    Dim query1 As IQuery = container.Query()
                    query1.Constrain(GetType(Pilot))
                    query1.Descend("_name").Constrain("est")
                    Dim result As IObjectSet = query1.Execute()
                    ListResult(result)

                    ' Like.IQuery
                    Dim query2 As IQuery = container.Query()
                    query2.Constrain(GetType(Pilot))
                    ' All pilots with the name containing "est" will be retrieved
                    query2.Descend("_name").Constrain("est").[Like]()
                    result = query2.Execute()
                    ListResult(result)
                Catch ex As Db4oException
                    Console.WriteLine("Db4o Exception: " + ex.Message)
                Catch ex As Exception
                    Console.WriteLine("System Exception: " + ex.Message)
                Finally
                    CloseDatabase()
                End Try
            End If
        End Sub
        ' end TestLike

        Public Shared Sub TestContains()
            File.Delete(Db4oFileName)
            Dim container As IObjectContainer = Database()
            If container IsNot Nothing Then
                Try
                    Dim list As New ArrayList()
                    Dim pilot1 As New Pilot("Test 1", 1)
                    list.Add(pilot1)
                    Dim pilot2 As New Pilot("Test 2", 2)
                    list.Add(pilot2)
                    Dim team As New Team("Ferrari", list)
                    container.[Set](team)

                    Dim query As IQuery = container.Query()
                    query.Constrain(GetType(Team))
                    query.Descend("_pilots").Constrain(pilot2).Contains()
                    Dim result As IObjectSet = query.Execute()
                    ListResult(result)
                Catch ex As Db4oException
                    Console.WriteLine("Db4o Exception: " + ex.Message)
                Catch ex As Exception
                    Console.WriteLine("System Exception: " + ex.Message)
                Finally
                    CloseDatabase()
                End Try
            End If
        End Sub
        ' end TestContains

        Public Shared Sub TestStartsEnds()
            File.Delete(Db4oFileName)
            Dim container As IObjectContainer = Database()
            If container IsNot Nothing Then
                Try
                    Dim pilot As New Pilot("Test Pilot0", 100)
                    container.[Set](pilot)
                    pilot = New Pilot("Test Pilot1", 101)
                    container.[Set](pilot)
                    pilot = New Pilot("Test Pilot2", 102)
                    container.[Set](pilot)

                    Dim query As IQuery = container.Query()
                    query.Constrain(GetType(Pilot))
                    query.Descend("_name").Constrain("T0").EndsWith(False).[Not]()
                    'query.Descend("_name").Constrain("Pil").StartsWith(true);
                    Dim result As IObjectSet = query.Execute()
                    ListResult(result)
                Catch ex As Db4oException
                    Console.WriteLine("Db4o Exception: " + ex.Message)
                Catch ex As Exception
                    Console.WriteLine("System Exception: " + ex.Message)
                Finally
                    CloseDatabase()
                End Try
            End If
        End Sub
        ' end TestStartsEnds

        Public Shared Sub TestIdentity()
            File.Delete(Db4oFileName)
            Dim container As IObjectContainer = Database()
            If container IsNot Nothing Then
                Try
                    Dim pilot As New Pilot("Test Pilot1", 100)
                    Dim car As New Car("BMW", pilot)
                    container.[Set](car)
                    ' Change the name, the pilot instance stays the same
                    pilot.Name = "Test Pilot2"
                    ' create a new car
                    car = New Car("Ferrari", pilot)
                    container.[Set](car)

                    ' Simple query: 
                    Dim query1 As IQuery = container.Query()
                    query1.Constrain(GetType(Car))
                    query1.Descend("_pilot").Constrain(pilot)
                    Dim result As IObjectSet = query1.Execute()
                    ListResult(result)

                    ' identity.IQuery:
                    Dim query2 As IQuery = container.Query()
                    query2.Constrain(GetType(Car))
                    ' All cars having pilot with the same Database identity
                    ' will be retrieved. As we only created Pilot object once
                    ' it should mean all car objects
                    query2.Descend("_pilot").Constrain(pilot).Identity()
                    result = query2.Execute()
                    ListResult(result)
                Catch ex As Db4oException
                    Console.WriteLine("Db4o Exception: " + ex.Message)
                Catch ex As Exception
                    Console.WriteLine("System Exception: " + ex.Message)
                Finally
                    CloseDatabase()
                End Try
            End If
        End Sub
        ' end TestIdentity

        Private Shared Sub ListResult(ByVal result As IObjectSet)
            System.Console.WriteLine(result.Count)
            For i As Integer = 0 To result.Count - 1
                System.Console.WriteLine(result(i))
            Next
        End Sub

        ' end ListResult
    End Class
End Namespace