/* Copyright (C) 2007 db4objects Inc. http://www.db4o.com */

package com.db4odoc.soda;

import java.io.File;
import java.util.ArrayList;

import com.db4o.DatabaseFileLockedException;
import com.db4o.Db4o;
import com.db4o.ObjectContainer;
import com.db4o.ObjectSet;
import com.db4o.ext.Db4oException;
import com.db4o.query.Query;



public class SodaExample {

	private final static String DB4O_FILE_NAME = "reference.db4o";

		private static ObjectContainer _container = null;
	
	public static void main(String[] args) {
		testContains();
//		testAnd();
//		testOr();
//		testStartsEnds();
//		testEqual();
//		testIdentity();
//		testLike();
	}
	
	private static ObjectContainer database() {
		if (_container == null) {
			try {
				_container = Db4o.openFile(DB4O_FILE_NAME);
			} catch (DatabaseFileLockedException ex) {
				System.out.println(ex.getMessage());
			}
		}
		return _container;
	}

	// end database

	private static void closeDatabase() {
		if (_container != null) {
			_container.close();
			_container = null;
		}
	}

	// end closeDatabase

	public static void testEqual() {
		new File(DB4O_FILE_NAME).delete();
		ObjectContainer container = database();
		if (container != null) {
			try {
				Pilot pilot = new Pilot("Test Pilot0", 100);
				container.set(pilot);
				pilot = new Pilot("Test Pilot1", 101);
				container.set(pilot);
				pilot = new Pilot("Test Pilot2", 102);
				container.set(pilot);
				
				Query query1 = container.query();
				query1.constrain(Pilot.class);
				query1.descend("points").constrain(101).smaller();
				ObjectSet result = query1.execute();
				listResult(result);
				
				Query query2 = container.query();
				query2.constrain(Pilot.class);
				query2.descend("points").constrain(101).smaller().equal();
				result = query2.execute();
				listResult(result);
			} catch (Db4oException ex) {
				System.out.println("Db4o Exception: " + ex.getMessage());
			} catch (Exception ex) {
				System.out.println("System Exception: " + ex.getMessage());
			} finally {
				closeDatabase();
			}
		}
	}
	// end testEqual
	
	public static void testAnd() {
		new File(DB4O_FILE_NAME).delete();
		ObjectContainer container = database();
		if (container != null) {
			try {
				Pilot pilot = new Pilot("Test Pilot0", 100);
				container.set(pilot);
				pilot = new Pilot("Test Pilot1", 101);
				container.set(pilot);
				pilot = new Pilot("Test Pilot2", 102);
				container.set(pilot);
				
				Query query = container.query();
				query.constrain(Pilot.class);
				query.descend("points").constrain(101).smaller().and(query.descend("name").constrain("Test Pilot0"));
				ObjectSet result = query.execute();
				listResult(result);
			} catch (Db4oException ex) {
				System.out.println("Db4o Exception: " + ex.getMessage());
			} catch (Exception ex) {
				System.out.println("System Exception: " + ex.getMessage());
			} finally {
				closeDatabase();
			}
		}
	}
	// end testAnd
	
	public static void testStartsEnds() {
		new File(DB4O_FILE_NAME).delete();
		ObjectContainer container = database();
		if (container != null) {
			try {
				Pilot pilot = new Pilot("Test Pilot0", 100);
				container.set(pilot);
				pilot = new Pilot("Test Pilot1", 101);
				container.set(pilot);
				pilot = new Pilot("Test Pilot2", 102);
				container.set(pilot);
				
				Query query = container.query();
				query.constrain(Pilot.class);
				query.descend("name").constrain("T0").endsWith(false).not();
				// query.descend("name").constrain("Pil").startsWith(true);
				ObjectSet result = query.execute();
				listResult(result);
			} catch (Db4oException ex) {
				System.out.println("Db4o Exception: " + ex.getMessage());
			} catch (Exception ex) {
				System.out.println("System Exception: " + ex.getMessage());
			} finally {
				closeDatabase();
			}
		}
	}
	// end testStartsEnds
	
	
	public static void testContains() {
		new File(DB4O_FILE_NAME).delete();
		ObjectContainer container = database();
		if (container != null) {
			try {
				ArrayList list = new ArrayList();
				Pilot pilot1 = new Pilot("Test 1", 1);
				list.add(pilot1);
				Pilot pilot2 = new Pilot("Test 2", 2);
				list.add(pilot2);
				Team team = new Team("Ferrari", list);
				container.set(team);
				
				Query query = container.query();
				query.constrain(Team.class);
				query.descend("pilots").constrain(pilot2).contains();
				ObjectSet result = query.execute();
				listResult(result);
			} catch (Db4oException ex) {
				System.out.println("Db4o Exception: " + ex.getMessage());
			} catch (Exception ex) {
				System.out.println("System Exception: " + ex.getMessage());
			} finally {
				closeDatabase();
			}
		}
	}
	// end testContains
	
	public static void testOr() {
		new File(DB4O_FILE_NAME).delete();
		ObjectContainer container = database();
		if (container != null) {
			try {
				Pilot pilot = new Pilot("Test Pilot0", 100);
				container.set(pilot);
				pilot = new Pilot("Test Pilot1", 101);
				container.set(pilot);
				pilot = new Pilot("Test Pilot2", 102);
				container.set(pilot);
				
				Query query = container.query();
				query.constrain(Pilot.class);
				query.descend("points").constrain(101).greater().or(query.descend("name").constrain("Test Pilot0"));
				ObjectSet result = query.execute();
				listResult(result);
			} catch (Db4oException ex) {
				System.out.println("Db4o Exception: " + ex.getMessage());
			} catch (Exception ex) {
				System.out.println("System Exception: " + ex.getMessage());
			} finally {
				closeDatabase();
			}
		}
	}
	// end testOr
	
	public static void testIdentity() {
		new File(DB4O_FILE_NAME).delete();
		ObjectContainer container = database();
		if (container != null) {
			try {
				Pilot pilot = new Pilot("Test Pilot1", 100);
				Car car = new Car("BMW", pilot);
				container.set(car);
				// Change the name, the pilot instance stays the same
				pilot.setName("Test Pilot2");
				// create a new car
				car = new Car("Ferrari", pilot);
				container.set(car);
				
				// Simple Query: 
				Query query1 = container.query();
				query1.constrain(Car.class);
				query1.descend("_pilot").constrain(pilot);
				ObjectSet result = query1.execute();
				listResult(result);
				
				// identity query:
				Query query2 = container.query();
				query2.constrain(Car.class);
				// All cars having pilot with the same database identity
				// will be retrieved. As we only created Pilot object once
				// it should mean all car objects
				query2.descend("_pilot").constrain(pilot).identity();
				result = query2.execute();
				listResult(result);
			} catch (Db4oException ex) {
				System.out.println("Db4o Exception: " + ex.getMessage());
			} catch (Exception ex) {
				System.out.println("System Exception: " + ex.getMessage());
			} finally {
				closeDatabase();
			}
		}
	}
	// end testIdentity
	
	public static void testLike() {
		new File(DB4O_FILE_NAME).delete();
		ObjectContainer container = database();
		if (container != null) {
			try {
				Pilot pilot = new Pilot("Test Pilot1", 100);
				container.set(pilot);
				pilot = new Pilot("Test Pilot2", 102);
				container.set(pilot);
				
				// Simple query
				Query query1 = container.query();
				query1.constrain(Pilot.class);
				query1.descend("name").constrain("est");
				ObjectSet result = query1.execute();
				listResult(result);
				
				// Like query
				Query query2 = container.query();
				query2.constrain(Pilot.class);
				// All pilots with the name containing "est" will be retrieved
				query2.descend("name").constrain("est").like();
				result = query2.execute();
				listResult(result);
			} catch (Db4oException ex) {
				System.out.println("Db4o Exception: " + ex.getMessage());
			} catch (Exception ex) {
				System.out.println("System Exception: " + ex.getMessage());
			} finally {
				closeDatabase();
			}
		}
	}
	// end testLike
	
	private static void listResult(ObjectSet result) {
		System.out.println(result.size());
		for (int i = 0; i < result.size(); i++) {
			System.out.println(result.get(i));
		}
	}

	// end listResult
}
