/* Copyright (C) 2004 - 2007 db4objects Inc. http://www.db4o.com */
using System;
using System.Runtime.Serialization;

/*
 * Test class. Defines an object to be persisted to db4o through
 * .NET Remoting interface. The object is passed over the network
 * by value.
 */
namespace RemotingClasses
{
    // Implement ISerializable interface to be able to serialize 
    // the object to transfer over the network
    [Serializable]
    public class TestValue: ISerializable
    {
        private string _data;

        public string GetData()
        {
            return _data;
        }
        // end GetData

        public void ChangeData(string data)
        {
            _data = data;
        }
        // end ChangeData

        public TestValue()
        {
            _data = "no data";
        }
        // end TestValue

        public TestValue(SerializationInfo info, StreamingContext context)
        {
            _data = info.GetString("_data");
        }
        // end TestValue

        #region ISerializable Members

        public virtual void GetObjectData(SerializationInfo info, StreamingContext context)
        {
            info.AddValue("_data", _data);
        }
        // end GetObjectData

        #endregion
    }
}

