/* Copyright (C) 2004 - 2007 db4objects Inc. http://www.db4o.com */
using System;

using System.Runtime.Remoting;
using System.Runtime.Remoting.Channels;
using System.Runtime.Remoting.Channels.Http;
using System.Runtime.Remoting.Channels.Tcp;

using RemotingClasses;

/*
 * Server class. Starts Remoting server services
 */

namespace Server
{
    class Program
    {
        static void Main(string[] args)
        {
            // Setting up http channel
            HttpChannel channel = new HttpChannel(65101);
            ChannelServices.RegisterChannel(channel);

            Type TestValue = Type.GetType("RemotingClasses.TestValueServer, RemotingClasses");
            RemotingConfiguration.RegisterWellKnownServiceType(
                    TestValue,
                    "TestValueEndpoint",
                    WellKnownObjectMode.Singleton
                );
            Console.WriteLine("TestValue is ready.");

            // Keep the server running until the user presses
            // the Enter key.
            Console.WriteLine("Services are running. Press Enter to end...");
            Console.ReadLine();
        }
        // end Main

    }
}
