/* Copyright (C) 2004 - 2007 db4objects Inc. http://www.db4o.com */
using System;
using System.IO;
using Interfaces;

using Db4objects.Db4o;
using Db4objects.Db4o.Config;
using Db4objects.Db4o.Ext;
using Db4objects.Db4o.Query;

/*
 * ITest interface implementation.
 * Test object will be referenced from the client and saved to the database
 * on the server side.
 */

namespace Server
{
    public class Test : MarshalByRefObject, ITest
    {
        private string _data;

        private const string Db4oFileName = "reference.db4o";

        #region ITest Members

        public string GetData()
        {
            return _data;
        }
        // end GetData

        public void ChangeData(string data)
        {
            _data = data;
        }
        // end ChangeData

        public void StoreData()
        {
            // store the current object to the database
            File.Delete(Db4oFileName);
            IObjectContainer db = Database();
            try
            {
                db.Set(this);
                db.Commit();
            }
            catch (Exception ex)
            {
                System.Console.WriteLine(ex.Message);
            }
            finally
            {
                db.Close();
            }
        }
        // end StoreData

        public string RetrieveData()
        {
            // retrieve Test object from the database
            // and return its data to the client
            // If the object cannot be retrieved return
            // "No results" to the client
            IObjectContainer db = Database();
            try
            {
                IObjectSet result = db.Query(typeof(Test));
                System.Console.WriteLine(result.Count);
                if (result.Count > 0)
                {
                    return ((Test)result.Next()).GetData();
                }

            }
            catch (Exception ex)
            {
                System.Console.WriteLine(ex.Message);
            }
            finally
            {
                db.Close();
            }
            return "No results";
        }
        // end RetrieveData

        #endregion

        private static IConfiguration Configure()
        {
            // create configuration to allow MarshalByRef objects to be stored
            IConfiguration configuration = Db4oFactory.NewConfiguration();
            configuration.ObjectClass("System.Runtime.Remoting.ServerIdentity, mscorlib").Translate(new TTransient());
            configuration.ObjectClass("System.Threading.TimerCallback, mscorlib").Translate(new TTransient());
            return configuration;
        }
        // end Configure

        private static IObjectContainer Database()
        {
            // get database connection
            IConfiguration configuration = Configure();
            IObjectContainer container = null;
            try
            {
                container = Db4oFactory.OpenFile(configuration, Db4oFileName);
            }
            catch (DatabaseFileLockedException ex)
            {
                System.Console.WriteLine(ex.Message);
            }
            return container;
        }
        // end Database
    }
}
