[-- template default.template --]
[-- define title=Hacking BookmarkBridge Source --]
[-- define chapter_title=3. How BookmarkBridge Works --]
[-- define prev_link=source_code_roadmap.html --]
[-- define prev_title=Source Code Roadmap --]
[-- define next_link=# --]
[-- define next_title=None --]

<p>
This section is for software developers wishing to hack BookmarkBridge's source code or
add support for a new browser to BookmarkBridge.
</p>

<p>
Make sure you have already read through the section on
<a href="compiling_bookmarkbridge_from_source.html">Compiling BookmarkBridge From Source</a>
before continuing.  BookmarkBridge is written in C++ and makes heavy use of the STL
(Standard Template Library) and polymorphism (virtual functions).
</p>

<h3>Adding Support For a New Browser</h3>

<p>
Each browser in BookmarkBridge is implemented using a C++ class derived from the BrowserBk class.
BrowserBk is an abstract base class, meaning you can't declare an instance of the class because it
contains pure virtual functions that must be overridden in derived classes.  Below is a discussion
of the member functions of BrowserBk.
</p>

<p>
You will need to understand many important concepts in order to implement a BrowserBk class.  Far
too many, in fact, to easily explain in this document.  The absolutely best way to learn this stuff
is to look at the source for one of the other browsers, Opera (opera.cpp) or Internet Explorer
(iexplore.cpp).  &quot;Use the source, Luke.&quot;
I wouldn't recommend starting with Mozilla (mozilla.cpp).  It's easily the most
complex of the browser implementations because of the complicated HTML parsing involved in reading
the bookmarks.html file.
</p>

<p>
Your BrowserBk class must properly handle international character sets.  Most browsers use UTF-8
to encode character sets and implement Unicode internally.  You should expect to encouter international
characters in a bookmark or folder title or description (if your browser supports descriptions). The
QString class makes it easy to handle UTF-8.  QString is implemented internally using Unicode.  See
the Opera class (opera.cpp) for a good example of how to use QString to handle UTF-8 for Unicode.
</p>

<p>
Since BookmarkBridge is a cross-platform product, an unfortunate reality is that Windows and Unix
specify file and directory paths differently.  Luckily, Qt does a good job of encapsulating most of
this.  The QDir class does a good job of hiding most of the differences between the platforms and 
provides a platform-independent way of browsing directories and handling path separators.  QDir handles
paths using Unix forward-slash separators.  Windows will not handle it well if you pass one of these
paths to the CreateFile() function.  For this reason, I highly recommend using Qt classes for file I/O.
If you must call a non-Qt file I/O function (such as access()), use QDir::convertSeparators().
</p>

<p>
In order to catch most critters before shipping BookmarkBridge, a rather extensive set of regression
tests has been implemented.  Under Windows, the tests are implemented in a batch file, using the
Windows 2000 or XP command interpreter.  I highly doubt the batch file would run under Windows 9x.
Under Unix, the tests are implemented with a Bash script.  The Internet Explorer portion of the tests
is implemented using Python, on both platforms.  When adding support for a new browser to BookmarkBridge,
it is important to add it to each of the regression tests.  Believe me, they will catch a surprising number
of bugs.
</p>

<h3>The Browser List</h3>

<p>
The browserlist.h header file defines a structure that contains an entry for each browser supported
by BookmarkBridge.  The browserlist.cpp file declares a global instance of this structure.  For each
browser, the list contains a pointer to a character string name, and two static class member functions
from the browser's class.  The first, called classFactory() is used to allocate an instance of the
browser class, and returns a pointer to the BrowserBk base class.  BookmarkBridge uses this instance
to call the virtual functions of the derived class.  The list also contains a pointer to the class's
static saveBookmarks() function.  BookmarkBridge calls this function to save the global bookmark
tree to the browser's bookmark database.
</p>

<h3>BrowserBk Class Member Functions</h3>

<dl>
	<dt><b>virtual bool AreBookmarksReadonly(const QString &bookmarks)</b></dt>
	<dd>
	This function is called when BookmarkBridge needs to know if a browser's bookmarks
	are being accessed in a read-only fashion.  In other words, are the bookmarks on a 
	read-only filesystem?  The base class implementation uses the access() function.
	The parameter to the function is the path to the bookmark database.
	</dd>
	<dt><b>virtual bool AreBookmarksValid(const QString &bookmarks) = 0</b></dt>
	<dd>
	This function is called when BookmarkBridge needs to know if the given path
	is a valid location for the browser's bookmarks.  The Mozilla class implementation
	reads the first couple of lines of the bookmarks.html file given in the first parameter
	and compares them against the first two lines it knows should be in a Mozilla bookmarks.html file.
	This is a pure virtual function which means your browser class must override
	this function.
	</dd>
	<dt><b>virtual bool BrowseForBookmarks(QString &bookmarks, QWidget *parent) = 0</b></dt>
	<dd>
	This function is called when the user wants to browse for the bookmarks for this
	browser.  If the location for an existing bookmarks file is known, it is passed
	in the first parameter.  This function should display a dialog box to the user
	allowing them to browse.  See the Mozilla class for an example of how to browse
	for a file and the IExplore class for an example of how to browse for a directory.
	This is a pure virtual function which means your browser class must override
	this function.
	</dd>
	<dt><b>static BrowserBk * classFactory(void)</b></dt>
	<dd>
	This function is called when BookmarkBridge needs to allocate an instance of your
	browser class.  A pointer to this function is stored by BookmarkBridge (see the
	section on the browser list above).  It expects to receive back a pointer to a
	new instance of your browser class (casted down to the BrowserBk base class).
	</dd>
	<dt><b>virtual bool DetectBrowser(QStringList &paths)</b></dt>
	<dd>
	This function is called when BookmarkBridge wants your class to try to locate any
	installations of its browser on the system.  The BrowserBk implementation of this
	function returns false, indicating that no browser was detected.
	If your browser is only available for Windows or Unix
	then use conditional compilation to override the function only
	on the supported platform.  See the IExplore class for an example of this.
	The function parameter is a pointer to a QStringList class, which represents an
	array of strings, similar to vector<string>.  If it's possible for the user to install
	more than instance of your browser on the system (two different versions, perhaps), the
	function should attempt to locate all installations and place them in the paths variable.
	See the Opera class for an example of this.  The function should return true if it
	found at least one installation.
	</dd>
	<dt><b>virtual bool IsBrowserRunning(void)</b></dt>
	<dd>
	The base class version of this function returns false.
	</dd>
	<dt><b>virtual bool readBookmarks(const QString &path, BRWSNUM browserOrd) = 0</b></dt>
	<dd>
	This function is called by BookmarkBridge when it needs the class to read the
	browser's bookmark database, specified in the first parameter.  The second parameter
	contains the browser number, assigned to each unique installation of each browser.
	This number is used to identify the browser or browsers that contain a bookmark.
	The function should read the bookmarks into a tree, contained in a BkFolder class.
	The function needs to save this BkFolder instance for later use by the root() function.
	</dd>
	<dt><b>virtual BkFolder & root(void) = 0</b></dt>
	<dd>
	This function needs to return a reference to the BkFolder instance populated by the
	readBookmarks() function.
	</dd>
</dl>
