// BotInterp.H  -*- C++ -*-
// Copyright (c) 1998 Etienne BERNARD

// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

#ifndef BOTINTERP_H
#define BOTINTERP_H

#include "String.H"
#include <guile/gh.h>

class Bot;

struct Hook {
  int type;
  String regex_str;
  SCM regex;
  SCM function;

  Hook(int t, String rs, SCM r, SCM f)
    : type(t), regex_str(rs), regex(r), function(f) { }

  enum {
    ACTION, NICKNAME, SIGNOFF, CTCP, CTCP_REPLY,
    DISCONNECT, FLOOD, INVITE, JOIN, KICK, LEAVE,
    MODE, MESSAGE, NAMES, NOTICE, PUBLIC,
    PUBLIC_NOTICE, RAW, TIMER, TOPIC
  };  
};

struct Timer {
  int count;
  time_t when;
  SCM function;

  Timer(int c, time_t t, SCM f)
    : count(c), when(t), function(f) { }
};

class BotInterp {
  Bot * bot;
  SCM logPort;
  map<int, list<Hook *>, less<int> > hooksMap;
  list<Timer *> timersList;
  int counter;

public:
  BotInterp(Bot *, String);

  void ScriptLog(SCM);

  void Execute(String);
  void LoadScript(String);

  bool AddHook(int, SCM, SCM);
  bool RunHooks(int, String, SCM);

  long AddTimer(int, SCM);
  bool DelTimer(SCM);
  bool RunTimers(int);

  friend class Interp;
  friend class ScriptCommands;
};

#endif
