/*

    Bist: a chemical drawing tool
    Copyright (C) 2008 Valerio Benfante

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

// generated by Fast Light User Interface Designer (fluid) version 1.0104

#include <config.h>
#include <global.hpp>

#include <cairo/cairo.h>
#include <pango/pangocairo.h>
#include <cairo_t_singleton.hpp>
#include <glib.h>


#include <config_path.h>

#include <stddef.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <dirent.h>
#include <dlfcn.h>

#include <deque>

#include <cstdio>
#include <expat.h>



#include <FL/Fl.H>
#include <FL/Fl_Group.H>
#include <FL/Fl_Double_Window.H>
#include <FL/Fl_Box.H>
#include <FL/Fl_Float_Input.H>
#include <FL/Fl_Int_Input.H>
#include <FL/Fl_Check_Button.H>
#include <FL/Fl_Button.H>
#include <FL/Fl_Return_Button.H>
#include <FL/Fl_Tabs.H>
#include <FL/Fl_Box.H>
#include <FL/Fl_Double_Window.H>
#include <FL/Fl_Scroll.H>
#include <FL/Fl_Menu_Bar.H>
#include <FL/Fl_Menu_Item.H>
#include <FL/Fl_Toggle_Button.H>
#include <FL/Fl_Menu_Button.H>
#include <FL/Fl_Choice.H>
#include <FL/Fl_File_Chooser.H>
#include <FL/Fl_Color_Chooser.H>
#include <FL/Fl_Light_Button.H>
#include <FL/Fl_Choice.H>
#include <FL/Fl_Pixmap.H>
#include <FL/Fl_Tabs.H>
#include <FL/fl_ask.H>
#include <FL/Fl_Help_Dialog.H>
#include <FL/Fl_Float_Input.H>
#include <FL/Fl_Int_Input.H>
#include <FL/Fl_Check_Button.H>
#include <FL/Fl_Button.H>
#include <FL/Fl_Return_Button.H>
#include <FL/Fl_Tabs.H>

#include <Flu_Enumerations.h>
#include <Flu_Tree_Browser.h>
/*
#include <openbabel/mol.h>

using namespace OpenBabel;
*/
#include <interfacce.hpp>
#include <legame.hpp>
#include <etichetta.hpp>
#include <multiline_label.hpp>
#include <multifont_label.hpp>
#include <paragraph_text.hpp>
#include <atomo.hpp>
#include <procedura.hpp>
#include <gruppo.hpp>
#include <immagine.hpp>
#include <bist_plugin.hpp>
#include <immagine_cml.hpp>
//#include <immagine_babel.hpp>
#include <immagine_mol.hpp>
#include <mol_canvas.hpp>

#include <finestra_pr.hpp>

#include <prefs.hpp>

#include <pref_dialog.hpp>
#include <lib_dialog.hpp>

#include <chain_prop.hpp>
#include <editor.hpp>

#include <util.hpp>




#include <typeinfo>



extern finestra_pr* __la_finestra;

extern Preferences __pref;



void pref_reset_to_default_cb(Fl_Widget* w, void* d){
  __pref.Defaults();
  __pref.SavePrefs();
  pref_dialog* pref=dynamic_cast<pref_dialog*>(w->parent());
  pref->hide();
}

void pref_canc_cb(Fl_Widget* w, void* d){
  pref_dialog* pref=dynamic_cast<pref_dialog*>(w->parent());
  pref->hide();
}

void pref_write_conf_cb(Fl_Widget* w, void* d){
  setlocale (LC_ALL, "C");
  pref_dialog* pref=dynamic_cast<pref_dialog*>(w->parent());
  __pref.setPageWidth(static_cast<int>(strtol(pref->_page_w.value(),NULL,0)));
  __pref.setPageHeight(static_cast<int>(strtol(pref->_page_h.value(),NULL,0)));
  __pref.setGridSpacing(static_cast<int>(strtol(pref->grsp.value(),NULL,0)));
  __pref.setBond_fixedlength(strtof(pref->bdl.value(),NULL));
  __pref.setBond_fixedangle(deg2rad(strtof(pref->bda.value(),NULL)));
  __pref.set_sensib_leg(static_cast<int>(strtol(pref->sens.value(),NULL,0)));
  __pref.set_arr_w(strtof(pref->arw.value(),NULL));
  __pref.set_arr_h(strtof(pref->arh.value(),NULL));
  __pref.set_arr_gap(strtof(pref->argap.value(),NULL));
  __pref.setDoubleBondOffset(strtof(pref->dbs.value(),NULL));
  __pref.set_tratteggio_legame(static_cast<int>(strtol(pref->bndd.value(),NULL,0)));
  __pref.set_larg_max_cuneo(strtof(pref->lmaxc.value(),NULL));
  __pref.set_multiple_bond_gap(strtof(pref->mbg.value(),NULL));
  __pref.set_frequenza_stereo_scon(strtof(pref->freq.value(),NULL));
  __pref.set_ampiezza_stereo_scon(strtof(pref->amp.value(),NULL));
  __pref.set_num_barrette_stereo_down(static_cast<int>(strtol(pref->numb.value(),NULL,0)));
  
  if(pref->o.value()){
    __pref.setDrawGrid(1);
  }else{
    __pref.setDrawGrid(0);
  }
 
  if(pref->_show_splash.value()){
    __pref.setSplash(true);
  }else{
    __pref.setSplash(false);
  }
  

  if(pref->quantize_pos.value()){
    __pref.setMagnetic_point_gap(static_cast<int>(strtol(pref->grsp.value(),NULL,0)));
  }else{
    __pref.setMagnetic_point_gap(0);
  }

  __pref.SavePrefs();
  pref->hide();

  editor* ed=dynamic_cast<editor*>(__la_finestra);
  ed->canvas_resize(static_cast<int>(strtol(pref->_page_w.value(),NULL,0)),
		    static_cast<int>(strtol(pref->_page_h.value(),NULL,0)));

  ed->redraw();
  setlocale (LC_ALL, "");
}


pref_dialog::pref_dialog()
  :Fl_Double_Window(630, 280, _("Set Preferences...")),
   ui_tab(0, 0, 630, 240),
   g1(0, 25, 620, 240, _("UI")),
   grsp(167, 30, 40, 25, _("Grid space:")),
   sens(167, 60, 40, 25, _("Click zone:")),
   _page_w(167, 90, 40, 25, _("Page width:")),
   _page_h(167, 120, 40, 25, _("Page height:")),
   _show_splash(5, 150, 90, 25, _("Show splashpage")),
   o(5, 177, 90, 25, _("Show grid")),
   quantize_pos(5, 202, 90, 25, _("\"Magnetic\" grid")),
   g2(0, 25, 620, 210, _("Bond")),
   bdl(167, 43, 30, 25, _("Bond length:")),
   bda(167, 71, 30, 25, _("Bond angle:")),
   arw(167, 101, 30, 25, _("Arrow width:")),
   arh(167, 130, 30, 25, _("Arrow height:")),
   argap(167, 158, 30, 25, _("Arrow gap:")),
   dbs(577, 41, 30, 25, _("Double bond space:")),
   bndd(577, 72, 30, 25, _("Bond dash:")),
   lmaxc(577, 101, 30, 25, _("Width of wedge:")),
   mbg(577, 130, 30, 25, _("Multiple Bond Gap")),
   freq(577, 158, 30, 25, _("Unknown stereochemistry bond freq.:")),   
   amp(577, 185, 30, 25, _("Unknown stereochemistry bond amplitude:")),
   numb(577, 211, 30, 25, _("No. of bars in stereochemistry down bond:")),
   def(5, 250, 75, 25, _("Default")),
   canc(80, 250, 75, 25, _("Cancel")),
   ok(160, 250, 80, 25, _("OK"))
{

    
  g1.hide();

  ostringstream pout;
  pout << __pref.getGridSpacing();
  grsp.value(pout.str().c_str());
  g1.add(grsp);



  ostringstream pout4;
  pout4 << __pref.get_sensib_leg ();
  sens.value(pout4.str().c_str());
  g1.add(sens);

  ostringstream poutw;
  poutw << __pref.getPageWidth();
  _page_w.value(poutw.str().c_str());
  g1.add(_page_w);

  ostringstream pouth;
  pouth << __pref.getPageHeight();
  _page_h.value(pouth.str().c_str());
  g1.add(_page_h);

  _show_splash.down_box(FL_DOWN_BOX);
 
  if(__pref.getSplash()){
    _show_splash.set();
  }
  
  g1.add(_show_splash);   
  
  o.down_box(FL_DOWN_BOX);
  if(__pref.getDrawGrid()){
    o.set();
  }
  
  g1.add(o); 

  g1.add(quantize_pos);

  if(__pref.getMagnetic_point_gap()>0){
    quantize_pos.set();
  }
  g1.end();
  
  ostringstream pout2; 
  pout2 << __pref.getBond_fixedlength();
  bdl.value(pout2.str().c_str());
  g2.add(bdl); 



  ostringstream pout3;
  pout3 << rad2deg(__pref.getBond_fixedangle());
  bda.value(pout3.str().c_str());
  g2.add(bda); 
  
  


  ostringstream pout5;
  pout5 << __pref.get_arr_w();
  arw.value(pout5.str().c_str());
  g2.add(arw);
  


  ostringstream pout6;
  pout6 << __pref.get_arr_h();
  arh.value(pout6.str().c_str());
  g2.add(arh);


  ostringstream pout_arr_gap;
  pout_arr_gap << __pref.get_arr_gap();
  std::cerr << "arr_gap " << __pref.get_arr_gap() << std::endl;
  argap.value(pout_arr_gap.str().c_str());
  g2.add(argap);


  ostringstream pout7;
  pout7 << __pref.getDoubleBondOffset();
  dbs.value(pout7.str().c_str());
  g2.add(dbs);




  ostringstream pout8;
  pout8 << __pref.get_tratteggio_legame();
  bndd.value(pout8.str().c_str());
  g2.add(bndd);



  ostringstream pout9;
  pout9 << __pref.get_larg_max_cuneo();
  lmaxc.value(pout9.str().c_str());
  g2.add(lmaxc);



 
  ostringstream pout10;
  pout10 << __pref.get_multiple_bond_gap();
  mbg.value(pout10.str().c_str());
  g2.add(mbg);




  ostringstream pout11;
  pout11 << __pref.get_frequenza_stereo_scon();
  freq.value(pout11.str().c_str());
  g2.add(freq);
  


  ostringstream pout12;
  pout12 << __pref.get_ampiezza_stereo_scon();
  amp.value(pout12.str().c_str());
  g2.add(amp);
  

  ostringstream pout13;
  pout13 << __pref.get_num_barrette_stereo_down();
  numb.value(pout13.str().c_str());
  g2.add(numb);
  
  g2.end();

  ui_tab.add(g1);
  ui_tab.add(g2);
  ui_tab.end();
  
  add(ui_tab);


  def.callback(pref_reset_to_default_cb);
  add(def);

  
  canc.callback(pref_canc_cb);
  add(canc);
  


  ok.callback(pref_write_conf_cb);
  add(ok);
  


  
  end();
  set_modal();
  
}

