#!/usr/bin/env python
# file test_lyxserver_no_running_lyx.py
"""Test functions and classes in the LyX.lyxserver module

Set of lyxserver tests that test the startup of LyX
(to be run without running LyX session)

Revision History:

2005-02-23 G. Milde first version with the unittest framework
"""

from unittest import TestCase, main 
import os, sys, types

from LyX.lyxserver import *
from LyX.lyxclient import LyXClient

logger.setLevel(logging.DEBUG) 

testfiles = [os.path.join(os.path.dirname(__file__), "test.lyx"),
             os.path.join(os.path.dirname(__file__), "test2.lyx")]

def warn_for_running_lyx():
        """Warn the user if a LyX is running when starting the tests"""
        
        if 0 == os.system('ps -u "$USER" | grep -w %s'%LYXCMD.split()[0]):
            sys.exit("""Going to test the lyxserver.
        
        WARNING: Please close any running LyX session.
        otherwise damage to your documents might occure!""")


class lyxserverTests(TestCase):
    """Test public functions in lyxserver.py"""
    #
    def test_lyxpipe_no_lyxcmd(self):
        """lyxpipe should not start lyx, if lyxcmd is None"""
        self.assertRaises(OSError, lyxpipe, lyxcmd=None)
    #
    def test_lyxpipe_wrong_path(self):
        """lyxpipe should not start lyx, if dirname(path) doesnot exist"""
        self.assertRaises(OSError, lyxpipe, 
                          lyxcmd=LYXCMD, path="/tmp/nonexisting/lyxpipe")
    #
    # this test takes 20 s, so I commented it out
    # def test_lyxpipe_wrong_command(self):
    #     """lyxpipe should fail with OSError, if `lyxcmd` doesnot exist"""
    #     self.assertRaises(OSError, lyxpipe, lyxcmd="foo")
    #
    def test_lyxpipe_leftover_pipe(self):
        """lyxpipe should remove (closed) leftover pipes"""
        os.mkfifo(SERVERPIPE + ".in")
        os.mkfifo(SERVERPIPE + ".out")
        try:
            lyxpipe()
        except OSError:
            pass
        # try removing the serverpipes (so there are no leftovers in case
        # on test-failure) test whether they are already gone....
        self.assertRaises(OSError, os.remove, SERVERPIPE + ".in")
        self.assertRaises(OSError, os.remove, SERVERPIPE + ".out")


class LyXServerTests(TestCase):
    """Test the lyxserver.LyXServer class"""
    
    def test__init__nostart_lyxcmd(self):
        """LyxServer.__init__ should not start lyxcmd immediately"""
        lyx2 = LyXServer(lyxcmd=LYXCMD)
        no_lyx = os.system('ps -u "$USER" | grep -w %s'%LYXCMD.split()[0])
        self.failIfEqual(0, no_lyx, msg="ps detected a lyx process")
    
    def test_open(self):
        """LyXServer.open should start lyxcmd if needed"""
        lyx2 = LyXServer(lyxcmd=None)
        self.assertRaises(OSError, lyx2.open)



if __name__ == '__main__':    #run tests if called from command-line
    warn_for_running_lyx()
    main()
