/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.35
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

namespace be.belgium.eid {

using System;
using System.Runtime.InteropServices;

/// <summary>
/// This class represents a Belgium EID card.
/// To get such an object you have to ask it from the ReaderContext.
/// </summary>
public class BEID_EIDCard : BEID_SmartCard {
  private HandleRef swigCPtr;

  internal BEID_EIDCard(IntPtr cPtr, bool cMemoryOwn) : base(beidlib_dotNetPINVOKE.BEID_EIDCardUpcast(cPtr), cMemoryOwn) {
    swigCPtr = new HandleRef(this, cPtr);
  }

  internal static HandleRef getCPtr(BEID_EIDCard obj) {
    return (obj == null) ? new HandleRef(null, IntPtr.Zero) : obj.swigCPtr;
  }

  ~BEID_EIDCard() {
    Dispose();
  }

  public override void Dispose() {
    lock(this) {
      if(swigCPtr.Handle != IntPtr.Zero && swigCMemOwn) {
        swigCMemOwn = false;
        beidlib_dotNetPINVOKE.delete_BEID_EIDCard(swigCPtr);
      }
      swigCPtr = new HandleRef(null, IntPtr.Zero);
      GC.SuppressFinalize(this);
      base.Dispose();
    }
  }

  /// <summary>Return true if the user allow the application.</summary>
  public static bool isApplicationAllowed()
  {
    bool ret = beidlib_dotNetPINVOKE.BEID_EIDCard_isApplicationAllowed();
    if (beidlib_dotNetPINVOKE.SWIGPendingException.Pending) throw beidlib_dotNetPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  /// <summary>Return true this is a test card.</summary>
  public virtual bool isTestCard()
  {
    bool ret = beidlib_dotNetPINVOKE.BEID_EIDCard_isTestCard(swigCPtr);
    if (beidlib_dotNetPINVOKE.SWIGPendingException.Pending) throw beidlib_dotNetPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  /// <summary>Return true if test card are allowed.</summary>
  public virtual bool getAllowTestCard()
  {
    bool ret = beidlib_dotNetPINVOKE.BEID_EIDCard_getAllowTestCard(swigCPtr);
    if (beidlib_dotNetPINVOKE.SWIGPendingException.Pending) throw beidlib_dotNetPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  /// <summary>Set the flag to allow the test cards.</summary>
  public virtual void setAllowTestCard(bool allow)
  {
    beidlib_dotNetPINVOKE.BEID_EIDCard_setAllowTestCard(swigCPtr, allow);
    if (beidlib_dotNetPINVOKE.SWIGPendingException.Pending) throw beidlib_dotNetPINVOKE.SWIGPendingException.Retrieve();
  }

  /// <summary>
  /// Return the status of the data (RRN certificate validity).
  /// </summary>
  public virtual BEID_CertifStatus getDataStatus()
  {
    BEID_CertifStatus ret = (BEID_CertifStatus)beidlib_dotNetPINVOKE.BEID_EIDCard_getDataStatus(swigCPtr);
    if (beidlib_dotNetPINVOKE.SWIGPendingException.Pending) throw beidlib_dotNetPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  /// <summary>
  /// Return a document from the card.
  /// </summary>
  /// <remarks>
  /// Throw BEID_ExDocTypeUnknown exception if the document doesn't exist for this card.
  /// </remarks>
  public override BEID_XMLDoc getDocument(BEID_DocumentType type)
  {
	switch(type)
	{
	case BEID_DocumentType.BEID_DOCTYPE_FULL:
		return getFullDoc();
	case BEID_DocumentType.BEID_DOCTYPE_ID:
		return getID();
	case BEID_DocumentType.BEID_DOCTYPE_PICTURE:
		return getPicture();
	case BEID_DocumentType.BEID_DOCTYPE_INFO:
		return getVersionInfo();
	case BEID_DocumentType.BEID_DOCTYPE_PINS:
		return getPins();
	case BEID_DocumentType.BEID_DOCTYPE_CERTIFICATES:
		return getCertificates();
	default:
		throw new BEID_ExDocTypeUnknown();
	}
}
  /// <summary>Get the full document.</summary>
  public BEID_EIdFullDoc getFullDoc() {
    BEID_EIdFullDoc ret = new BEID_EIdFullDoc(beidlib_dotNetPINVOKE.BEID_EIDCard_getFullDoc(swigCPtr), false);
    if (beidlib_dotNetPINVOKE.SWIGPendingException.Pending) throw beidlib_dotNetPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  /// <summary>Get the id document.</summary>
  public BEID_EId getID() {
    BEID_EId ret = new BEID_EId(beidlib_dotNetPINVOKE.BEID_EIDCard_getID(swigCPtr), false);
    if (beidlib_dotNetPINVOKE.SWIGPendingException.Pending) throw beidlib_dotNetPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  /// <summary>Get the picture document.</summary>
  public BEID_Picture getPicture() {
    BEID_Picture ret = new BEID_Picture(beidlib_dotNetPINVOKE.BEID_EIDCard_getPicture(swigCPtr), false);
    if (beidlib_dotNetPINVOKE.SWIGPendingException.Pending) throw beidlib_dotNetPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  /// <summary>Get the info document.</summary>
  public BEID_CardVersionInfo getVersionInfo() {
    BEID_CardVersionInfo ret = new BEID_CardVersionInfo(beidlib_dotNetPINVOKE.BEID_EIDCard_getVersionInfo(swigCPtr), false);
    if (beidlib_dotNetPINVOKE.SWIGPendingException.Pending) throw beidlib_dotNetPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  /// <summary>Return certificate by type from the card.</summary>
  public BEID_Certificate getCert(BEID_CertifType type) {
    BEID_Certificate ret = new BEID_Certificate(beidlib_dotNetPINVOKE.BEID_EIDCard_getCert(swigCPtr, (int)type), false);
    if (beidlib_dotNetPINVOKE.SWIGPendingException.Pending) throw beidlib_dotNetPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  /// <summary>Return the RRN certificate from the card.</summary>
  public BEID_Certificate getRrn() {
    BEID_Certificate ret = new BEID_Certificate(beidlib_dotNetPINVOKE.BEID_EIDCard_getRrn(swigCPtr), false);
    if (beidlib_dotNetPINVOKE.SWIGPendingException.Pending) throw beidlib_dotNetPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  /// <summary>Return the root certificate from the card.</summary>
  public BEID_Certificate getRoot() {
    BEID_Certificate ret = new BEID_Certificate(beidlib_dotNetPINVOKE.BEID_EIDCard_getRoot(swigCPtr), false);
    if (beidlib_dotNetPINVOKE.SWIGPendingException.Pending) throw beidlib_dotNetPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  /// <summary>Return the ca certificate from the card.</summary>
  public BEID_Certificate getCA() {
    BEID_Certificate ret = new BEID_Certificate(beidlib_dotNetPINVOKE.BEID_EIDCard_getCA(swigCPtr), false);
    if (beidlib_dotNetPINVOKE.SWIGPendingException.Pending) throw beidlib_dotNetPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  /// <summary>Return the signature certificate from the card.</summary>
  public BEID_Certificate getSignature()
  {
    BEID_Certificate ret = new BEID_Certificate(beidlib_dotNetPINVOKE.BEID_EIDCard_getSignature(swigCPtr), false);
    if (beidlib_dotNetPINVOKE.SWIGPendingException.Pending) throw beidlib_dotNetPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  /// <summary>Return the authentication certificate from the card.</summary>
  public BEID_Certificate getAuthentication()
  {
    BEID_Certificate ret = new BEID_Certificate(beidlib_dotNetPINVOKE.BEID_EIDCard_getAuthentication(swigCPtr), false);
    if (beidlib_dotNetPINVOKE.SWIGPendingException.Pending) throw beidlib_dotNetPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  /// <summary>
  /// Return a raw data from the card.
  /// </summary>
  /// <remarks>
  /// Throw BEID_ExFileTypeUnknown exception if the document doesn't exist for this card. 
  /// </remarks>
  public override BEID_ByteArray getRawData(BEID_RawDataType type)
  {
    BEID_ByteArray ret = new BEID_ByteArray(beidlib_dotNetPINVOKE.BEID_EIDCard_getRawData(swigCPtr, (int)type), false);
    if (beidlib_dotNetPINVOKE.SWIGPendingException.Pending) throw beidlib_dotNetPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  /// <summary>Get the Id RawData.</summary>
  public BEID_ByteArray getRawData_Id()
  {
    BEID_ByteArray ret = new BEID_ByteArray(beidlib_dotNetPINVOKE.BEID_EIDCard_getRawData_Id(swigCPtr), false);
    if (beidlib_dotNetPINVOKE.SWIGPendingException.Pending) throw beidlib_dotNetPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  /// <summary>Get the IdSig RawData.</summary>
  public BEID_ByteArray getRawData_IdSig()
  {
    BEID_ByteArray ret = new BEID_ByteArray(beidlib_dotNetPINVOKE.BEID_EIDCard_getRawData_IdSig(swigCPtr), false);
    if (beidlib_dotNetPINVOKE.SWIGPendingException.Pending) throw beidlib_dotNetPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  /// <summary>Get the Addr RawData.</summary>
  public BEID_ByteArray getRawData_Addr()
  {
    BEID_ByteArray ret = new BEID_ByteArray(beidlib_dotNetPINVOKE.BEID_EIDCard_getRawData_Addr(swigCPtr), false);
    if (beidlib_dotNetPINVOKE.SWIGPendingException.Pending) throw beidlib_dotNetPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  /// <summary>Get the AddrSig RawData.</summary>
  public BEID_ByteArray getRawData_AddrSig()
  {
    BEID_ByteArray ret = new BEID_ByteArray(beidlib_dotNetPINVOKE.BEID_EIDCard_getRawData_AddrSig(swigCPtr), false);
    if (beidlib_dotNetPINVOKE.SWIGPendingException.Pending) throw beidlib_dotNetPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  /// <summary>Get the picture RawData.</summary>
  public BEID_ByteArray getRawData_Picture()
  {
    BEID_ByteArray ret = new BEID_ByteArray(beidlib_dotNetPINVOKE.BEID_EIDCard_getRawData_Picture(swigCPtr), false);
    if (beidlib_dotNetPINVOKE.SWIGPendingException.Pending) throw beidlib_dotNetPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  /// <summary>Get the Card Info RawData.</summary>
  public BEID_ByteArray getRawData_CardInfo()
  {
    BEID_ByteArray ret = new BEID_ByteArray(beidlib_dotNetPINVOKE.BEID_EIDCard_getRawData_CardInfo(swigCPtr), false);
    if (beidlib_dotNetPINVOKE.SWIGPendingException.Pending) throw beidlib_dotNetPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  /// <summary>Get the Token Info RawData.</summary>
  public BEID_ByteArray getRawData_TokenInfo()
  {
    BEID_ByteArray ret = new BEID_ByteArray(beidlib_dotNetPINVOKE.BEID_EIDCard_getRawData_TokenInfo(swigCPtr), false);
    if (beidlib_dotNetPINVOKE.SWIGPendingException.Pending) throw beidlib_dotNetPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  /// <summary>Get the Cert RRN RawData.</summary>
  public BEID_ByteArray getRawData_CertRRN()
  {
    BEID_ByteArray ret = new BEID_ByteArray(beidlib_dotNetPINVOKE.BEID_EIDCard_getRawData_CertRRN(swigCPtr), false);
    if (beidlib_dotNetPINVOKE.SWIGPendingException.Pending) throw beidlib_dotNetPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  /// <summary>Get the challenge RawData.</summary>
  public BEID_ByteArray getRawData_Challenge()
  {
    BEID_ByteArray ret = new BEID_ByteArray(beidlib_dotNetPINVOKE.BEID_EIDCard_getRawData_Challenge(swigCPtr), false);
    if (beidlib_dotNetPINVOKE.SWIGPendingException.Pending) throw beidlib_dotNetPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

  /// <summary>Get the response RawData.</summary>
  public BEID_ByteArray getRawData_Response()
  {
    BEID_ByteArray ret = new BEID_ByteArray(beidlib_dotNetPINVOKE.BEID_EIDCard_getRawData_Response(swigCPtr), false);
    if (beidlib_dotNetPINVOKE.SWIGPendingException.Pending) throw beidlib_dotNetPINVOKE.SWIGPendingException.Retrieve();
    return ret;
  }

}

}
