#! /bin/sh
 
# Create crontab entry
cat > ora2pg.cron << _EOF_
#
# System monitoring
#*/1 * * * * /usr/bin/ora2pg > /dev/null 2>&1
#*/5 * * * * /usr/bin/ora2pggraph > /dev/null 2>&1
_EOF_

# Create default httpd configuration
cat > httpd-ora2pg.conf << _EOF_
#
# By default Ora2Pg statistics are only accessible from the local host.
#
Alias /ora2pg /var/www/ora2pg

<Directory /var/www/ora2pg>
    Options All
    Order deny,allow
    Deny from all
    Allow from 127.0.0.1
    Allow from ::1
    # Allow from .example.com
</Directory>
_EOF_

# Append crontab entry to root user
cat ora2pg.cron >> /var/spool/cron/crontabs/root
rm -f ora2pg.cron
# Append Apache configuration
install -D -m 0644 httpd-ora2pg.conf /etc/httpd/extra/httpd-ora2pg.conf

cat >> /etc/httpd/httpd.conf << _EOF_

# Uncomment the following line to limit access to Ora2Pg statistics
#
#Include /etc/httpd/extra/httpd-ora2pg.conf

_EOF_

cat install/README.Slackware

