<?php
/** 
*
* common [Thai]
*
* @package language
* @version $Id: common.php 9162 2008-12-03 11:18:31Z acydburn $
* @copyright (c) 2005 phpBB Group 
* @license http://opensource.org/licenses/gpl-license.php GNU Public License 
*
*/

/**
* DO NOT CHANGE
*/
if (!defined('IN_PHPBB'))
{
	exit;
}

if (empty($lang) || !is_array($lang))
{
	$lang = array();
}

// DEVELOPERS PLEASE NOTE
//
// All language files should use UTF-8 as their encoding and the files must not contain a BOM.
//
// Placeholders can now contain order information, e.g. instead of
// 'Page %s of %s' you can (and should) write 'Page %1$s of %2$s', this allows
// translators to re-order the output of data while ensuring it remains correct
//
// You do not need this where single placeholders are used, e.g. 'Message %d' is fine
// equally where a string contains only two placeholders which are used to wrap text
// in a url you again do not need to specify an order e.g., 'Click %sHERE%s' is fine
//
// Some characters you may want to copy&paste: 
// ’ » “ ” …
//

$lang = array_merge($lang, array(
	'TRANSLATION_INFO'	=> 'แปลเป็นภาษาไทยโดย SuperToy [supertoync (at) gmail.com]',
	'DIRECTION'			=> 'ltr',
	'DATE_FORMAT'		=> '|d M Y|',	// 01 Jan 2007 (with Relative days enabled)
	'USER_LANG'			=> 'th',

	'1_DAY'			=> '1 วัน',
	'1_MONTH'		=> '1 เดือน',
	'1_YEAR'		=> '1 ปี',
	'2_WEEKS'		=> '2 สัปดาห์',
	'3_MONTHS'		=> '3 เดือน',
	'6_MONTHS'		=> '6 เดือน',
	'7_DAYS'		=> '7 วัน',

	'ACCOUNT_ALREADY_ACTIVATED'		=> 'Your account has already been activated.',
	'ACCOUNT_DEACTIVATED'			=> 'Your account has been manually deactivated and is only able to be reactivated by an administrator.',
	'ACCOUNT_NOT_ACTIVATED'			=> 'Your account has not been activated yet.',
	'ACP'							=> 'Administration Control Panel',
	'ACTIVE'						=> 'active',
	'ACTIVE_ERROR'					=> 'The specified username is currently inactive. If you have problems activating your account, please contact a board administrator.',
	'ADMINISTRATOR'					=> 'Administrator',
	'ADMINISTRATORS'				=> 'Administrators',
	'AGE'							=> 'Age',
	'AIM'							=> 'AIM',
	'ALLOWED'						=> 'Allowed',
	'ALL_FILES'						=> 'All files',
	'ALL_FORUMS'					=> 'All forums',
	'ALL_MESSAGES'					=> 'All messages',
	'ALL_POSTS'						=> 'All posts',
	'ALL_TIMES'						=> 'ปรับเวลา %1$s %2$s',
	'ALL_TOPICS'					=> 'ทุกหัวข้อ',
	'AND'							=> 'And',
	'ARE_WATCHING_FORUM'			=> 'You have subscribed to be notified of new posts in this forum.',
	'ARE_WATCHING_TOPIC'			=> 'You have subscribed to be notified of new posts in this topic.',
	'ASCENDING'						=> 'น้อย-มาก',
	'ATTACHMENTS'					=> 'Attachments',
	'ATTACHED_IMAGE_NOT_IMAGE'		=> 'The image file you tried to attach is invalid.',
	'AUTHOR'						=> 'ผู้ตั้ง',
	'AUTH_NO_PROFILE_CREATED'		=> 'The creation of a user profile was unsuccessful.',
	'AVATAR_DISALLOWED_CONTENT'		=> 'The upload was rejected because the uploaded file was identified as a possible attack vector.',
	'AVATAR_DISALLOWED_EXTENSION'	=> 'This file cannot be displayed because the extension <strong>%s</strong> is not allowed.',
	'AVATAR_EMPTY_REMOTE_DATA'		=> 'The specified avatar could not be uploaded because the remote data appears to be invalid or corrupted.',
	'AVATAR_EMPTY_FILEUPLOAD'		=> 'The uploaded avatar file is empty.',
	'AVATAR_INVALID_FILENAME'		=> '%s is an invalid filename.',
	'AVATAR_NOT_UPLOADED'			=> 'Avatar could not be uploaded.',
	'AVATAR_NO_SIZE'				=> 'The width or height of the linked avatar could not be determined. Please enter them manually.',
	'AVATAR_PARTIAL_UPLOAD'			=> 'The specified file was only partially uploaded.',
	'AVATAR_PHP_SIZE_NA'			=> 'The avatar’s filesize is too large.<br />The maximum allowed filesize set in php.ini could not be determined.',
	'AVATAR_PHP_SIZE_OVERRUN'       => 'The avatar’s filesize is too large. The maximum allowed upload size is %1$d %2$s.<br />Please note this is set in php.ini and cannot be overridden.',
	'AVATAR_URL_INVALID'			=> 'The URL you specified is invalid.',
	'AVATAR_URL_NOT_FOUND'			=> 'The file specified could not be found.',
	'AVATAR_WRONG_FILESIZE'			=> 'The avatar’s filesize must be between 0 and %1d %2s.',
	'AVATAR_WRONG_SIZE'				=> 'The submitted avatar is %5$d pixels wide and %6$d pixels high. Avatars must be at least %1$d pixels wide and %2$d pixels high, but no larger than %3$d pixels wide and %4$d pixels high.',

	'BACK_TO_TOP'			=> 'Top',
	'BACK_TO_PREV'			=> 'Back to previous page',
	'BAN_TRIGGERED_BY_EMAIL'=> 'A ban has been issued on your e-mail address.',
	'BAN_TRIGGERED_BY_IP'	=> 'A ban has been issued on your IP address.',
	'BAN_TRIGGERED_BY_USER'	=> 'A ban has been issued on your username.',
	'BBCODE_GUIDE'			=> 'BBCode guide',
	'BCC'					=> 'BCC',
	'BIRTHDAYS'				=> 'วันเกิด',
	'BOARD_BAN_PERM'		=> 'You have been <strong>permanently</strong> banned from this board.<br /><br />Please contact the %2$sBoard Administrator%3$s for more information.',
	'BOARD_BAN_REASON'		=> 'Reason given for ban: <strong>%s</strong>',
	'BOARD_BAN_TIME'		=> 'You have been banned from this board until <strong>%1$s</strong>.<br /><br />Please contact the %2$sBoard Administrator%3$s for more information.',
	'BOARD_DISABLE'			=> 'ขออภัย. เว็บบอร์ดนี้ยังไม่พร้อมใช้งาน',
	'BOARD_DISABLED'		=> 'This board is currently disabled.',
	'BOARD_UNAVAILABLE'		=> 'Sorry but the board is temporarily unavailable, please try again in a few minutes.',
	'BROWSING_FORUM'		=> 'Users browsing this forum: %1$s',
	'BROWSING_FORUM_GUEST'	=> 'ผู้ที่กำลังอ่าน forum นี้: สมาชิก %1$s และ ผู้เยี่ยมชม %2$d คน',
	'BROWSING_FORUM_GUESTS'	=> 'ผู้ที่กำลังอ่าน forum นี้: สมาชิก %1$s และ ผู้เยี่ยมชม %2$d คน',
	'BYTES'					=> 'ไบต์',

	'CANCEL'				=> 'ยกเลิก',
	'CHANGE'				=> 'Change',
	'CHANGE_FONT_SIZE'		=> 'เปลี่ยนขนาดตัวอักษร',
	'CHANGING_PREFERENCES'	=> 'กำลังแก้ไขการตั้งค่าของบอร์ด',
	'CHANGING_PROFILE'		=> 'กำลังแก้ไขข้อมูลส่วนตัว',
	'CLICK_VIEW_PRIVMSG'	=> '%sGo to your inbox%s',
	'COLLAPSE_VIEW'			=> 'Collapse view',
	'CLOSE_WINDOW'			=> 'ปิดหน้าต่างนี้',
	'COLOUR_SWATCH'			=> 'Colour swatch',
	'COMMA_SEPARATOR'		=> ', ',	// Used in pagination of ACP & prosilver, use localised comma if appropriate, eg: Ideographic or Arabic
	'CONFIRM'				=> 'ยืนยัน',
	'CONFIRM_CODE'			=> 'Confirmation code',
	'CONFIRM_CODE_EXPLAIN'	=> 'Enter the code exactly as it appears. All letters are case insensitive, there is no zero.',
	'CONFIRM_CODE_WRONG'	=> 'The confirmation code you entered was incorrect.',
	'CONFIRM_OPERATION'		=> 'คุณต้องการทำคำสั่งนี้จริงๆหรือ?',
	'CONGRATULATIONS'		=> 'Congratulations to',
	'CONNECTION_FAILED'		=> 'Connection failed.',
	'CONNECTION_SUCCESS'	=> 'Connection was successful!',
	'COOKIES_DELETED'		=> 'All board cookies successfully deleted.',
	'CURRENT_TIME'			=> 'เวลาขณะนี้ %s',

	'DAY'					=> 'วัน',
	'DAYS'					=> 'วัน',
	'DELETE'				=> 'Delete',
	'DELETE_ALL'			=> 'Delete all',
	'DELETE_COOKIES'		=> 'ลบ cookie ของบอร์ด',
	'DELETE_MARKED'			=> 'Delete marked',
	'DELETE_POST'			=> 'Delete post',
	'DELIMITER'				=> 'Delimiter',
	'DESCENDING'			=> 'มาก-น้อย',
	'DISABLED'				=> 'Disabled',
	'DISPLAY'				=> 'Display',
	'DISPLAY_GUESTS'		=> 'Display guests',
	'DISPLAY_MESSAGES'		=> 'แสดงเฉพาะข้อความในระยะเวลา',
	'DISPLAY_POSTS'			=> 'แสดงเฉพาะข้อความในระยะเวลา',
	'DISPLAY_TOPICS'		=> 'แสดงเฉพาะหัวข้อในระยะเวลา',
	'DOWNLOADED'			=> 'Downloaded',
	'DOWNLOADING_FILE'		=> 'Downloading file',
	'DOWNLOAD_COUNT'		=> 'Downloaded %d time',
	'DOWNLOAD_COUNTS'		=> 'Downloaded %d times',
	'DOWNLOAD_COUNT_NONE'	=> 'Not downloaded yet',
	'VIEWED_COUNT'			=> 'Viewed %d time',
	'VIEWED_COUNTS'			=> 'Viewed %d times',
	'VIEWED_COUNT_NONE'		=> 'Not viewed yet',

	'EDIT_POST'							=> 'Edit post',
	'EMAIL'								=> 'E-mail', // Short form for EMAIL_ADDRESS
	'EMAIL_ADDRESS'						=> 'E-mail address',
	'EMAIL_SMTP_ERROR_RESPONSE'			=> 'Ran into problems sending e-mail at <strong>Line %1$s</strong>. Response: %2$s.',
	'EMPTY_SUBJECT'						=> 'กรุณากรอกหัวข้อด้วย',
	'EMPTY_MESSAGE_SUBJECT'				=> 'กรุณากรอกหัวข้อด้วย',
	'ENABLED'							=> 'Enabled',
	'ENCLOSURE'							=> 'Enclosure',
	'ERR_CHANGING_DIRECTORY'			=> 'Unable to change directory.',
	'ERR_CONNECTING_SERVER'				=> 'Error connecting to the server.',
	'ERR_JAB_AUTH'						=> 'Could not authorise on Jabber server.',
	'ERR_JAB_CONNECT'					=> 'Could not connect to Jabber server.',
	'ERR_UNABLE_TO_LOGIN'				=> 'The specified username or password is incorrect.',
	'ERR_UNWATCHING'					=> 'An error occured while trying to unsubscribe.',
	'ERR_WATCHING'						=> 'An error occured while trying to subscribe.',
	'ERR_WRONG_PATH_TO_PHPBB'			=> 'The phpBB path specified appears to be invalid.',
	'EXPAND_VIEW'						=> 'Expand view',
	'EXTENSION'							=> 'Extension',
	'EXTENSION_DISABLED_AFTER_POSTING'	=> 'The extension <strong>%s</strong> has been deactivated and can no longer be displayed.',

	'FAQ'					=> 'ช่วยเหลือ',
	'FAQ_EXPLAIN'			=> 'คำถามที่ถูกถามบ่อยๆ',
	'FILENAME'				=> 'ชื่อไฟล์',
	'FILESIZE'				=> 'ขนาด',
	'FILEDATE'				=> 'วันที่',
	'FILE_COMMENT'			=> 'คำอธิบาย',
	'FILE_NOT_FOUND'		=> 'ไม่พบไฟล์ที่ต้องการ',
	'FIND_USERNAME'			=> 'ค้นหาสมาชิก',
	'FOLDER'				=> 'Folder',
	'FORGOT_PASS'			=> 'ลืม(forget) password',
	'FORM_INVALID'			=> 'The submitted form was invalid. Try submitting again.',
	'FORUM'					=> 'Forum',
	'FORUMS'				=> 'Forums',
	'FORUMS_MARKED'			=> 'All forums have been marked read.',
	'FORUM_CAT'				=> 'Forum category',
	'FORUM_INDEX'			=> 'Board index',
	'FORUM_LINK'			=> 'Forum link',
	'FORUM_LOCATION'		=> 'Forum location',
	'FORUM_LOCKED'			=> 'Forum locked',
	'FORUM_RULES'			=> 'Forum rules',
	'FORUM_RULES_LINK'		=> 'Please click here to view the forum rules',
	'FROM'					=> 'from',
	'FSOCK_DISABLED'		=> 'The operation could not be completed because the <var>fsockopen</var> function has been disabled or the server being queried could not be found.',

	'FTP_FSOCK_HOST'				=> 'FTP host',
	'FTP_FSOCK_HOST_EXPLAIN'		=> 'FTP server used to connect your site.',
	'FTP_FSOCK_PASSWORD'			=> 'FTP password',
	'FTP_FSOCK_PASSWORD_EXPLAIN'	=> 'Password for your FTP username.',
	'FTP_FSOCK_PORT'				=> 'FTP port',
	'FTP_FSOCK_PORT_EXPLAIN'		=> 'Port used to connect to your server.',
	'FTP_FSOCK_ROOT_PATH'			=> 'Path to phpBB',
	'FTP_FSOCK_ROOT_PATH_EXPLAIN'	=> 'Path from the root to your phpBB board.',
	'FTP_FSOCK_TIMEOUT'				=> 'FTP timeout',
	'FTP_FSOCK_TIMEOUT_EXPLAIN'		=> 'The amount of time, in seconds, that the system will wait for a reply from your server.',
	'FTP_FSOCK_USERNAME'			=> 'FTP username',
	'FTP_FSOCK_USERNAME_EXPLAIN'	=> 'Username used to connect to your server.',

	'FTP_HOST'					=> 'FTP host',
	'FTP_HOST_EXPLAIN'			=> 'FTP server used to connect your site.',
	'FTP_PASSWORD'				=> 'FTP password',
	'FTP_PASSWORD_EXPLAIN'		=> 'Password for your FTP username.',
	'FTP_PORT'					=> 'FTP port',
	'FTP_PORT_EXPLAIN'			=> 'Port used to connect to your server.',
	'FTP_ROOT_PATH'				=> 'Path to phpBB',
	'FTP_ROOT_PATH_EXPLAIN'		=> 'Path from the root to your phpBB board.',
	'FTP_TIMEOUT'				=> 'FTP timeout',
	'FTP_TIMEOUT_EXPLAIN'		=> 'The amount of time, in seconds, that the system will wait for a reply from your server.',
	'FTP_USERNAME'				=> 'FTP username',
	'FTP_USERNAME_EXPLAIN'		=> 'Username used to connect to your server.',

	'GENERAL_ERROR'				=> 'เกิดความผิดพลาด',
	'GB'						=> 'GB',
	'GIB'						=> 'GiB',
	'GO'						=> 'ไป',
	'GOTO_PAGE'					=> 'Go to page',
	'GROUP'						=> 'Group',
	'GROUPS'					=> 'Groups',
	'GROUP_ERR_TYPE'			=> 'Inappropriate group type specified.',
	'GROUP_ERR_USERNAME'		=> 'No group name specified.',
	'GROUP_ERR_USER_LONG'		=> 'Group names cannot exceed 60 characters. The specified group name is too long.',
	'GUEST'						=> 'Guest',
	'GUEST_USERS_ONLINE'		=> 'มีผู้มาเยือน %d คน',
	'GUEST_USERS_TOTAL'			=> 'ผู้มาเยือน %d คน',
	'GUEST_USERS_ZERO_ONLINE'	=> 'ไม่มีผู้มาเยือน',
	'GUEST_USERS_ZERO_TOTAL'	=> 'ไม่มีผู้มาเยือน',
	'GUEST_USER_ONLINE'			=> 'มีผู้มาเยือน %d คน',
	'GUEST_USER_TOTAL'			=> 'ผู้มาเยือน %d คน',
	'G_ADMINISTRATORS'			=> 'Administrators',
	'G_BOTS'					=> 'Bots',
	'G_GUESTS'					=> 'Guests',
	'G_REGISTERED'				=> 'Registered users',
	'G_REGISTERED_COPPA'		=> 'Registered COPPA users',
	'G_GLOBAL_MODERATORS'		=> 'Global moderators',

	'HIDDEN_USERS_ONLINE'			=> 'ซ่อน %d คน',
	'HIDDEN_USERS_TOTAL'			=> 'ซ่อน %d คน',
	'HIDDEN_USERS_TOTAL_AND'		=> 'ซ่อน %d คน และ ',
	'HIDDEN_USERS_ZERO_ONLINE'		=> 'ไม่มีผู้ซ่อน',
	'HIDDEN_USERS_ZERO_TOTAL'		=> 'ไม่มีผู้ซ่อน',
	'HIDDEN_USERS_ZERO_TOTAL_AND'	=> 'ไม่มีผู้ซ่อน และ ',
	'HIDDEN_USER_ONLINE'			=> 'ซ่อน %d คน',
	'HIDDEN_USER_TOTAL'				=> 'ซ่อน %d คน',
	'HIDDEN_USER_TOTAL_AND'			=> 'ซ่อน %d คน และ ',
	'HIDE_GUESTS'					=> 'Hide guests',
	'HIDE_ME'						=> 'ซ่อนสถานะการออนไลน์ของฉัน',
	'HOURS'							=> 'ชั่วโมง',
	'HOME'							=> 'Home',

	'ICQ'						=> 'ICQ',
	'ICQ_STATUS'				=> 'ICQ status',	
	'IF'						=> 'If',
	'IMAGE'						=> 'Image',
	'IMAGE_FILETYPE_INVALID'	=> 'Image file type %d for mimetype %s not supported.',
	'IMAGE_FILETYPE_MISMATCH'	=> 'Image file type mismatch: expected extension %1$s but extension %2$s given.',
	'IN'						=> 'in',
	'INDEX'						=> 'Index page',
	'INFORMATION'				=> 'รายละเอียด',
	'INTERESTS'					=> 'สิ่งที่สนใจ',
	'INVALID_DIGEST_CHALLENGE'	=> 'Invalid digest challenge.',
	'INVALID_EMAIL_LOG'			=> '<strong>%s</strong> possibly an invalid e-mail address?',
	'IP'						=> 'IP',
	'IP_BLACKLISTED'			=> 'Your IP %1$s has been blocked because it is blacklisted. For details please see <a href="%2$s">%2$s</a>.',

	'JABBER'				=> 'Jabber',
	'JOINED'				=> 'สมัครสมาชิก',
	'JUMP_PAGE'				=> 'Enter the page number you wish to go to',
	'JUMP_TO'				=> 'ไปที่',
	'JUMP_TO_PAGE'			=> 'Click to jump to page…',

	'KB'					=> 'KB',
	'KIB'					=> 'KiB',

	'LAST_POST'							=> 'ตอบล่าสุด',
	'LAST_UPDATED'						=> 'Last updated',
	'LAST_VISIT'						=> 'Last visit',
	'LDAP_NO_LDAP_EXTENSION'			=> 'LDAP extension not available.',
	'LDAP_NO_SERVER_CONNECTION'			=> 'Could not connect to LDAP server.',
	'LEGEND'							=> '<font face=\'Tahoma,MS Sans Serif\'>สัญลักษณ์</font>',
	'LOCATION'							=> 'ที่อยู่',
	'LOCK_POST'							=> 'Lock post',
	'LOCK_POST_EXPLAIN'					=> 'Prevent editing',
	'LOCK_TOPIC'						=> 'Lock topic',
	'LOGIN'								=> 'เข้าสู่ระบบ(Log in)',
	'LOGIN_CHECK_PM'					=> 'Log in to check your private messages.',
	'LOGIN_CONFIRMATION'				=> 'Confirmation of login',
	'LOGIN_CONFIRM_EXPLAIN'				=> 'To prevent brute forcing accounts the board requires you to enter a confirmation code after a maximum amount of failed logins. The code is displayed in the image you should see below. If you are visually impaired or cannot otherwise read this code please contact the %sBoard Administrator%s.',
	'LOGIN_ERROR_ATTEMPTS'				=> 'You exceeded the maximum allowed number of login attempts. In addition to your username and password you now also have to enter the confirm code from the image you see below.',
	'LOGIN_ERROR_EXTERNAL_AUTH_APACHE'	=> 'You have not been authenticated by Apache.',
	'LOGIN_ERROR_PASSWORD'				=> 'You have specified an incorrect password. Please check your password and try again. If you continue to have problems please contact the %sBoard Administrator%s.',
	'LOGIN_ERROR_PASSWORD_CONVERT'		=> 'It was not possible to convert your password when updating this bulletin board’s software. Please %srequest a new password%s. If you continue to have problems please contact the %sBoard Administrator%s.',
	'LOGIN_ERROR_USERNAME'				=> 'You have specified an incorrect username. Please check your username and try again. If you continue to have problems please contact the %sBoard Administrator%s.',
	'LOGIN_FORUM'						=> 'To view or post in this forum you must enter its password.',
	'LOGIN_INFO'						=> 'ก่อนจะทำการเข้าสู่ระบบ คุณจะต้องสมัครสมาชิกก่อน การสมัครสมาชิกจะใช้เวลา 2-3 นาที ผู้ดูแลบอร์ดอาจให้สิทธิพิเศษแก่ผู้ที่เป็นสมาชิก <br />ก่อนที่คุณจะเข้าสู่ระบบ กรุณาอ่านเงื่อนไขการใช้งานและนโยบายการปกป้องข้อมูลส่วนตัว และกรุณาอ่านกฎของแต่ละ forum ด้วย',
	'LOGIN_VIEWFORUM'					=> 'The board requires you to be registered and logged in to view this forum.',
	'LOGIN_EXPLAIN_EDIT'				=> 'In order to edit posts in this forum you have to be registered and logged in.',
	'LOGIN_EXPLAIN_VIEWONLINE'			=> 'In order to view the online list you have to be registered and logged in.',
	'LOGOUT'							=> 'ออกจากระบบ',
	'LOGOUT_USER'						=> 'ออกจากระบบ [ %s ]',
	'LOG_ME_IN'							=> 'เข้าสู่ระบบโดยอัตโนมัติทุกครั้ง',

	'MARK'					=> 'Mark',
	'MARK_ALL'				=> 'Mark all',
	'MARK_FORUMS_READ'		=> 'บันทึกว่าอ่านทุก forum แล้ว',
	'MB'					=> 'MB',
	'MIB'					=> 'MiB',
	'MCP'					=> 'Moderator Control Panel',
	'MEMBERLIST'			=> 'รายชื่อสมาชิก',
	'MEMBERLIST_EXPLAIN'	=> 'View complete list of members',
	'MERGE'					=> 'Merge',
	'MERGE_POSTS'			=> 'Merge posts',
	'MERGE_TOPIC'			=> 'Merge topic',
	'MESSAGE'				=> 'Message',
	'MESSAGES'				=> 'Messages',
	'MESSAGE_BODY'			=> 'Message body',
	'MINUTES'				=> 'นาที',
	'MODERATE'				=> 'Moderate',
	'MODERATOR'				=> 'Moderator',
	'MODERATORS'			=> 'Moderators',
	'MONTH'					=> 'เดือน',
	'MOVE'					=> 'Move',
	'MSNM'					=> 'MSNM/WLM',	

	'NA'						=> 'N/A',
	'NEWEST_USER'				=> 'สมาชิกล่าสุดคือ <strong>%s</strong>',
	'NEW_MESSAGE'				=> 'New message',
	'NEW_MESSAGES'				=> 'ข้อความใหม่',
	'NEW_PM'					=> '<strong>%d</strong> ข้อความใหม่',
	'NEW_PMS'					=> '<strong>%d</strong> ข้อความใหม่',
	'NEW_POST'					=> 'New post',
	'NEW_POSTS'					=> 'New posts',
	'NEXT'						=> 'Next',		// Used in pagination
	'NEXT_STEP'					=> 'Next',
	'NEVER'						=> 'Never',
	'NO'						=> 'ไม่ใช่',
	'NOT_ALLOWED_MANAGE_GROUP'	=> 'You are not allowed to manage this group.',
	'NOT_AUTHORISED'			=> 'You are not authorised to access this area.',
	'NOT_WATCHING_FORUM'		=> 'You are no longer subscribed to updates on this forum.',
	'NOT_WATCHING_TOPIC'		=> 'You are no longer subscribed to this topic.',
	'NOTIFY_ADMIN'				=> 'Please notify the board administrator or webmaster.',
	'NOTIFY_ADMIN_EMAIL'		=> 'Please notify the board administrator or webmaster: <a href="mailto:%1$s">%1$s</a>',
	'NO_ACCESS_ATTACHMENT'		=> 'You are not allowed to access this file.',
	'NO_ACTION'					=> 'No action specified.',
	'NO_ADMINISTRATORS'			=> 'There are no administrators.',
	'NO_AUTH_ADMIN'				=> 'Access to the Administration Control Panel is not allowed as you do not have administrative permissions.',
	'NO_AUTH_ADMIN_USER_DIFFER'	=> 'You are not able to re-authenticate as a different user.',
	'NO_AUTH_OPERATION'			=> 'You do not have the necessary permissions to complete this operation.',
	'NO_CONNECT_TO_SMTP_HOST'	=> 'Could not connect to smtp host : %1$s : %2$s',
	'NO_BIRTHDAYS'				=> 'No birthdays today',
	'NO_EMAIL_MESSAGE'			=> 'E-mail message was blank.',
	'NO_EMAIL_RESPONSE_CODE'	=> 'Could not get mail server response codes.',
	'NO_EMAIL_SUBJECT'			=> 'No e-mail subject specified.',
	'NO_FORUM'					=> 'The forum you selected does not exist.',
	'NO_FORUMS'					=> 'This board has no forums.',
	'NO_GROUP'					=> 'The requested usergroup does not exist.',
	'NO_GROUP_MEMBERS'			=> 'This group currently has no members.',
	'NO_IPS_DEFINED'			=> 'No IP addresses or hostnames defined',
	'NO_MEMBERS'				=> 'No members found for this search criterion.',
	'NO_MESSAGES'				=> 'No messages',
	'NO_MODE'					=> 'No mode specified.',
	'NO_MODERATORS'				=> 'There are no moderators.',
	'NO_NEW_MESSAGES'			=> 'No new messages',
	'NO_NEW_PM'					=> '<strong>ไม่มี</strong>ข้อความใหม่',
	'NO_NEW_POSTS'				=> 'No new posts',
	'NO_ONLINE_USERS'			=> 'ไม่มีสมาชิก',
	'NO_POSTS'					=> 'No posts',
	'NO_POSTS_TIME_FRAME'		=> 'No posts exist inside this topic for the selected time frame.',
	'NO_SUBJECT'				=> 'No subject specified',								// Used for posts having no subject defined but displayed within management pages.
	'NO_SUCH_SEARCH_MODULE'		=> 'The specified search backend doesn’t exist.',
	'NO_SUPPORTED_AUTH_METHODS'	=> 'No supported authentication methods.',
	'NO_TOPIC'					=> 'The requested topic does not exist.',
	'NO_TOPIC_FORUM'			=> 'The topic or forum no longer exists.',
	'NO_TOPICS'					=> 'There are no topics or posts in this forum.',
	'NO_TOPICS_TIME_FRAME'		=> 'No topics exist inside this forum for the selected time frame.',
	'NO_UNREAD_PM'				=> '<strong>0</strong> unread messages',
	'NO_UPLOAD_FORM_FOUND'		=> 'Upload initiated but no valid file upload form found.',
	'NO_USER'					=> 'The requested user does not exist.',
	'NO_USERS'					=> 'The requested users do not exist.',
	'NO_USER_SPECIFIED'			=> 'No username was specified.',

	// Nullar/Singular/Plural language entry. The key numbers define the number range in which a certain grammatical expression is valid.
	'NUM_POSTS_IN_QUEUE'		=> array(
		0			=> 'No posts in queue',		// 0
		1			=> '1 post in queue',		// 1
		2			=> '%d posts in queue',		// 2+
	),

	'OCCUPATION'				=> 'อาชีพ',
	'OFFLINE'					=> 'Offline',
	'ONLINE'					=> 'Online',
	'ONLINE_BUDDIES'			=> 'Online friends',
	'ONLINE_USERS_TOTAL'		=> 'ผู้ที่ online ทั้งหมด <strong>%d</strong> คน :: ',
	'ONLINE_USERS_ZERO_TOTAL'	=> 'ผู้ที่ online ทั้งหมด <strong>0</strong> คน :: ',
	'ONLINE_USER_TOTAL'			=> 'ผู้ที่ online ทั้งหมด <strong>%d</strong> คน :: ',
	'OPTIONS'					=> 'ตัวเลือก',

	'PAGE_OF'				=> 'หน้า <strong>%1$d</strong> จาก <strong>%2$d</strong>',
	'PASSWORD'				=> 'Password',
	'PLAY_QUICKTIME_FILE'	=> 'Play Quicktime file',
	'PM'					=> 'PM',
	'POSTING_MESSAGE'		=> 'Posting message in %s',
	'POSTING_PRIVATE_MESSAGE'	=> 'Composing private message',
	'POST'					=> 'Post',
	'POST_ANNOUNCEMENT'		=> 'Announce',
	'POST_STICKY'			=> 'Sticky',
	'POSTED'				=> 'Posted',
	'POSTED_IN_FORUM'		=> 'in',
	'POSTED_ON_DATE'		=> 'เมื่อ',
	'POSTS'					=> 'ตอบ',
	'POSTS_UNAPPROVED'		=> 'At least one post in this topic has not been approved.',
	'POST_BY_AUTHOR'		=> 'โดย',
	'POST_BY_FOE'			=> 'This post was made by <strong>%1$s</strong> who is currently on your ignore list. %2$sDisplay this post%3$s.',
	'POST_DAY'				=> '%.2f ข้อความต่อวัน',
	'POST_DETAILS'			=> 'Post details',
	'POST_NEW_TOPIC'		=> 'Post new topic',
	'POST_PCT'				=> '%.2f%% ของข้อความทั้งหมด',
	'POST_PCT_ACTIVE'		=> '%.2f%% of user’s posts',
	'POST_PCT_ACTIVE_OWN'	=> '%.2f%% ของข้อความที่คุณโพสต์',
	'POST_REPLY'			=> 'ตอบกลับ',
	'POST_REPORTED'			=> 'Click to view report',
	'POST_SUBJECT'			=> 'Post subject',
	'POST_TIME'				=> 'เวลาที่โพสต์',
	'POST_TOPIC'			=> 'สร้างหัวข้อใหม่',
	'POST_UNAPPROVED'		=> 'This post is waiting for approval',
	'PREVIEW'				=> 'แสดงตัวอย่าง',
	'PREVIOUS'				=> 'Previous',		// Used in pagination
	'PREVIOUS_STEP'			=> 'Previous',
	'PRIVACY'				=> 'นโยบายการปกป้องข้อมูลส่วนตัว',
	'PRIVATE_MESSAGE'		=> 'ข้อความส่วนตัว',
	'PRIVATE_MESSAGES'		=> 'ข้อความส่วนตัว',
	'PRIVATE_MESSAGING'		=> 'Private messaging',
	'PROFILE'				=> 'แก้ไขข้อมูลส่วนตัว',

	'READING_FORUM'				=> 'Viewing topics in %s',
	'READING_GLOBAL_ANNOUNCE'	=> 'Reading global announcement',
	'READING_LINK'				=> 'Following forum link %s',
	'READING_TOPIC'				=> 'Reading topic in %s',
	'READ_PROFILE'				=> 'Profile',
	'REASON'					=> 'Reason',
	'RECORD_ONLINE_USERS'		=> 'มีผู้ใช้ online พร้อมกันสูงสุด  <strong>%1$s</strong> คน เมื่อ %2$s',
	'REDIRECT'					=> 'Redirect',
	'REDIRECTS'					=> 'Total redirects',
	'REGISTER'					=> 'สมัครสมาชิก(Register)',
	'REGISTERED_USERS'			=> 'สมาชิกทั้งหมด:',
	'REG_USERS_ONLINE'			=> 'There are %d registered users and ',
	'REG_USERS_TOTAL'			=> 'ลงทะเบียน %d คน, ',
	'REG_USERS_TOTAL_AND'		=> 'ลงทะเบียน %d คน และ ',
	'REG_USERS_ZERO_ONLINE'		=> 'There are 0 registered users and ',
	'REG_USERS_ZERO_TOTAL'		=> 'ไม่มีผู้ใช้งานที่ลงทะเบียน, ',
	'REG_USERS_ZERO_TOTAL_AND'	=> 'ไม่มีผู้ใช้งานที่ลงทะเบียน และ ',
	'REG_USER_ONLINE'			=> 'There is %d registered user and ',
	'REG_USER_TOTAL'			=> 'ลงทะเบียน %d คน, ',
	'REG_USER_TOTAL_AND'		=> 'ลงทะเบียน %d คน และ ',
	'REMOVE'					=> 'Remove',
	'REMOVE_INSTALL'			=> 'Please delete, move or rename the install directory before you use your board. If this directory is still present, only the Administration Control Panel (ACP) will be accessible.',
	'REPLIES'					=> 'ตอบ',
	'REPLY_WITH_QUOTE'			=> 'Reply with quote',
	'REPLYING_GLOBAL_ANNOUNCE'	=> 'Replying to global announcement',
	'REPLYING_MESSAGE'			=> 'Replying to message in %s',
	'REPORT_BY'					=> 'Report by',
	'REPORT_POST'				=> 'Report this post',
	'REPORTING_POST'			=> 'Reporting post',
	'RESEND_ACTIVATION'			=> 'Resend activation e-mail',
	'RESET'						=> 'ล้างแบบฟอร์ม',
	'RESTORE_PERMISSIONS'		=> 'Restore permissions',
	'RETURN_INDEX'				=> '%sกลับไปหน้า Index%s',
	'RETURN_FORUM'				=> '%sReturn to the forum last visited%s',
	'RETURN_PAGE'				=> '%sReturn to the previous page%s',
	'RETURN_TOPIC'				=> '%sReturn to the topic last visited%s',
	'RETURN_TO'					=> 'กลับไปหน้า',
	'RULES_ATTACH_CAN'			=> 'You <strong>can</strong> post attachments in this forum',
	'RULES_ATTACH_CANNOT'		=> 'You <strong>cannot</strong> post attachments in this forum',
	'RULES_DELETE_CAN'			=> 'You <strong>can</strong> delete your posts in this forum',
	'RULES_DELETE_CANNOT'		=> 'You <strong>cannot</strong> delete your posts in this forum',
	'RULES_DOWNLOAD_CAN'		=> 'You <strong>can</strong> download attachments in this forum',
	'RULES_DOWNLOAD_CANNOT'		=> 'You <strong>cannot</strong> download attachments in this forum',
	'RULES_EDIT_CAN'			=> 'You <strong>can</strong> edit your posts in this forum',
	'RULES_EDIT_CANNOT'			=> 'You <strong>cannot</strong> edit your posts in this forum',
	'RULES_LOCK_CAN'			=> 'You <strong>can</strong> lock your topics in this forum',
	'RULES_LOCK_CANNOT'			=> 'You <strong>cannot</strong> lock your topics in this forum',
	'RULES_POST_CAN'			=> 'You <strong>can</strong> post new topics in this forum',
	'RULES_POST_CANNOT'			=> 'You <strong>cannot</strong> post new topics in this forum',
	'RULES_REPLY_CAN'			=> 'You <strong>can</strong> reply to topics in this forum',
	'RULES_REPLY_CANNOT'		=> 'You <strong>cannot</strong> reply to topics in this forum',
	'RULES_VOTE_CAN'			=> 'You <strong>can</strong> vote in polls in this forum',
	'RULES_VOTE_CANNOT'			=> 'You <strong>cannot</strong> vote in polls in this forum',

	'SEARCH'					=> 'ค้นหา',
	'SEARCH_MINI'				=> 'ข้อความที่จะค้นหา…',
	'SEARCH_ADV'				=> 'ค้นหาแบบชั้นสูง',
	'SEARCH_ADV_EXPLAIN'		=> 'View the advanced search options',
	'SEARCH_KEYWORDS'			=> 'Search for keywords',
	'SEARCHING_FORUMS'			=> 'Searching forums',
	'SEARCH_ACTIVE_TOPICS'		=> 'View active topics',
	'SEARCH_FOR'				=> 'Search for',
	'SEARCH_FORUM'				=> 'ค้นหาใน forum นี้…',	
	'SEARCH_NEW'				=> 'ดูข้อความที่ยังไม่ได้อ่าน',
	'SEARCH_POSTS_BY'			=> 'Search posts by',
	'SEARCH_SELF'				=> 'ดูข้อความที่คุณโพสต์',
	'SEARCH_TOPIC'				=> 'ค้นหาในหัวข้อนี้…',
	'SEARCH_UNANSWERED'			=> 'ดูข้อความที่ยังไม่ได้ตอบ',
	'SECONDS'					=> 'Seconds',
	'SELECT'					=> 'Select',
	'SELECT_ALL_CODE'			=> 'เลือกทั้งหมด',
	'SELECT_DESTINATION_FORUM'	=> 'Please select a destination forum',
	'SELECT_FORUM'				=> 'เลือก forum ',
	'SEND_EMAIL'				=> 'E-mail',            // Used for submit buttons
	'SEND_EMAIL_USER'			=> 'E-mail',				// Used as: {L_SEND_EMAIL_USER} {USERNAME} -> E-mail UserX
	'SEND_PRIVATE_MESSAGE'		=> 'ส่งข้อความส่วนตัว',
	'SETTINGS'					=> 'Settings',
	'SIGNATURE'					=> 'ลายเซ็น',
	'SKIP'						=> 'Skip to content',
	'SMTP_NO_AUTH_SUPPORT'		=> 'SMTP server does not support authentication.',
	'SORRY_AUTH_READ'			=> 'You are not authorised to read this forum.',
	'SORRY_AUTH_VIEW_ATTACH'	=> 'You are not authorised to download this attachment.',
	'SORT_BY'					=> 'เรียงลำดับตาม',
	'SORT_JOINED'				=> 'สมัครสมาชิก',
	'SORT_LOCATION'				=> 'ที่อยู่',
	'SORT_RANK'					=> 'Rank',
	'SORT_TOPIC_TITLE'			=> 'Topic title',
	'SORT_USERNAME'				=> 'Username',
	'SPLIT_TOPIC'				=> 'Split topic',
	'SQL_ERROR_OCCURRED'		=> 'An SQL error occurred while fetching this page. Please contact the %sBoard Administrator%s if this problem persists.',
	'STATISTICS'				=> 'สถิติ',
	'START_WATCHING_FORUM'		=> 'Subscribe forum',
	'START_WATCHING_TOPIC'		=> 'Subscribe topic',
	'STOP_WATCHING_FORUM'		=> 'Unsubscribe forum',
	'STOP_WATCHING_TOPIC'		=> 'Unsubscribe topic',
	'SUBFORUM'					=> 'Subforum',
	'SUBFORUMS'					=> 'Subforums',
	'SUBJECT'					=> 'หัวข้อ',
	'SUBMIT'					=> 'ส่ง(Submit)',

	'TERMS_USE'			=> 'เงื่อนไขการใช้งาน',
	'TEST_CONNECTION'	=> 'Test connection',
	'THE_TEAM'			=> 'รายชื่อทีมผู้ดูแล',
	'TIME'				=> 'Time',

	'TOO_LONG'						=> 'The value you entered is too long.',

	'TOO_LONG_AIM'					=> 'The screenname you entered is too long.',
	'TOO_LONG_CONFIRM_CODE'			=> 'The confirm code you entered is too long.',
	'TOO_LONG_DATEFORMAT'			=> 'The date format you entered is too long.',
	'TOO_LONG_ICQ'					=> 'The ICQ number you entered is too long.',
	'TOO_LONG_INTERESTS'			=> 'The interests you entered is too long.',
	'TOO_LONG_JABBER'				=> 'The Jabber account name you entered is too long.',
	'TOO_LONG_LOCATION'				=> 'The location you entered is too long.',
	'TOO_LONG_MSN'					=> 'The MSNM/WLM name you entered is too long.',
	'TOO_LONG_NEW_PASSWORD'			=> 'The password you entered is too long.',
	'TOO_LONG_OCCUPATION'			=> 'The occupation you entered is too long.',
	'TOO_LONG_PASSWORD_CONFIRM'		=> 'The password confirmation you entered is too long.',
	'TOO_LONG_USER_PASSWORD'		=> 'The password you entered is too long.',
	'TOO_LONG_USERNAME'				=> 'The username you entered is too long.',
	'TOO_LONG_EMAIL'				=> 'The e-mail address you entered is too long.',
	'TOO_LONG_EMAIL_CONFIRM'		=> 'The e-mail address confirmation you entered is too long.',
	'TOO_LONG_WEBSITE'				=> 'The website address you entered is too long.',
	'TOO_LONG_YIM'					=> 'The Yahoo! Messenger name you entered is too long.',

	'TOO_MANY_VOTE_OPTIONS'			=> 'You have tried to vote for too many options.',

	'TOO_SHORT'						=> 'The value you entered is too short.',

	'TOO_SHORT_AIM'					=> 'The screenname you entered is too short.',
	'TOO_SHORT_CONFIRM_CODE'		=> 'The confirm code you entered is too short.',
	'TOO_SHORT_DATEFORMAT'			=> 'The date format you entered is too short.',
	'TOO_SHORT_ICQ'					=> 'The ICQ number you entered is too short.',
	'TOO_SHORT_INTERESTS'			=> 'The interests you entered is too short.',
	'TOO_SHORT_JABBER'				=> 'The Jabber account name you entered is too short.',
	'TOO_SHORT_LOCATION'			=> 'The location you entered is too short.',
	'TOO_SHORT_MSN'					=> 'The MSNM/WLM name you entered is too short.',
	'TOO_SHORT_NEW_PASSWORD'		=> 'The password you entered is too short.',
	'TOO_SHORT_OCCUPATION'			=> 'The occupation you entered is too short.',
	'TOO_SHORT_PASSWORD_CONFIRM'	=> 'The password confirmation you entered is too short.',
	'TOO_SHORT_USER_PASSWORD'		=> 'The password you entered is too short.',
	'TOO_SHORT_USERNAME'			=> 'The username you entered is too short.',
	'TOO_SHORT_EMAIL'				=> 'The e-mail address you entered is too short.',
	'TOO_SHORT_EMAIL_CONFIRM'		=> 'The e-mail address confirmation you entered is too short.',
	'TOO_SHORT_WEBSITE'				=> 'The website address you entered is too short.',
	'TOO_SHORT_YIM'					=> 'The Yahoo! Messenger name you entered is too short.',

	'TOPIC'				=> 'หัวข้อ',
	'TOPICS'			=> 'หัวข้อ',
	'TOPIC_ICON'		=> 'Topic icon',
	'TOPIC_LOCKED'		=> 'This topic is locked, you cannot edit posts or make further replies.',
	'TOPIC_LOCKED_SHORT'=> 'หัวข้อถูกล็อก',
	'TOPIC_MOVED'		=> 'Moved topic',
	'TOPIC_REVIEW'		=> 'Topic review',
	'TOPIC_TITLE'		=> 'Topic title',
	'TOPIC_UNAPPROVED'	=> 'This topic has not been approved',
	'TOTAL_ATTACHMENTS'	=> 'Attachment(s)',
	'TOTAL_LOG'			=> '1 log',
	'TOTAL_LOGS'		=> '%d logs',
	'TOTAL_NO_PM'		=> 'ข้อความส่วนตัวทั้งหมด 0 ข้อความ',
	'TOTAL_PM'			=> 'ข้อความส่วนตัวทั้งหมด 1 ข้อความ',
	'TOTAL_PMS'			=> 'ข้อความส่วนตัวทั้งหมด %d ข้อความ',
	'TOTAL_POSTS'		=> 'โพสต์ทั้งหมด',
	'TOTAL_POSTS_OTHER'	=> 'โพสต์ทั้งหมด <strong>%d</strong> ข้อความ',
	'TOTAL_POSTS_ZERO'	=> 'โพสต์ทั้งหมด <strong>0</strong> ข้อความ',
	'TOPIC_REPORTED'	=> 'This topic has been reported',
	'TOTAL_TOPICS_OTHER'=> 'หัวข้อทั้งหมด <strong>%d</strong> หัวข้อ',
	'TOTAL_TOPICS_ZERO'	=> 'ไม่มีหัวข้อ',
	'TOTAL_USERS_OTHER'	=> 'สมาชิกทั้งหมด <strong>%d</strong> คน',
	'TOTAL_USERS_ZERO'	=> 'ยังไม่มีสมาชิก',
	'TRACKED_PHP_ERROR'	=> 'Tracked PHP errors: %s',

	'UNABLE_GET_IMAGE_SIZE'	=> 'It was not possible to determine the dimensions of the image.',
	'UNABLE_TO_DELIVER_FILE'=> 'Unable to deliver file.',
	'UNKNOWN_BROWSER'		=> 'Unknown browser',
	'UNMARK_ALL'			=> 'Unmark all',
	'UNREAD_MESSAGES'		=> 'Unread messages',
	'UNREAD_PM'				=> '<strong>%d</strong> unread message',
	'UNREAD_PMS'			=> '<strong>%d</strong> unread messages',
	'UNWATCHED_FORUMS'			=> 'You are no longer subscribed to the selected forums.',
	'UNWATCHED_TOPICS'			=> 'You are no longer subscribed to the selected topics.',
	'UNWATCHED_FORUMS_TOPICS'	=> 'You are no longer subscribed to the selected entries.',
	'UPDATE'				=> 'Update',
	'UPLOAD_IN_PROGRESS'	=> 'The upload is currently in progress.',
	'URL_REDIRECT'			=> 'If your browser does not support meta redirection %splease click HERE to be redirected%s.',
	'USERGROUPS'			=> 'Groups',
	'USERNAME'				=> 'Username',
	'USERNAMES'				=> 'Usernames',
	'USER_AVATAR'			=> 'User avatar',
	'USER_CANNOT_READ'		=> 'You cannot read posts in this forum.',
	'USER_POST'				=> '%d ข้อความ',
	'USER_POSTS'			=> '%d ข้อความ',
	'USERS'					=> 'Users',
	'USE_PERMISSIONS'		=> 'Test out user’s permissions',

	'VARIANT_DATE_SEPARATOR'	=> ' / ',	// Used in date format dropdown, eg: "Today, 13:37 / 01 Jan 2007, 13:37" ... to join a relative date with calendar date
	'VIEWED'					=> 'Viewed',
	'VIEWING_FAQ'				=> 'Viewing FAQ',
	'VIEWING_MEMBERS'			=> 'Viewing member details',
	'VIEWING_ONLINE'			=> 'Viewing who is online',
	'VIEWING_MCP'				=> 'Viewing moderator control panel',
	'VIEWING_MEMBER_PROFILE'	=> 'Viewing member profile',
	'VIEWING_PRIVATE_MESSAGES'	=> 'Viewing private messages',
	'VIEWING_REGISTER'			=> 'Registering account',
	'VIEWING_UCP'				=> 'กำลังแก้ไขข้อมูลส่วนตัว',
	'VIEWS'						=> 'อ่าน',
	'VIEW_BOOKMARKS'			=> 'View bookmarks',
	'VIEW_FORUM_LOGS'			=> 'View Logs',
	'VIEW_LATEST_POST'			=> 'ดูข้อความล่าสุด',
	'VIEW_NEWEST_POST'			=> 'View first unread post',
	'VIEW_NOTES'				=> 'View user notes',
	'VIEW_ONLINE_TIME'			=> 'นับเฉพาะสมาชิกที่ล็อกอินนานกว่า %d นาทีขึ้นไป',
	'VIEW_ONLINE_TIMES'			=> 'นับเฉพาะสมาชิกที่ล็อกอินนานกว่า %d นาทีขึ้นไป',
	'VIEW_TOPIC'				=> 'View topic',
	'VIEW_TOPIC_ANNOUNCEMENT'	=> 'Announcement: ',
	'VIEW_TOPIC_GLOBAL'			=> 'Global Announcement: ',
	'VIEW_TOPIC_LOCKED'			=> 'Locked: ',
	'VIEW_TOPIC_LOGS'			=> 'View logs',
	'VIEW_TOPIC_MOVED'			=> 'Moved: ',
	'VIEW_TOPIC_POLL'			=> 'Poll: ',
	'VIEW_TOPIC_STICKY'			=> 'Sticky: ',
	'VISIT_WEBSITE'				=> 'Visit website',

	'WARNINGS'			=> 'Warnings',
	'WARN_USER'			=> 'Warn user',
	'WELCOME_SUBJECT'	=> 'Welcome to %s forums',
	'WEBSITE'			=> 'เว็บไซต์',
	'WHOIS'				=> 'Whois',
	'WHO_IS_ONLINE'		=> 'ผู้ที่กำลัง online',
	'WRONG_PASSWORD'	=> 'You entered an incorrect password.',

	'WRONG_DATA_ICQ'			=> 'The number you entered is not a valid ICQ number.',
	'WRONG_DATA_JABBER'			=> 'The name you entered is not a valid Jabber account name.',
	'WRONG_DATA_LANG'			=> 'The language you specified is not valid.',
	'WRONG_DATA_WEBSITE'		=> 'The website address has to be a valid URL, including the protocol. For example http://www.example.com/.',
	'WROTE'						=> 'wrote',

	'YEAR'				=> 'ปี',
	'YEAR_MONTH_DAY'	=> '(YYYY-MM-DD)',
	'YES'				=> 'ใช่',
	'YIM'				=> 'YIM',	
	'YOU_LAST_VISIT'	=> 'เข้าสู่ระบบล่าสุด: %s',
	'YOU_NEW_PM'		=> 'มีข้อความส่วนตัวที่ยังไม่ได้อ่าน',
	'YOU_NEW_PMS'		=> 'มีข้อความส่วนตัวที่ยังไม่ได้อ่าน',
	'YOU_NO_NEW_PM'		=> 'ไม่มีข้อความส่วนตัวที่ยังไม่ได้อ่าน',

	'datetime'			=> array(
		'TODAY'		=> 'วันนี้',
		'TOMORROW'	=> 'พรุ่งีน้',
		'YESTERDAY'	=> 'เมื่อวาน',
		'AGO'		=> array(
			0		=> 'ไม่เกินนาทีที่แล้ว',
			1		=> '%d นาทีที่แล้ว',
			2		=> '%d นาทีที่แล้ว',
			60		=> '1 ชั่วโมงที่แล้ว',
		),

		'Sunday'	=> 'Sunday',
		'Monday'	=> 'Monday',
		'Tuesday'	=> 'Tuesday',
		'Wednesday'	=> 'Wednesday',
		'Thursday'	=> 'Thursday',
		'Friday'	=> 'Friday',
		'Saturday'	=> 'Saturday',

		'Sun'		=> 'Sun',
		'Mon'		=> 'Mon',
		'Tue'		=> 'Tue',
		'Wed'		=> 'Wed',
		'Thu'		=> 'Thu',
		'Fri'		=> 'Fri',
		'Sat'		=> 'Sat',

		'January'	=> 'January',
		'February'	=> 'February',
		'March'		=> 'March',
		'April'		=> 'April',
		'May'		=> 'May',
		'June'		=> 'June',
		'July'		=> 'July',
		'August'	=> 'August',
		'September' => 'September',
		'October'	=> 'October',
		'November'	=> 'November',
		'December'	=> 'December',

		'Jan'		=> 'Jan',
		'Feb'		=> 'Feb',
		'Mar'		=> 'Mar',
		'Apr'		=> 'Apr',
		'May_short'	=> 'May',	// Short representation of "May". May_short used because in English the short and long date are the same for May.
		'Jun'		=> 'Jun',
		'Jul'		=> 'Jul',
		'Aug'		=> 'Aug',
		'Sep'		=> 'Sep',
		'Oct'		=> 'Oct',
		'Nov'		=> 'Nov',
		'Dec'		=> 'Dec',
	),

	'tz'				=> array(
		'-12'	=> 'UTC - 12 ชั่วโมง',
		'-11'	=> 'UTC - 11 ชั่วโมง',
		'-10'	=> 'UTC - 10 ชั่วโมง',
		'-9.5'	=> 'UTC - 9:30 ชั่วโมง',
		'-9'	=> 'UTC - 9 ชั่วโมง',
		'-8'	=> 'UTC - 8 ชั่วโมง',
		'-7'	=> 'UTC - 7 ชั่วโมง',
		'-6'	=> 'UTC - 6 ชั่วโมง',
		'-5'	=> 'UTC - 5 ชั่วโมง',
		'-4.5'	=> 'UTC - 4:30 hours',
		'-4'	=> 'UTC - 4 ชั่วโมง',
		'-3.5'	=> 'UTC - 3:30 ชั่วโมง',
		'-3'	=> 'UTC - 3 ชั่วโมง',
		'-2'	=> 'UTC - 2 ชั่วโมง',
		'-1'	=> 'UTC - 1 ชั่วโมง',
		'0'		=> 'UTC',
		'1'		=> 'UTC + 1 ชั่วโมง',
		'2'		=> 'UTC + 2 ชั่วโมง',
		'3'		=> 'UTC + 3 ชั่วโมง',
		'3.5'	=> 'UTC + 3:30 ชั่วโมง',
		'4'		=> 'UTC + 4 ชั่วโมง',
		'4.5'	=> 'UTC + 4:30 ชั่วโมง',
		'5'		=> 'UTC + 5 ชั่วโมง',
		'5.5'	=> 'UTC + 5:30 ชั่วโมง',
		'5.75'	=> 'UTC + 5:45 ชั่วโมง',
		'6'		=> 'UTC + 6 ชั่วโมง',
		'6.5'	=> 'UTC + 6:30 ชั่วโมง',
		'7'		=> 'UTC + 7 ชั่วโมง',
		'8'		=> 'UTC + 8 ชั่วโมง',
		'8.75'	=> 'UTC + 8:45 ชั่วโมง',
		'9'		=> 'UTC + 9 ชั่วโมง',
		'9.5'	=> 'UTC + 9:30 ชั่วโมง',
		'10'	=> 'UTC + 10 ชั่วโมง',
		'10.5'	=> 'UTC + 10:30 ชั่วโมง',
		'11'	=> 'UTC + 11 ชั่วโมง',
		'11.5'	=> 'UTC + 11:30 ชั่วโมง',
		'12'	=> 'UTC + 12 ชั่วโมง',
		'12.75'	=> 'UTC + 12:45 ชั่วโมง',
		'13'	=> 'UTC + 13 ชั่วโมง',
		'14'	=> 'UTC + 14 ชั่วโมง',
		'dst'	=> '[ <abbr title="Daylight Saving Time">DST</abbr> ]',
	),

	'tz_zones'	=> array(
		'-12'	=> '[UTC - 12] Baker Island Time',
		'-11'	=> '[UTC - 11] Niue Time, Samoa Standard Time',
		'-10'	=> '[UTC - 10] Hawaii-Aleutian Standard Time, Cook Island Time',
		'-9.5'	=> '[UTC - 9:30] Marquesas Islands Time',
		'-9'	=> '[UTC - 9] Alaska Standard Time, Gambier Island Time',
		'-8'	=> '[UTC - 8] Pacific Standard Time',
		'-7'	=> '[UTC - 7] Mountain Standard Time',
		'-6'	=> '[UTC - 6] Central Standard Time',
		'-5'	=> '[UTC - 5] Eastern Standard Time',
		'-4.5'	=> '[UTC - 4:30] Venezuelan Standard Time',
		'-4'	=> '[UTC - 4] Atlantic Standard Time',
		'-3.5'	=> '[UTC - 3:30] Newfoundland Standard Time',
		'-3'	=> '[UTC - 3] Amazon Standard Time, Central Greenland Time',
		'-2'	=> '[UTC - 2] Fernando de Noronha Time, South Georgia &amp; the South Sandwich Islands Time',
		'-1'	=> '[UTC - 1] Azores Standard Time, Cape Verde Time, Eastern Greenland Time',
		'0'		=> '[UTC] Western European Time, Greenwich Mean Time',
		'1'		=> '[UTC + 1] Central European Time, West African Time',
		'2'		=> '[UTC + 2] Eastern European Time, Central African Time',
		'3'		=> '[UTC + 3] Moscow Standard Time, Eastern African Time',
		'3.5'	=> '[UTC + 3:30] Iran Standard Time',
		'4'		=> '[UTC + 4] Gulf Standard Time, Samara Standard Time',
		'4.5'	=> '[UTC + 4:30] Afghanistan Time',
		'5'		=> '[UTC + 5] Pakistan Standard Time, Yekaterinburg Standard Time',
		'5.5'	=> '[UTC + 5:30] Indian Standard Time, Sri Lanka Time',
		'5.75'	=> '[UTC + 5:45] Nepal Time',
		'6'		=> '[UTC + 6] Bangladesh Time, Bhutan Time, Novosibirsk Standard Time',
		'6.5'	=> '[UTC + 6:30] Cocos Islands Time, Myanmar Time',
		'7'		=> '[UTC + 7] Bangkok, Indochina Time, Krasnoyarsk Standard Time',
		'8'		=> '[UTC + 8] Chinese Standard Time, Australian Western Standard Time, Irkutsk Standard Time',
		'8.75'	=> '[UTC + 8:45] Southeastern Western Australia Standard Time',
		'9'		=> '[UTC + 9] Japan Standard Time, Korea Standard Time, Chita Standard Time',
		'9.5'	=> '[UTC + 9:30] Australian Central Standard Time',
		'10'	=> '[UTC + 10] Australian Eastern Standard Time, Vladivostok Standard Time',
		'10.5'	=> '[UTC + 10:30] Lord Howe Standard Time',
		'11'	=> '[UTC + 11] Solomon Island Time, Magadan Standard Time',
		'11.5'	=> '[UTC + 11:30] Norfolk Island Time',
		'12'	=> '[UTC + 12] New Zealand Time, Fiji Time, Kamchatka Standard Time',
		'12.75'	=> '[UTC + 12:45] Chatham Islands Time',
		'13'	=> '[UTC + 13] Tonga Time, Phoenix Islands Time',
		'14'	=> '[UTC + 14] Line Island Time',
	),

	// The value is only an example and will get replaced by the current time on view
	'dateformats'	=> array(
		'd M Y, H:i'			=> '01 Jan 2007, 13:37',
		'd M Y H:i'				=> '01 Jan 2007 13:37',
		'M jS, \'y, H:i'		=> 'Jan 1st, \'07, 13:37',
		'D M d, Y g:i a'		=> 'Mon Jan 01, 2007 1:37 pm',
		'F jS, Y, g:i a'		=> 'January 1st, 2007, 1:37 pm',
		'|d M Y|, H:i'			=> 'Today, 13:37 / 01 Jan 2007, 13:37',
		'|F jS, Y|, g:i a'		=> 'Today, 1:37 pm / January 1st, 2007, 1:37 pm'
	),

	// The default dateformat which will be used on new installs in this language
	// Translators should change this if a the usual date format is different
	'default_dateformat'	=> 'D M d, Y g:i a', // Mon Jan 01, 2007 1:37 pm

));

?>