/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2000, 2010 Oracle and/or its affiliates.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

// autogenerated file with codegen.pl

#include "cppunit/TestAssert.h"
#include "cppunit/TestFixture.h"
#include "cppunit/extensions/HelperMacros.h"

#include <basegfx/vector/b2isize.hxx>
#include <basegfx/range/b2irange.hxx>
#include <basegfx/point/b2ipoint.hxx>
#include <basegfx/matrix/b2dhommatrix.hxx>
#include <basegfx/polygon/b2dpolygon.hxx>
#include <basegfx/polygon/b2dpolygontools.hxx>
#include <basegfx/polygon/b2dpolypolygon.hxx>
#include <basegfx/polygon/b2dpolypolygontools.hxx>

#include <basebmp/color.hxx>
#include <basebmp/scanlineformats.hxx>
#include <basebmp/bitmapdevice.hxx>
#include "tools.hxx"

using namespace ::basebmp;

namespace
{
class PolyTest : public CppUnit::TestFixture
{
private:
    BitmapDeviceSharedPtr mpDevice1bpp;
    BitmapDeviceSharedPtr mpDevice32bpp;

    void implTestEmpty(const BitmapDeviceSharedPtr& rDevice)
    {
        const Color aCol(0xFFFFFFFF);
        const Color aBgCol(0);
        rDevice->clear(aBgCol);
        basegfx::B2DPolyPolygon aPoly;
        ::rtl::OUString aSvg;

        basegfx::tools::importFromSvgD(
            aPoly,
            rtl::OUString(RTL_CONSTASCII_USTRINGPARAM(
                "M2 2 l7 7 z" )) );
        rDevice->fillPolyPolygon(
            aPoly,
            aCol,
            DrawMode_PAINT );
        CPPUNIT_ASSERT_MESSAGE("number of rendered pixel is not 0",
                               countPixel( rDevice, aCol ) == 0);

        // --------------------------------------------------

        rDevice->clear(aBgCol);
        aPoly.clear();
        basegfx::tools::importFromSvgD(
            aPoly,
            rtl::OUString(RTL_CONSTASCII_USTRINGPARAM(
            "M7 2 l-6 6 z" )) );
        rDevice->fillPolyPolygon(
            aPoly,
            aCol,
            DrawMode_PAINT );
        CPPUNIT_ASSERT_MESSAGE("number of rendered pixel is not 0(b)",
                               countPixel( rDevice, aCol ) == 0);
    }

    void implTestHairline(const BitmapDeviceSharedPtr& rDevice)
    {
        const Color aCol(0xFFFFFFFF);
        const Color aBgCol(0);
        rDevice->clear(aBgCol);
        basegfx::B2DPolyPolygon aPoly;
        ::rtl::OUString aSvg;

        basegfx::tools::importFromSvgD(
            aPoly,
            rtl::OUString(RTL_CONSTASCII_USTRINGPARAM(
                "M2 2 h1 l7 7 h-1 z" )) );
        rDevice->fillPolyPolygon(
            aPoly,
            aCol,
            DrawMode_PAINT );
        CPPUNIT_ASSERT_MESSAGE("number of rendered pixel is not 7",
                               countPixel( rDevice, aCol ) == 7);

        // --------------------------------------------------

        rDevice->clear(aBgCol);
        aPoly.clear();
        basegfx::tools::importFromSvgD(
            aPoly,
            rtl::OUString(RTL_CONSTASCII_USTRINGPARAM(
            "M7 2 h-1 l-6 6 h1 z" )) );
        rDevice->fillPolyPolygon(
            aPoly,
            aCol,
            DrawMode_PAINT );
        CPPUNIT_ASSERT_MESSAGE("number of rendered pixel is not 6",
                               countPixel( rDevice, aCol ) == 6);

        // --------------------------------------------------

        rDevice->clear(aBgCol);
        aPoly.clear();
        basegfx::tools::importFromSvgD(
            aPoly,
            rtl::OUString(RTL_CONSTASCII_USTRINGPARAM(
            "M0 0 l7 7 h-1 l-5-7 z" )) );
        rDevice->fillPolyPolygon(
            aPoly,
            aCol,
            DrawMode_PAINT );
        CPPUNIT_ASSERT_MESSAGE("number of rendered pixel is not 3",
                               countPixel( rDevice, aCol ) == 3);
    }

    void implTestPolyPoly(const BitmapDeviceSharedPtr& rDevice)
    {
        const Color aCol(0xFFFFFFFF);
        const Color aBgCol(0);
        rDevice->clear(aBgCol);
        basegfx::B2DPolyPolygon aPoly;
        ::rtl::OUString aSvg;

        basegfx::tools::importFromSvgD( aPoly,
                                        ::rtl::OUString(RTL_CONSTASCII_USTRINGPARAM(
                                            "M0 0 h7 v7 h-7 z M2 2 v3 h3 v-3 z" )) );

        rDevice->fillPolyPolygon(
            aPoly,
            aCol,
            DrawMode_PAINT );
        CPPUNIT_ASSERT_MESSAGE("number of rendered pixel is not 40",
                               countPixel( rDevice, aCol ) == 40);
    }

    void implTestPolyPolyClip(const BitmapDeviceSharedPtr& rDevice)
    {
        const Color aCol(0xFFFFFFFF);
        const Color aBgCol(0);
        rDevice->clear(aBgCol);
        basegfx::B2DPolyPolygon aPoly;
        ::rtl::OUString aSvg;

        basegfx::tools::importFromSvgD( aPoly,
                                        ::rtl::OUString(RTL_CONSTASCII_USTRINGPARAM(
                                            "M0 0 h7 v7 h-7 z M2 2 v3 h3 v-3 z" )) );
        basegfx::B2DHomMatrix aMat;
        aMat.translate(-3,-3);
        aMat.rotate( 1.7 );
        aMat.translate(6,5);
        aPoly.transform(aMat);

        rDevice->fillPolyPolygon(
            aPoly,
            aCol,
            DrawMode_PAINT );

        CPPUNIT_ASSERT_MESSAGE("number of rendered pixel is not 39",
                               countPixel( rDevice, aCol ) == 39);

        BitmapDeviceSharedPtr pClippedDevice(
            subsetBitmapDevice( rDevice,
                                basegfx::B2IRange(3,3,5,8) ));

        rDevice->clear(aBgCol);
        pClippedDevice->fillPolyPolygon(
            aPoly,
            aCol,
            DrawMode_PAINT );
        CPPUNIT_ASSERT_MESSAGE("number of rendered pixel is not 7",
                               countPixel( rDevice, aCol ) == 7);
    }

    void implTestPolyPolyCrissCross(const BitmapDeviceSharedPtr& rDevice)
    {
        const Color aCol(0xFFFFFFFF);
        const Color aBgCol(0);
        rDevice->clear(aBgCol);
        basegfx::B2DPolyPolygon aPoly;
        ::rtl::OUString aSvg;

        basegfx::tools::importFromSvgD( aPoly,
                                        ::rtl::OUString(RTL_CONSTASCII_USTRINGPARAM(
                                            "M0 0 v2 l10 2 v-2 z"
                                            "M10 6 v-2 l-10 2 v2 z"
                                            "M1 0 h1 v10 h-1 z"
                                            "M4 0 h1 v10 h-1 z"
                                            "M8 0 h1 v10 h-1 z" )) );
        rDevice->fillPolyPolygon(
            aPoly,
            aCol,
            DrawMode_PAINT );
        CPPUNIT_ASSERT_MESSAGE("number of rendered pixel is not 46",
                               countPixel( rDevice, aCol ) == 46);
    }


public:
    void setUp()
    {
        const basegfx::B2ISize aSize(10,10);
        mpDevice1bpp = createBitmapDevice( aSize,
                                           true,
                                           Format::ONE_BIT_MSB_PAL );
        mpDevice32bpp = createBitmapDevice( aSize,
                                            true,
                                            Format::THIRTYTWO_BIT_TC_MASK );
    }

    void testEmpty()
    {
        implTestEmpty( mpDevice1bpp );
        implTestEmpty( mpDevice32bpp );
    }

    void testHairline()
    {
        implTestHairline( mpDevice1bpp );
        implTestHairline( mpDevice32bpp );
    }

    void testPolyPoly()
    {
        implTestPolyPoly( mpDevice1bpp );
        implTestPolyPoly( mpDevice32bpp );
    }

    void testPolyPolyClip()
    {
        implTestPolyPolyClip(mpDevice1bpp);
        implTestPolyPolyClip(mpDevice32bpp);
    }

    void testPolyPolyCrissCross()
    {
        implTestPolyPolyCrissCross(mpDevice1bpp);
        implTestPolyPolyCrissCross(mpDevice32bpp);
    }

    // Change the following lines only, if you add, remove or rename
    // member functions of the current class,
    // because these macros are need by auto register mechanism.

    CPPUNIT_TEST_SUITE(PolyTest);
    CPPUNIT_TEST(testEmpty);
    CPPUNIT_TEST(testHairline);
    CPPUNIT_TEST(testPolyPoly);
    CPPUNIT_TEST(testPolyPolyClip);
    CPPUNIT_TEST(testPolyPolyCrissCross);
    CPPUNIT_TEST_SUITE_END();
};

CPPUNIT_TEST_SUITE_REGISTRATION(PolyTest);
}

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
