/*
 * Decompiled with CFR 0.152.
 */
package jalview.appletgui;

import jalview.appletgui.AlignmentPanel;
import jalview.appletgui.PaintRefresher;
import jalview.appletgui.SliderPanel;
import jalview.bin.JalviewLite;
import jalview.commands.CommandI;
import jalview.commands.EditCommand;
import jalview.datamodel.SequenceGroup;
import jalview.datamodel.SequenceI;
import jalview.util.Comparison;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Stack;
import java.util.Vector;

public class RedundancyPanel
extends SliderPanel
implements Runnable,
WindowListener {
    AlignmentPanel ap;
    Stack historyList = new Stack();
    float[] redundancy;
    SequenceI[] originalSequences;
    Frame frame;
    Vector redundantSeqs = new Vector();

    public RedundancyPanel(AlignmentPanel ap) {
        super(ap, 0, false, null);
        this.ap = ap;
        this.undoButton.setVisible(true);
        this.applyButton.setVisible(true);
        this.allGroupsCheck.setVisible(false);
        this.label.setText("Enter the redundancy threshold");
        this.valueField.setText("100");
        this.slider.setVisibleAmount(1);
        this.slider.setMinimum(0);
        this.slider.setMaximum(100 + this.slider.getVisibleAmount());
        this.slider.setValue(100);
        this.slider.addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent evt) {
                RedundancyPanel.this.valueField.setText(RedundancyPanel.this.slider.getValue() + "");
                RedundancyPanel.this.sliderValueChanged();
            }
        });
        this.frame = new Frame();
        this.frame.add(this);
        JalviewLite.addFrame(this.frame, "Redundancy threshold selection", 400, 100);
        this.frame.addWindowListener(this);
        Thread worker = new Thread(this);
        worker.start();
    }

    public void run() {
        int end;
        int start;
        this.label.setText("Calculating....");
        this.slider.setVisible(false);
        this.applyButton.setEnabled(false);
        this.valueField.setVisible(false);
        this.validate();
        Object omitHidden = null;
        SequenceGroup sg = this.ap.av.getSelectionGroup();
        if (sg != null && sg.getSize() >= 1) {
            this.originalSequences = sg.getSequencesInOrder(this.ap.av.alignment);
            start = sg.getStartRes();
            end = sg.getEndRes();
        } else {
            this.originalSequences = this.ap.av.alignment.getSequencesArray();
            start = 0;
            end = this.ap.av.alignment.getWidth();
        }
        int height = this.originalSequences.length;
        this.redundancy = new float[height];
        for (int i = 0; i < height; ++i) {
            this.redundancy[i] = 0.0f;
        }
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < i; ++j) {
                String seqj;
                String seqi;
                if (i == j) continue;
                if (omitHidden == null) {
                    seqi = this.originalSequences[i].getSequenceAsString(start, end);
                    seqj = this.originalSequences[j].getSequenceAsString(start, end);
                } else {
                    seqi = omitHidden[i];
                    seqj = omitHidden[j];
                }
                float pid = Comparison.PID(seqi, seqj);
                if (seqj.length() < seqi.length()) {
                    this.redundancy[j] = Math.max(pid, this.redundancy[j]);
                    continue;
                }
                this.redundancy[i] = Math.max(pid, this.redundancy[i]);
            }
        }
        this.label.setText("Enter the redundancy threshold");
        this.slider.setVisible(true);
        this.applyButton.setEnabled(true);
        this.valueField.setVisible(true);
        this.validate();
    }

    void sliderValueChanged() {
        if (this.redundancy == null) {
            return;
        }
        float value = this.slider.getValue();
        for (int i = 0; i < this.redundancy.length; ++i) {
            if (value > this.redundancy[i]) {
                this.redundantSeqs.removeElement(this.originalSequences[i]);
                continue;
            }
            if (this.redundantSeqs.contains(this.originalSequences[i])) continue;
            this.redundantSeqs.addElement(this.originalSequences[i]);
        }
        this.ap.idPanel.idCanvas.setHighlighted(this.redundantSeqs);
        PaintRefresher.Refresh(this, this.ap.av.getSequenceSetId(), true, true);
    }

    public void applyButton_actionPerformed() {
        Vector<SequenceI> del = new Vector<SequenceI>();
        this.undoButton.setEnabled(true);
        float value = this.slider.getValue();
        SequenceGroup sg = this.ap.av.getSelectionGroup();
        for (int i = 0; i < this.redundancy.length; ++i) {
            if (!(value <= this.redundancy[i])) continue;
            del.addElement(this.originalSequences[i]);
        }
        if (del.size() > 0) {
            SequenceI[] deleted = new SequenceI[del.size()];
            int width = 0;
            for (int i = 0; i < del.size(); ++i) {
                deleted[i] = (SequenceI)del.elementAt(i);
                if (deleted[i].getLength() <= width) continue;
                width = deleted[i].getLength();
            }
            EditCommand cut = new EditCommand("Remove Redundancy", 2, deleted, 0, width, this.ap.av.alignment);
            for (int i = 0; i < del.size(); ++i) {
                this.ap.av.alignment.deleteSequence(deleted[i]);
                PaintRefresher.Refresh(this, this.ap.av.getSequenceSetId(), true, true);
                if (sg == null) continue;
                sg.deleteSequence(deleted[i], false);
            }
            this.historyList.push(cut);
            this.ap.alignFrame.addHistoryItem(cut);
            this.ap.av.firePropertyChange("alignment", null, this.ap.av.getAlignment().getSequences());
        }
    }

    public void undoButton_actionPerformed() {
        CommandI command = (CommandI)this.historyList.pop();
        command.undoCommand(null);
        if (this.ap.av.historyList.contains(command)) {
            this.ap.av.historyList.removeElement(command);
            this.ap.alignFrame.updateEditMenuBar();
        }
        this.ap.paintAlignment(true);
        if (this.historyList.size() == 0) {
            this.undoButton.setEnabled(false);
        }
    }

    public void valueField_actionPerformed(ActionEvent e) {
        try {
            int i = Integer.parseInt(this.valueField.getText());
            this.slider.setValue(i);
        }
        catch (Exception ex) {
            this.valueField.setText(this.slider.getValue() + "");
        }
    }

    public void windowOpened(WindowEvent evt) {
    }

    public void windowClosing(WindowEvent evt) {
        this.ap.idPanel.idCanvas.setHighlighted(null);
    }

    public void windowClosed(WindowEvent evt) {
    }

    public void windowActivated(WindowEvent evt) {
    }

    public void windowDeactivated(WindowEvent evt) {
    }

    public void windowIconified(WindowEvent evt) {
    }

    public void windowDeiconified(WindowEvent evt) {
    }
}

