--TEST--
Regular Expression type: regex with options (keys reversed)
--DESCRIPTION--
Generated by scripts/convert-bson-corpus-tests.php

DO NOT EDIT THIS FILE
--FILE--
<?php

require_once __DIR__ . '/../utils/basic.inc';

$canonicalBson = hex2bin('0F0000000B610061626300696D0000');
$canonicalExtJson = '{"a" : {"$regularExpression" : { "pattern": "abc", "options" : "im"}}}';
$degenerateExtJson = '{"a" : {"$regularExpression" : {"options" : "im", "pattern": "abc"}}}';

// Canonical BSON -> Native -> Canonical BSON
echo bin2hex(fromPHP(toPHP($canonicalBson))), "\n";

// Canonical BSON -> BSON object -> Canonical BSON
echo bin2hex((string) MongoDB\BSON\Document::fromBSON($canonicalBson)), "\n";

// Canonical BSON -> Canonical extJSON
echo json_canonicalize(toCanonicalExtendedJSON($canonicalBson)), "\n";

// Canonical BSON -> BSON object -> Canonical extJSON
echo json_canonicalize(MongoDB\BSON\Document::fromBSON($canonicalBson)->toCanonicalExtendedJSON()), "\n";

// Canonical extJSON -> Canonical BSON
echo bin2hex(fromJSON($canonicalExtJson)), "\n";

// Canonical extJSON -> BSON object -> Canonical BSON
echo bin2hex((string) MongoDB\BSON\Document::fromJSON($canonicalExtJson)), "\n";

// Degenerate extJSON -> Canonical BSON
echo bin2hex(fromJSON($degenerateExtJson)), "\n";

// Degenerate extJSON -> BSON object -> Canonical BSON
echo bin2hex((string) MongoDB\BSON\Document::fromJSON($degenerateExtJson)), "\n";

?>
===DONE===
<?php exit(0); ?>
--EXPECT--
0f0000000b610061626300696d0000
0f0000000b610061626300696d0000
{"a":{"$regularExpression":{"pattern":"abc","options":"im"}}}
{"a":{"$regularExpression":{"pattern":"abc","options":"im"}}}
0f0000000b610061626300696d0000
0f0000000b610061626300696d0000
0f0000000b610061626300696d0000
0f0000000b610061626300696d0000
===DONE===