.TH XScreenSaver 1 "" "X Version 11"
.SH NAME
hilbert \- 3D Hilbert fractal.
.SH SYNOPSIS
.B hilbert
[\-display \fIhost:display.screen\fP]
[\-visual \fIvisual\fP]
[\-window]
[\-root]
[\-delay \fInumber\fP]
[\-speed \fIratio\fP]
[\-depth \fInumber\fP]
[\-spin]
[\-wander]
[\-2d]
[\-3d]
[\-closed]
[\-open]
[\-max\-depth \fInumber\fP]
[\-thickness \fIratio\fP]
[\-wireframe]
[\-fps]
.SH DESCRIPTION
This draws the recursive Hilbert space-filling curve, in both 2D and
3D variants.  It incrementally animates the growth and recursion to
the maximum depth, then unwinds it back.

The Hilbert path is a single contiguous line that can fill a volume
without crossing itself.  As a data structure, Hilbert paths are
useful because ordering along the curve preserves locality: points
that close together along the curve are also close together in space.
The converse is often, but not always, true.  The coloration
reflects this.
.SH OPTIONS
.TP 8
.B \-visual \fIvisual\fP
Specify which visual to use.  Legal values are the name of a visual class,
or the id number (decimal or hex) of a specific visual.
.TP 8
.B \-window
Draw on a newly-created window.  This is the default.
.TP 8
.B \-root
Draw on the root window.
.TP 8
.B \-delay \fInumber\fP
Per-frame delay, in microseconds.  Default: 30000 (0.03 seconds.).
.TP 8
.B \-speed \fInumber\fP
How fast the animation should run.
Less than 1 for slower, greater than 1 for faster.
.TP 8
.B \-max\-depth \fInumber\fP
Max depth to descend.  Default: 5, which peaks at around half a
million polygons.
.TP 8
.B \-spin
.B \-no\-spin
Whether to rotate the object.  Default: true.
.TP 8
.B \-wander
.B \-no\-wander
Whether to wander the object around on the screen.  Default: false;
.TP 8
.B \-2d
.B \-3d
Whether to draw the 2D or 3D variant. Default: random.
.TP 8
.B \-closed
.B \-open
Whether to draw the open or closed-path variant. Default: random.
.TP 8
.B \-thickness \fIratio\fP
How thick the lines should be.  Default: 0.25.
.TP 8
.B \-wireframe
Render in wireframe instead of solid.
.TP 8
.B \-fps
Display the current frame rate, CPU load, and polygon count.
.SH ENVIRONMENT
.PP
.TP 8
.B DISPLAY
to get the default host and display number.
.TP 8
.B XENVIRONMENT
to get the name of a resource file that overrides the global resources
stored in the RESOURCE_MANAGER property.
.SH SEE ALSO
.BR X (1),
.BR xscreensaver (1)
.SH COPYRIGHT
Copyright \(co 2011 by Jamie Zawinski.  Permission to use, copy,
modify, distribute, and sell this software and its documentation for
any purpose is hereby granted without fee, provided that the above
copyright notice appear in all copies and that both that copyright
notice and this permission notice appear in supporting documentation.
No representations are made about the suitability of this software for
any purpose.  It is provided "as is" without express or implied
warranty.
.SH AUTHOR
Jamie Zawinski.
