[![License](https://img.shields.io/badge/License-GPL%20v2-blue.svg)](https://gitlab.xfce.org/xfce/xfdesktop/-/blob/master/COPYING)

# xfdesktop


Xfdesktop is a desktop manager for the Xfce Desktop Environment. It handles the following tasks:

  * background image / color
  * root menu, window list
  * minimized app icons
  * file icons on the desktop (using Thunar libs)

It can bring up an applications menu and a list of all running applications when you click on the desktop with the right or middle mouse button respectively. Settings are available via the Settings Manager.

----

### Homepage

[Xfdesktop documentation](https://docs.xfce.org/xfce/xfdesktop/start)

### Changelog

See [NEWS](https://gitlab.xfce.org/xfce/xfdesktop/-/blob/master/NEWS) for details on changes and fixes made in the current release.

### Source Code Repository

[Xfdesktop source code](https://gitlab.xfce.org/xfce/xfdesktop)

### Download a Release Tarball

[Xfdesktop archive](https://archive.xfce.org/src/xfce/xfdesktop)
    or
[Xfdesktop tags](https://gitlab.xfce.org/xfce/xfdesktop/-/tags)

### Installation

From source: 

    % cd xfdesktop
    % ./autogen.sh
    % make
    % make install

From release tarball:

    % tar xf xfdesktop-<version>.tar.bz2
    % cd xfdesktop-<version>
    % ./configure
    % make
    % make install

### Reporting Bugs

Visit the [reporting bugs](https://docs.xfce.org/xfce/xfdesktop/bugs) page to view currently open bug reports and instructions on reporting new bugs or submitting bugfixes.

