/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.util;

public class DoubleArray {
    private static final int DEFAULT_SIZE = 512;
    private static final int INCREMENT_SIZE = 256;
    private int valueCount;
    private double[] array;

    public DoubleArray() {
        this(512);
    }

    public DoubleArray(int n) {
        this.array = new double[n];
        this.valueCount = 0;
    }

    public int size() {
        return this.valueCount;
    }

    public void clear() {
        this.valueCount = 0;
    }

    public void add(double d) {
        if (this.valueCount == this.array.length) {
            double[] dArray = new double[this.array.length + 256];
            System.arraycopy(this.array, 0, dArray, 0, this.array.length);
            this.array = dArray;
        }
        this.array[this.valueCount++] = d;
    }

    public void add(double[] dArray) {
        int n = this.valueCount + dArray.length;
        if (n >= this.array.length) {
            double[] dArray2 = new double[n];
            System.arraycopy(this.array, 0, dArray2, 0, this.array.length);
            this.array = dArray2;
        }
        System.arraycopy(dArray, 0, this.array, this.valueCount, dArray.length);
        this.valueCount = n;
    }

    public double get(int n) {
        if (n < 0 || n >= this.valueCount) {
            throw new IndexOutOfBoundsException();
        }
        return this.array[n];
    }

    public void set(int n, double d) {
        if (n < 0 || n >= this.valueCount) {
            throw new IndexOutOfBoundsException();
        }
        this.array[n] = d;
    }

    public double remove(int n) {
        if (n < 0 || n >= this.valueCount) {
            throw new IndexOutOfBoundsException();
        }
        double d = this.array[n];
        System.arraycopy(this.array, n + 1, this.array, n, this.array.length - n - 1);
        --this.valueCount;
        return d;
    }

    public double[] toArray() {
        double[] dArray = new double[this.valueCount];
        System.arraycopy(this.array, 0, dArray, 0, this.valueCount);
        return dArray;
    }

    public double[] toArray(double[] dArray) {
        double[] dArray2 = null;
        dArray2 = dArray.length >= this.valueCount ? dArray : new double[this.valueCount];
        System.arraycopy(this.array, 0, dArray2, 0, this.valueCount);
        return dArray2;
    }
}

