/**************************************************************************
*   Copyright (C) 2006-2022 by Ilya Kotov                                 *
*   forkotov02@ya.ru                                                      *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.         *
***************************************************************************/

#include <QFile>
#include <QTextStream>
#include <qmmp/decoder.h>
#include <qmmp/decoderfactory.h>
#include <qmmp/output.h>
#include <qmmp/outputfactory.h>
#include <qmmp/visual.h>
#include <qmmp/visualfactory.h>
#include <qmmp/effect.h>
#include <qmmp/effectfactory.h>
#include <qmmp/inputsource.h>
#include <qmmp/inputsourcefactory.h>
#include <qmmp/abstractengine.h>
#include <qmmp/enginefactory.h>
#include <qmmpui/filedialog.h>
#include <qmmpui/filedialogfactory.h>
#include <qmmpui/uiloader.h>
#include <qmmpui/uifactory.h>
#include <qmmp/qmmp.h>
#include "general.h"
#include "generalfactory.h"
#include "aboutdialog_p.h"


AboutDialog::AboutDialog(QWidget* parent)
        : QDialog(parent)
{
    setupUi(this);
    setAttribute(Qt::WA_QuitOnClose, false);
    licenseTextBrowser->setPlainText(getStringFromResource(":COPYING"));
    aboutTextBrowser->setHtml(loadAbout());
    authorsTextBrowser->setPlainText(getStringFromResource(":authors"));
    thanksToTextBrowser->setPlainText(getStringFromResource(":thanks"));
    translatorsTextBrowser->setPlainText(getStringFromResource(":translators"));
}

AboutDialog::~AboutDialog()
{}

/*$SPECIALIZATION$*/
QString AboutDialog::loadAbout()
{
    QString text;
    text.append("<head>");
    text.append("<META content=\"text/html; charset=UTF-8\">");
    text.append("</head>");
    if(layoutDirection() == Qt::RightToLeft)
        text.append("<div dir='rtl'>");
    else
        text.append("<div>");
    text.append("<h3>"+tr("Qt-based Multimedia Player (Qmmp)")+"</h3>");

    text.append("<p>"+getStringFromResource(":description")+"</p>");

    text.append("<p><b>"+tr("Version: %1").arg(Qmmp::strVersion()) + "</b><br>");
    text.append(tr("Using Qt %1 (compiled with Qt %2)" ).arg(qVersion()).arg(QT_VERSION_STR) + "</p>");

    text.append("<p>");
    text.append(tr("(c) %1-%2 Qmmp Development Team").arg(2006).arg(2022)+"<br>");
    text.append("<a href=\"https://qmmp.ylsoftware.com/\">https://qmmp.ylsoftware.com/</a><br>");
    text.append("<a href=\"https://sourceforge.net/projects/qmmp-dev/\">https://sourceforge.net/projects/qmmp-dev/</a>");
    text.append("</p>");

    text.append("<h5>"+tr("Transports:")+"</h5>");
    text.append("<ul type=\"square\">");
    for(const InputSourceFactory *fact : InputSource::factories())
    {
        text.append("<li>");
        text.append(fact->properties().name);
        text.append("</li>");
    }
    text.append("</ul>");
    text.append("<h5>"+tr("Decoders:")+"</h5>");
    text.append("<ul type=\"square\">");
    for(const DecoderFactory *fact : Decoder::factories())
    {
        text.append("<li>");
        text.append(fact->properties().name);
        text.append("</li>");
    }
    text.append("</ul>");
    if(!AbstractEngine::factories().isEmpty())
    {
        text.append("<h5>"+tr("Engines:")+"</h5>");
        text.append("<ul type=\"square\">");
        for(const EngineFactory *fact : AbstractEngine::factories())
        {
            text.append("<li>");
            text.append(fact->properties().name);
            text.append("</li>");
        }
        text.append("</ul>");
    }

    text.append("<h5>"+tr("Effects:")+"</h5>");
    text.append("<ul type=\"square\">");
    for(const EffectFactory *fact : Effect::factories())
    {
        text.append("<li>");
        text.append(fact->properties().name);
        text.append("</li>");
    }
    text.append("</ul>");
    text.append("<h5>"+tr("Visual plugins:")+"</h5>");
    text.append("<ul type=\"square\">");
    for(const VisualFactory *fact : Visual::factories())
    {
        text.append("<li>");
        text.append(fact->properties().name);
        text.append("</li>");
    }
    text.append("</ul>");
    text.append("<h5>"+tr("General plugins:")+"</h5>");
    text.append("<ul type=\"square\">");
    for(const GeneralFactory *fact : General::factories())
    {
        text.append("<li>");
        text.append(fact->properties().name);
        text.append("</li>");
    }
    text.append("</ul>");
    text.append("<h5>"+tr("Output plugins:")+"</h5>");
    text.append("<ul type=\"square\">");
    for(const OutputFactory *fact : Output::factories())
    {
        text.append("<li>");
        text.append(fact->properties().name);
        text.append("</li>");
    }
    text.append("</ul>");
    if(!FileDialog::factories().isEmpty())
    {
        text.append("<h5>"+tr("File dialogs:")+"</h5>");
        text.append("<ul type=\"square\">");
        for(const FileDialogFactory *fact : FileDialog::factories())
        {
            text.append("<li>");
            text.append(fact->properties().name);
            text.append("</li>");
        }
        text.append("</ul>");
    }
    if(!UiLoader::factories().isEmpty())
    {
        text.append("<h5>"+tr("User interfaces:")+"</h5>");
        text.append("<ul type=\"square\">");
        for(const UiFactory *fact :UiLoader::factories())
        {
            text.append("<li>");
            text.append(fact->properties().name);
            text.append("</li>");
        }
        text.append("</ul>");
    }
    text.append("<div>");

    return text;
}

QString AboutDialog::getStringFromResource(const QString &res_file)
{
    QString ret_string;
    QStringList paths;
    paths << res_file + "_" + Qmmp::systemLanguageID() + ".txt";
    if(Qmmp::systemLanguageID().contains("."))
        paths << res_file + "_" + Qmmp::systemLanguageID().split(".").at(0) + ".txt";
    if(Qmmp::systemLanguageID().contains("_"))
        paths << res_file + "_" + Qmmp::systemLanguageID().split("_").at(0) + ".txt";
    paths << res_file + ".txt";
    paths << res_file;

    for(const QString &path : qAsConst(paths))
    {
        QFile file(path);
        if (file.open(QIODevice::ReadOnly))
        {
            QTextStream ts(&file);
            ts.setCodec("UTF-8");
            ret_string = ts.readAll();
            file.close();
            return ret_string;
        }
    }
    return ret_string;
}
