/* ----- decode/1013x7177, derived from supercop/crypto_decode/try.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <ntruprime.h>
#include "ntruprime_test.h"

#define fail ((ok = 0),printf)
static const char *decode_1013x7177_checksums[] = {
  "4fd0bd0a87df97ccb7d348b0ab91826cf1dfea84d6853817d4e75dae12cb3b44",
  "2a15b4ce79e1c074b085bd7abf71de7083fba0503d4ac06d10498fe965a26a10",
} ;

static void (*crypto_decode)(void *,const unsigned char *);
#define crypto_decode_STRBYTES ntruprime_decode_1013x7177_STRBYTES
#define crypto_decode_ITEMS ntruprime_decode_1013x7177_ITEMS
#define crypto_decode_ITEMBYTES ntruprime_decode_1013x7177_ITEMBYTES

static void *storage_decode_1013x7177_x;
static unsigned char *test_decode_1013x7177_x;
static void *storage_decode_1013x7177_s;
static unsigned char *test_decode_1013x7177_s;
static void *storage_decode_1013x7177_x2;
static unsigned char *test_decode_1013x7177_x2;
static void *storage_decode_1013x7177_s2;
static unsigned char *test_decode_1013x7177_s2;

#define precomputed_decode_1013x7177_NUM 4

static const int16_t precomputed_decode_1013x7177_x[precomputed_decode_1013x7177_NUM][crypto_decode_ITEMS] = {
  {2825,-1005,-840,3147,-935,2079,-449,-3403,-2963,-3256,2296,192,3122,1233,-172,-595,-54,90,-1076,-2726,-3220,1945,970,-2268,-1716,-3416,950,-2251,-2188,2407,-1123,-368,-1433,-3363,3478,369,-305,1947,-172,1560,-507,189,165,863,2652,-1064,-225,2448,730,-1191,-1867,-1559,3344,2457,2153,-2200,1064,-552,1268,-3443,2187,-2092,-438,-3163,28,-3478,1884,-2699,-562,-1313,2904,1227,1046,1909,2442,2411,1439,-681,-2883,-1358,-2762,2660,-3570,-52,-1786,2005,-246,376,-3422,3158,-1133,543,3015,-2637,-3168,1712,1778,-2705,2795,-3235,2976,-2977,-1484,3156,-1494,-1081,-1695,-1949,2833,-2172,2983,-2130,-1493,-2288,2520,-894,1129,1849,-700,-2498,2559,2212,-3501,-1185,2682,886,-255,-748,-3552,1277,-467,-3241,-1876,2214,2324,3420,-221,2583,2351,2096,-1398,1250,-497,-244,-3272,-675,1049,-3507,-2542,998,-3402,667,2203,2697,-1131,2976,1396,185,2980,-1107,-2397,-3500,2730,-1572,2090,-1890,-505,2469,-3159,-1678,2465,-1320,-2842,-1898,-1071,-2383,-589,-1079,2750,-688,2962,1609,-606,-1580,1167,-1498,-610,228,2584,-1301,-795,-1517,1346,-2747,2304,2733,-3397,2706,-1376,1982,-2643,75,-2593,-3466,-2455,234,1958,470,1306,3028,-702,-3416,2328,-2144,369,833,-2613,-2984,612,-616,2293,-2015,-52,-2133,3374,1517,-238,-1350,-1377,-2509,326,-2623,1847,-2162,2306,-3521,3016,-636,1598,-1676,3394,-3427,-3564,1601,191,-1115,-2351,-876,-3549,-1781,3542,1022,1453,2320,-1680,1556,133,-454,-1220,226,-2013,3483,987,-2267,-3422,-1951,2714,-2716,-3485,453,2393,3448,3426,668,1859,1272,437,1870,1676,1594,-2016,2422,811,1477,2908,-1118,1746,2707,567,-1222,3518,-2613,-1122,-1394,3063,-1954,-2423,1758,2233,-1799,1687,-1337,-2612,2003,3113,-2448,1678,1021,1023,855,-2312,2049,1056,1876,-972,824,1074,3170,-1810,-2463,3570,-2378,-3136,-296,-3212,-1321,1999,-661,1069,-1899,-577,-326,-2825,-3301,3182,388,1915,2745,-3483,-1414,3469,-3119,-465,636,3189,3057,-1960,221,-985,2912,-1543,-231,-747,2845,43,1532,2559,3302,21,769,614,1048,2021,-1520,-27,2191,-3124,2288,1982,-955,948,646,1519,-588,-3520,267,-3162,3299,3281,-1114,-484,-2330,-466,-2353,2296,-363,-2186,1552,-2815,2285,-1901,-557,-2751,-2579,3118,-701,2658,1547,-1276,-1055,1916,2713,3295,905,-1900,1177,1186,-2387,1858,1500,-1808,-1111,680,558,1601,2809,2611,-1138,753,-684,-3214,1894,2431,1726,1089,-1857,-485,748,-1468,-1972,-2351,476,-3024,-2081,-245,-1423,-2265,1264,2742,1217,-1009,2086,1061,-1975,-190,2935,-2549,-1581,-734,-1876,-3513,-218,3094,684,3487,-2588,-666,-2786,706,-2362,-1804,1908,2262,1351,3310,-1316,1598,508,-3343,-1927,1167,1552,-3168,1206,243,-2567,-239,-759,279,714,1605,2347,3187,332,-799,-2162,1980,-1265,-1593,-3138,2143,-1646,2074,3254,-3283,-3185,-1174,1876,-1157,-2439,-91,382,2500,-400,-240,864,-2258,-2401,1235,2375,378,-3319,-2127,-549,-3467,1802,1684,-683,-1974,-1810,-2092,-2202,-657,-2491,2034,-1206,415,1400,2384,585,-573,3285,-2605,2057,-3153,1876,1994,-3561,2721,1152,1795,415,-468,-2042,2850,-1282,-2971,1005,-1062,2567,-792,3509,2509,2171,-620,-498,1945,-2608,231,-1986,-2748,-1302,-723,1476,-191,2814,-3432,1945,-2501,-3081,-691,876,-440,-64,1553,-363,1688,-746,-3346,-1353,-3400,1895,-2878,-263,2213,486,171,1627,-1762,2059,-1456,535,-581,2527,-2750,3201,136,-2444,647,2657,-3127,460,-1135,3537,-603,1007,-369,-16,-2700,1616,3386,1337,-1058,2733,967,3245,2334,-2301,-2823,-2199,2907,2216,2473,2807,3395,1325,2393,-531,2006,-1108,459,-1541,1835,1736,-469,-1771,-167,2627,-553,523,-3144,-665,1285,1422,-1531,501,-1391,307,553,-310,-1925,-2107,-2894,-2920,58,-2169,-3328,-2944,3240,-52,-1705,1241,-310,2049,2098,210,3374,-2590,1437,2952,-799,925,-1435,-1250,437,1840,-387,899,-1574,162,3006,3076,-518,557,-48,1317,-2503,3317,-2785,-1505,876,2927,-3181,-906,-1549,-1782,2871,1576,2779,-845,2433,-286,-1818,-2344,444,-2335,-3282,2000,3570,-2501,-3536,3278,2715,-2069,2614,-1664,1428,-1387,-3019,1889,574,-3014,1209,2465,2674,3388,-1182,96,-400,-2531,1723,-3132,-3519,-168,-511,-2345,1231,-2794,-1655,-2106,-1641,115,1012,68,-231,3424,-2436,1527,-3523,3574,2343,1336,3189,-1761,3352,1373,-1159,0,-2837,-1215,3584,-1415,-661,804,679,-3289,-1032,-971,881,3523,3568,2443,-2927,-138,1568,3105,-2331,2804,-2693,-3108,1330,1435,-1267,883,-2345,1767,1329,-735,-2210,-932,13,424,-2390,-2999,1632,190,2532,2615,904,1514,-788,-3066,738,-2367,360,-1006,-2502,3463,-730,-1386,644,1059,2340,-1937,-1859,2184,-3301,-3260,1747,-2004,-1486,-675,-3205,3201,321,1438,-2567,-893,-243,2675,-313,-106,2758,646,704,1433,-3156,838,-1701,2524,201,-2775,-776,-148,573,2030,431,3064,1797,3105,-776,1679,2826,-2641,-1655,-2311,251,412,-3286,3480,-3433,349,-970,-2870,824,1697,-233,1031,-3563,-2861,-2461,-2169,1794,-1074,-3139,-3023,2565,3458,2991,-1670,539,-1876,3040,-3586,-2634,2428,-1612,138,2171,-251,-1481,1850,-3307,2952,-2119,282,2484,-146,-1421,-2770,-2495,-1409,2733,-1570,2761,-3487,-2425,504,3004,2571,-985,-230,288,3062,1062,-1742,-2810,3192,-307,-2520,1626,3523,-1002,-2358,-2453,-2552,-2762,-1606,879,3062,-1298,-1907,1645,1276,3435,-842,-2421,-823,-2919,-1418,892,-2886,-3042,-920,-987,-2611,-751,3363,1923,213,-1286,-783,3480,-3388,-2009,-2138,2938,-3361,2441,-1236,-1430,2055,3393,638,2044,-1714,-1358,-2706,997,2339,-3308,3299,-2999,-3513,-3334,-506,2526,-2936,-3223,-2441,742,-766,742,-1883,1534,-804,-2715,2730,1016,-668,-2062,174,2354,-700,-2528,2485,-2329,1927,1775,-1953,-1394,3020,2725,523,-2198,995,2047,-1115,-2870,3214,210,1694,840},
  {198,2637,2851,-1595,-281,-1616,-1301,-959,165,-317,2556,-857,327,-572,-3265,-2837,1721,2855,785,-2028,-279,1423,475,2303,1259,-2244,1140,-523,2006,-2136,-501,1968,-816,3457,3434,3108,-1935,940,-702,-2814,2465,-1451,3071,-3067,-877,-2800,-1897,-3008,-1383,-2872,2188,2284,241,-2246,2092,1472,931,2527,2971,-2846,-2489,2548,3233,-1496,2406,-3296,2359,1099,3299,-2640,24,424,-3074,-1009,229,-3313,-1395,2666,38,3045,-2424,1757,1562,-2553,2511,1719,1648,2970,107,2076,1847,390,-828,-2867,-3365,2428,-3131,-1570,-736,-1753,731,-2304,-2419,-3365,718,539,1247,1287,-2056,1158,-3473,-2544,-2559,-1810,1613,2055,3082,1735,-643,3057,-3512,-377,2096,-412,2824,2550,3557,-3206,3546,1348,713,3583,1924,-3101,-939,-187,1515,-2370,3204,-3360,174,667,-927,874,2834,579,-1652,-1911,-2225,575,2423,-2592,-1361,-3201,-2067,2566,1035,1030,-3003,-3457,-507,-1214,1908,2455,-2510,203,1158,-2529,1884,-2742,1693,741,1484,1918,-859,-266,-1098,2711,3113,506,33,-344,-1381,-71,-3210,2843,-2869,359,-927,1274,972,75,-720,2637,-2461,199,-1110,3507,573,1459,1463,-1845,3293,2940,-2112,2057,-547,-2114,-385,238,-1960,2222,-1913,238,3494,2087,-931,510,123,805,2953,2762,-2849,-2037,-3211,2719,-3545,935,-2663,3533,-1348,-3502,-1030,2758,1937,1216,777,232,1865,79,103,-3428,249,-3047,3161,1245,-3497,-900,1552,-1945,869,-1772,-2908,2655,-953,-586,2039,-3312,827,3179,-1341,-2509,3021,-3499,751,-3203,134,-832,-2079,303,619,-1576,-2299,2018,-2098,-491,1626,-656,3398,-772,10,-2831,3021,-3322,673,2171,1839,2389,-2200,983,-2440,1240,43,1077,3381,2860,3026,-1507,-1468,-1868,-3575,-2165,-559,2994,-2081,1702,1823,-3045,-2505,1991,156,996,933,758,-1195,-2120,2248,2240,-1263,949,-87,1938,1163,1274,-569,3001,443,-2976,-303,1472,-2678,-635,2683,-1623,726,908,-1435,982,1220,2965,-1271,2545,3351,429,2368,-2590,2626,1439,-1739,-3468,-2551,1817,2711,-3375,-3390,1621,-3121,-2799,3029,322,1914,688,1899,-1333,3533,550,-2779,-1529,1892,1836,1988,-2653,111,1529,2749,-2910,-3171,-2721,-2843,1842,1898,2090,-2934,2860,935,3524,-3553,-1992,-315,-3563,1610,-3003,-226,-2306,-1043,-1311,3424,1210,-975,2982,-813,465,3000,2592,1651,706,1187,-2676,-949,-312,-2448,3448,-905,-2130,2796,858,1484,-2009,-712,649,3376,3067,-1835,-429,195,-2394,-1982,-2480,-63,-2690,2237,-1417,2689,-516,-2419,388,-1275,-2237,1538,3096,-367,-2985,1735,-1483,-1897,1294,1423,2270,104,-1816,-3066,1044,1939,2654,1072,2764,-3513,3312,-2891,2234,-616,2614,-2390,-2249,-2790,-2602,2570,2252,-333,-198,-1429,2820,3165,710,67,545,2440,3509,3234,3444,795,968,-3026,-2062,-525,306,-1413,2839,1796,-2932,1440,2829,1763,425,-1418,-3350,-2779,-1305,157,-25,-695,-292,-2846,-1623,2782,-2261,-735,2921,19,1318,-1422,-1870,1964,2776,562,906,2806,349,2632,477,1047,1031,-1631,-2353,-3309,-1058,-1602,-1507,2468,3368,-1771,1520,-2853,2982,1947,1421,2327,-2693,-3149,642,125,-2404,712,-2640,-1314,-2825,1543,339,-457,442,3135,-2586,-14,-823,3405,-2665,3410,2057,1882,2964,-16,-258,-364,498,1826,2170,-3406,-2403,12,1906,2615,-1049,-3416,1935,196,2215,552,-1313,-1622,-2642,-1310,-2924,-1857,-1505,-2584,-1272,-3484,1121,1269,1804,-2838,2803,994,2131,2520,-461,-549,-2061,287,430,-1717,-209,3321,2080,2163,1227,3343,-1010,3333,-169,-761,-338,-597,-1219,-542,3211,1595,3400,3249,-1396,-713,-3208,1418,-685,2157,2977,-1257,-1870,-840,2846,-3016,-3200,1800,2241,-2944,-766,-3494,-1577,2880,2155,3031,-740,-239,-1406,230,-2029,-2069,2577,279,841,-165,2443,-2829,-2932,-957,-2838,1823,2277,-1752,1133,198,1725,-2666,3379,-3270,2130,-3564,509,-1524,-25,-1940,-980,2869,1290,-2797,1368,-2284,378,-3345,-138,-2676,2942,-2663,-3033,-2858,-284,3000,-1820,212,-920,2298,-2358,-3107,1349,-1868,-3435,1329,-2560,2796,-1732,-2351,1131,-592,-3438,-3575,-443,-2802,-3376,-2517,-2298,-1460,2200,3110,3418,1563,-33,2388,808,-2835,2683,-1322,1476,2360,-199,-1316,-2543,-591,-3052,-807,19,-3342,-380,-1562,-1227,3182,3268,899,2455,-1144,129,-1419,-692,-2868,1032,-2103,2163,-2667,3215,3493,316,-3411,-3484,-3338,-1729,-478,-584,2251,946,-1654,1008,1792,2777,-1629,-935,1935,-1016,1768,1937,-73,-2463,1279,-1368,2772,3462,1845,-3571,-3533,-3119,1714,191,-2290,1433,-2455,2563,421,-745,3022,1112,-2584,1797,2137,-2968,1125,715,1971,-128,-3148,93,47,-162,1543,554,-310,1368,1925,2487,3341,516,-20,-3266,3101,-1109,1860,-1335,3237,-2584,-3132,-2833,233,84,-1537,-3006,2248,2508,726,-245,1859,200,1816,-738,-3378,3214,933,-2429,-2947,998,-2591,-29,-2828,2432,820,1536,1650,2555,-2705,-3165,-2052,-2919,3236,2912,1563,-2397,-2719,-690,-410,-730,3214,-1271,-3409,-1559,2437,1430,-781,-1364,-2064,1444,2709,2946,-1777,-998,-2580,-918,1083,-389,110,-1623,813,376,-2847,1854,-1905,-2987,1786,-1732,-550,-130,1224,3442,1395,3556,1372,-2892,1303,-1767,-3319,632,595,-1460,3569,947,-1586,601,2055,2527,1491,271,-3464,2539,-826,2150,-2964,-2803,-1889,-3394,2319,16,-953,581,1218,-2162,-3170,-3,-58,2035,1674,35,-3488,-1922,3391,1320,-110,979,3244,1502,-2959,516,-3292,-2832,2367,-2677,-1312,530,1676,-3229,-2518,3308,-1069,-2253,-3103,-1040,-218,-365,3141,-2638,-1167,2446,2618,1377,-870,-1683,-2798,-674,-453,-1648,-2621,-1285,-2926,-2908,-1085,2584,-253,2391,2824,-2285,1755,3280,2654,2323,2812,-2716,1592,-190,-234,704,2195,3587,2617,-1896,3463,2947,-269,-2197,3073,3461,1269,-329,2595,-1538,-871,-2729,-1355,-2376,2822,-2013,21,-9,68,-1297,-2457,-1426,2264,-512,1528},
  {-2236,-1961,-273,3367,-2265,3383,-783,-1200,-2220,2659,2859,-356,-1766,-2320,-1337,3108,-2533,2701,3192,961,3275,2856,-2408,-662,-2375,294,-613,-880,-947,177,8,-1694,-1619,-2178,-813,-2284,-28,3472,-1169,905,1404,-3323,-2115,1348,-787,-391,-623,1269,105,-314,989,-1910,3084,-2276,2844,-848,1613,-1957,1097,657,295,-1346,-3248,1220,1861,2365,2829,-1490,-195,-376,-1062,1161,2068,-1387,-920,-494,-559,1675,111,969,-781,-640,3513,858,1009,-855,-2941,-2452,2577,-2062,-98,-1280,1719,3127,2485,337,-3383,2384,-1819,-2286,-106,1559,93,-2530,-2308,-1082,-1712,-3363,-1132,-1961,1205,2270,-2476,-2115,2829,-3424,-2653,3413,-308,2637,44,-2773,-1523,-1162,-1356,-1593,-176,652,-2279,-1340,-745,217,2706,-2719,2040,671,-1821,1136,2925,201,-3427,-2536,-2139,-247,2565,2600,-3100,-2280,3489,-1384,-497,2282,471,-3121,-1851,-1089,949,-3139,-1242,2367,-144,2495,2704,639,-494,2950,2308,830,-1630,2787,901,-82,-1916,1060,3562,441,731,-2357,2146,-2178,1498,999,2393,-886,3263,-1065,983,3106,1984,-143,629,1630,1952,1220,406,617,-1708,2350,-3578,2901,-1271,2099,-1768,2877,2182,2105,131,541,1848,-789,-929,-698,779,911,-1096,3028,722,-2605,3324,-819,538,2710,-959,-2290,-15,1141,-2738,1020,-396,-3167,-80,2252,-3446,2355,-308,-421,3171,-488,322,-1131,2531,-2591,-1584,336,3322,492,-15,-3287,2948,-568,-2654,-2860,-386,-3377,1063,418,1837,807,-123,3268,-1445,2801,278,-527,2717,465,2701,3581,295,-1469,1839,-2460,2106,-1446,2313,-1091,2747,-295,3226,3228,-1017,-1698,49,-185,-2515,-108,1773,-2985,368,-1902,-1170,-2980,421,-101,1513,3019,746,2619,381,2143,-1997,811,2029,1513,1452,1165,755,-3192,-2866,-1402,-690,379,-590,3334,1837,3284,-1843,-2512,910,512,-1285,-1590,2072,1489,2581,1947,-484,-765,2335,-3307,-2828,-988,1361,2358,2428,1963,-2691,2594,-1165,-946,-2149,-2099,1402,2764,1606,1493,1030,2200,1072,3109,1014,-2421,2371,-2797,-294,2817,1184,2361,-123,960,1565,-713,-1605,332,-2578,-300,-716,3054,-2999,159,2080,2999,451,-215,-402,-3081,1739,1326,-3169,-125,217,993,2192,2588,783,2917,2548,2289,-1929,2867,439,-2241,257,-22,1352,588,-1751,3366,1518,-2334,-3303,2390,-73,1853,1470,-2533,-2904,32,81,-3202,-2283,-245,2264,-1803,3453,-1135,2221,2547,-507,-783,-1644,-2511,1693,-409,-3164,-655,-159,1749,934,116,234,-3133,-2400,1597,-2445,1943,-2870,-97,-2737,457,-1431,-3540,-2780,2630,347,3143,-2836,-2153,1131,96,-1322,2721,-589,2010,1182,-3314,2811,-3265,-1223,2156,-383,-2018,-2255,2851,2929,2480,1913,-1239,1908,255,3046,2864,49,-2673,-688,-3403,-2303,-1959,-1312,1006,-2013,-315,2644,1732,-283,-3505,2472,3217,1644,6,3472,931,-1673,-2261,2799,1299,2007,2241,-2568,1264,395,-889,113,-518,2822,-2831,-3253,-240,3007,1254,1218,1577,-2446,2021,-1121,1688,-2460,-596,2589,174,3335,-3394,793,2378,2059,598,2087,-422,-3437,337,-1860,-1096,-3512,-1710,32,2608,-1776,-2916,-1742,-320,578,-111,1916,-3532,421,313,2255,2218,1117,3516,3253,812,-1266,673,2120,-1667,-3072,2863,-1147,2867,2349,-3266,-1346,-1222,825,2270,-2059,-3008,-2250,-174,3295,-2696,19,76,2378,-3561,-360,1981,-1349,-430,-1830,-348,2397,-2326,1144,-3358,-2949,2620,519,-240,2624,1875,-1794,936,-2247,1008,-2587,-3167,3487,-3259,-331,-187,-348,-3558,2363,2586,-3096,1307,-1414,-2361,1597,-2844,-1593,283,-921,2206,3289,-3452,2880,3379,-121,1715,2627,2433,-10,393,-520,-2277,-3137,604,2278,-2115,428,1612,-1714,217,1018,1089,2926,-2364,-1809,356,-1365,513,1750,3433,2509,-1404,-781,-2436,-943,2767,-275,-276,-142,-2584,-3432,-2033,1743,3023,-479,72,-1269,-804,-2336,2128,-661,-2731,1063,-1523,-6,1581,-1320,-3370,1859,-3383,407,2314,496,330,3450,-1299,1224,-866,-3234,218,-1609,-1063,-1841,2836,2380,-243,822,-1072,-1690,-1620,-2216,1820,-3036,3353,-171,-3531,813,2949,-875,3275,-3203,232,-1625,3426,-795,-3254,2121,-3144,2244,-2097,-142,1516,1802,3050,-557,1718,-821,-385,80,684,-2873,2563,1539,-2987,1351,-2410,-2050,-629,2750,1205,758,-3559,135,1454,150,3036,-119,-388,793,-2418,868,-215,760,-3066,-1542,-3465,3438,547,2483,2493,2959,-670,2122,3128,-992,-715,644,-2447,32,-3522,1941,-464,2319,-3205,1067,3419,-1149,3573,-3321,576,-1073,-2975,728,-3021,-381,562,1578,2767,598,3435,1311,-1364,-3531,752,-2144,-2953,-2945,192,1615,1397,3105,-3479,-2425,358,265,-2990,-2134,-1862,-1421,-2575,-2584,-987,1526,-1153,-607,-2477,-600,1813,1973,-2482,2649,775,-1967,1896,3200,3218,-871,2214,1343,2285,-598,-2511,-2715,-1545,2652,-2156,517,-720,2054,-1247,-3491,349,-1819,3069,-1092,-2467,-3374,1760,1802,2680,1715,-1394,1685,-2081,192,-3525,-576,-2726,1212,-805,-1207,-1978,325,-2405,-3287,3583,-1230,-3281,1954,-277,2912,-2609,-2945,-2750,-3432,-1228,-151,-3246,2428,3149,-1007,2403,-1921,-1720,-1440,999,920,121,-92,864,687,3080,971,-322,-1643,-704,2283,-2069,-1129,2114,-1793,-1100,-1257,3067,-960,-283,-805,3168,78,-577,3413,-1812,-2170,2402,647,-2569,3374,-494,34,1331,-71,-1062,-279,-389,-1619,-391,-2579,-1728,-705,821,-389,700,810,1704,-3283,3228,-3090,-871,-2305,-2161,-2940,2495,138,-1207,-1204,-3152,-16,-3383,180,102,2932,2867,-2055,-353,-3000,122,-1290,-1702,-3319,-1742,-1857,-2337,2210,2191,342,3140,-1113,1440,2364,784,1962,-1928,3442,1880,3042,-2861,192,674,2339,-2304,2327,-3053,1494,1482,426,-1623,-1508,3482,-1038,-3404,-1430,-1631,-525,-2337,948,1275,373,-1514,1220,-2023,2219,-2440,-373,2873,-181,2690,2455,-35,1145,2423,-805,3517,587,2848,1803,-412,-1655},
  {-1517,3255,2663,-2564,1591,516,-2438,1390,578,-3534,2957,-2598,-2761,1453,-1810,-3135,1131,-482,-2120,1509,-2809,3405,3160,158,-1746,1713,-3290,-3405,3093,1087,2159,2639,-2872,-241,2293,-2315,-833,-3319,-797,3021,-2962,-542,282,-597,-3166,-187,2595,-1066,-2006,118,-1641,1382,-1363,2560,726,-1951,-937,-2087,-1524,-1323,-866,1357,-3243,1769,-2819,-3568,-1911,195,-2300,-2318,3051,2070,1098,3142,1240,-2023,680,340,-2435,-2985,-2750,-891,384,2761,-1696,1578,1417,441,-312,3191,2625,-2007,284,775,934,-1903,2630,-1388,2597,-120,-1639,2324,-2484,-345,-224,-2629,-2506,2978,565,421,-1721,2005,1847,2192,977,2872,-534,-3318,-764,812,535,2743,157,-1840,-834,-3104,2592,2024,3268,1206,-1025,3301,2882,-946,-2191,113,1374,162,1882,-2875,1174,-2807,2802,-534,-441,-2021,1322,575,372,-1026,2369,2742,-1067,3239,-1172,-48,-781,-751,-409,-348,1561,-1171,-2224,575,2874,1580,-1990,280,-1509,1614,2066,-2375,2051,-1619,-1786,2245,-1310,-1001,13,548,-1934,-1252,-274,-330,-2103,1009,-813,-2832,-549,-2058,-55,-277,2441,-1993,-1246,-2319,-581,-1788,1940,-2012,1783,-1025,526,3539,-2120,-1991,-2714,-3344,478,-385,-2299,1403,563,648,-1806,3441,-1094,622,-2576,2578,-1601,-1275,-1174,-2956,-1667,-1343,333,-1637,-734,-2294,3218,2912,1778,85,1105,-2030,-744,-466,718,-2073,-2943,3085,-855,-1873,-2212,-3362,1857,-1671,556,2280,-2246,2577,3284,1947,-3536,-1248,53,-2169,573,803,-2673,-264,-2049,2548,-225,-2126,618,-309,-940,-3522,-1085,-3475,-2733,-2352,-1409,3304,-2066,-394,-2201,805,1433,-2083,-1284,-777,-1239,2024,2402,-447,-782,-2450,684,1697,-2298,-2786,1125,2599,-1709,1407,-1791,2779,1566,-845,2147,615,-1869,-850,673,-2998,-2767,-3516,1094,-2835,-3490,426,-1802,-2159,-812,-2972,161,-2157,3567,8,-1489,-2890,2258,2942,-2499,1450,-2531,2811,-1772,-1218,2813,-1064,-3182,-3563,-2908,3126,884,-2752,2033,-2472,-2545,3504,1338,-2405,-1113,2023,-944,1807,-242,-950,-1400,-1250,-95,-995,15,-1552,-3143,895,-2113,673,3351,469,1764,3322,-339,613,-3161,1513,-2942,-1434,-1106,1990,-566,-1913,-3133,3007,2895,-2934,-569,-2459,1233,-1846,2029,1298,-1208,-435,1336,-820,2901,-1086,-1661,2340,3536,-903,2632,-3166,3265,976,2179,3174,-1474,1852,-3377,1974,2120,-1958,1153,157,1634,-1333,-2142,-1868,-374,-1308,1059,457,-1760,-3205,-942,2243,2047,-2094,1716,2808,-2263,1055,3510,-1002,-2685,-3110,-2685,1618,2353,-149,-2554,-632,2927,-3450,-1947,-2145,-3058,-3370,2992,-2897,-2132,2211,384,881,2016,176,1092,3189,50,3262,1232,-508,-2079,502,-497,1642,1344,-812,1327,2817,-664,359,2497,-1441,2048,3202,2139,1085,-2641,158,-652,-1,-2128,-389,-3437,-2866,-1533,-662,-3574,3139,1391,-2973,2289,2622,2459,3155,-3176,1006,-683,-322,2957,3259,1768,971,-3495,3009,1324,-2706,-1058,-2771,462,-1085,3152,-3027,-599,730,792,-3447,2049,-820,-3277,-3143,2671,138,3479,743,382,2340,1081,-1041,1294,-2905,1362,-1311,-503,2237,-1357,-1569,1843,-600,-1971,-2425,-2301,2198,3570,1457,-2296,-245,-2476,-2242,-3164,1775,-3221,-1778,461,2642,-1482,535,2927,-2947,-1985,-135,3349,3476,-917,-2280,193,-2762,1543,486,1363,2740,-2695,-943,2962,-748,-2747,-498,-3459,2276,-1194,2792,-2816,-676,-1650,52,568,-2177,-2506,1260,-2960,522,-1445,-3016,3550,1616,912,-2260,-1966,-422,2346,-2538,2847,-123,2566,1948,3098,-209,3342,2836,-255,-2166,-1493,-1566,-3111,-99,-2531,-640,-3021,527,1553,-3326,2972,-523,1094,-67,-1849,-136,-2832,-1167,2048,3410,2258,-58,2120,969,-699,1460,-3283,-583,-2347,1995,1651,3334,2200,-2104,3087,3169,808,2186,778,1594,764,2834,-1739,1766,-385,276,2792,2186,-510,506,-2117,-2920,-77,2326,-569,-82,-2476,-919,-1595,-2412,-2691,1156,-1817,-1034,2070,1057,-1184,3082,876,-2879,1755,2256,2317,386,264,-823,-573,1147,-1279,196,2795,1954,-216,-1681,664,-2955,-3443,-3554,-2036,-3157,3457,-3044,1367,1838,-2124,-314,-183,1636,-194,358,-3560,-2459,1213,2030,-662,-133,-3000,1836,20,1426,-1820,3058,-150,1840,-1532,2392,1461,270,1202,-374,1301,-2059,2927,-2345,-2702,-2886,1418,3432,-822,-2764,1223,786,2520,-2023,1516,-2677,2994,2234,-1009,3216,3556,-2886,-616,1979,-1349,-1982,-2497,2601,2128,-567,-3057,-2936,-3196,130,2702,2885,2554,149,-2623,3543,-3252,-906,-364,-3422,2088,-395,2281,351,2259,-2945,-1795,-2845,1981,-321,3374,-931,2603,569,2027,2379,3424,-1841,3570,2957,3138,622,2202,-357,-2059,2108,-2205,-2427,2341,3146,3024,599,-2488,430,-2652,-1605,2438,-1192,2867,-2317,575,81,-867,1962,601,-602,-35,-1665,3313,1010,1126,1317,1627,-149,3440,2827,-2052,-316,1918,-2301,-1352,-3345,-3116,-3179,-2841,2052,-1463,660,-2889,1674,-2281,10,3082,2319,1004,-1939,660,2278,-43,1942,1443,-1788,284,1119,2105,-1455,1439,-1371,-1640,-2697,1674,-2676,1396,1267,-2328,-338,-3129,718,-1265,-2772,-2705,-746,2968,-1795,-2169,624,2265,-1852,-1325,-2957,-687,-824,-122,-1044,255,2988,-2572,-3520,-2977,2232,-2907,231,-813,-1147,-1049,-1152,2939,-962,-720,-1210,-398,1463,-3355,3186,-316,-1923,660,-2450,-1018,-671,3513,3512,1289,-812,2916,-689,1801,2058,-2509,-641,-2148,-132,558,3455,-2057,-3022,-2232,3280,257,2574,318,-2289,2328,-1714,1057,652,-691,1996,-939,-1854,-1355,515,2110,649,-3278,7,-3222,-2601,1991,-607,14,3236,-1811,-429,-438,-2935,878,1275,3460,-2503,-2970,-3217,1768,1202,-2831,3546,-3286,-203,-1831,2785,-3271,-3541,-1440,2015,2252,-251,-1187,-2254,-537,-2044,3412,-836,3346,1011,2106,89,-2415,3080,2037,2795,2953,-1767,-720,-431,-763,-1964,-994,-465,609,2876,2100,366,-1471,1020,1834,-3334,-2824,267,1556,-3256,1406},
} ;

static const unsigned char precomputed_decode_1013x7177_s[precomputed_decode_1013x7177_NUM][crypto_decode_STRBYTES] = {
  {220,247,131,155,152,165,196,78,29,94,224,11,179,15,145,210,28,215,30,112,245,239,54,160,92,221,187,124,59,140,213,170,84,172,183,114,106,51,84,210,210,172,36,127,28,129,87,17,35,145,14,58,153,27,57,23,232,140,17,244,39,235,63,151,254,25,161,112,205,47,163,102,91,15,117,14,214,109,39,57,226,62,98,60,171,135,106,40,208,197,210,110,58,63,248,107,1,200,88,193,31,3,80,149,81,148,4,133,221,42,237,196,227,101,146,30,146,125,154,105,235,67,210,40,200,13,221,16,45,199,100,12,170,106,120,141,26,218,7,143,164,218,163,65,165,3,246,240,80,61,81,250,148,95,93,224,29,68,225,204,191,167,142,223,224,9,252,92,211,44,97,119,84,22,50,0,236,207,182,174,75,60,62,242,13,244,202,241,131,140,184,215,215,44,61,81,5,70,118,4,120,40,45,96,203,146,84,124,182,155,82,225,224,57,226,54,11,41,228,136,70,90,247,100,171,42,196,35,146,50,55,189,93,63,97,109,148,97,122,119,239,188,133,66,180,225,45,4,174,227,236,245,101,19,76,92,183,68,86,183,190,98,80,188,51,70,70,151,120,138,185,158,6,49,35,80,155,199,190,146,110,49,64,191,54,152,37,118,105,43,9,226,196,78,109,11,127,120,162,1,190,151,95,76,65,242,155,210,54,162,41,87,60,114,84,53,204,39,127,58,128,158,128,133,43,69,186,160,146,9,113,70,18,113,58,134,36,160,215,20,14,120,179,160,22,208,69,40,175,222,2,170,66,137,47,194,61,162,70,51,102,195,157,142,20,237,100,128,83,110,146,190,107,157,203,43,201,55,207,9,90,208,157,75,93,68,46,234,126,45,38,245,190,130,177,67,237,112,21,110,5,31,216,36,29,218,223,152,38,72,9,74,110,26,42,161,89,102,13,23,48,90,85,10,32,163,143,228,24,1,181,19,47,11,44,37,191,95,167,77,141,105,222,182,153,102,158,206,86,135,197,14,74,240,203,158,156,223,224,83,48,232,125,248,210,234,66,164,90,231,71,247,46,2,220,222,138,220,89,46,240,8,71,100,7,53,107,123,157,79,169,194,168,94,92,35,134,105,228,221,59,209,220,55,152,153,237,2,122,24,243,132,140,212,247,69,185,54,208,188,146,206,4,46,180,241,255,78,9,22,104,185,76,54,203,97,193,10,73,47,194,117,138,90,56,162,226,255,65,22,109,64,72,198,58,112,17,104,61,127,166,91,57,157,87,38,33,239,18,138,65,232,48,248,118,65,134,80,133,195,127,117,171,35,227,61,6,42,169,113,71,141,186,182,243,125,196,86,24,248,29,80,18,80,52,65,39,58,108,234,99,116,27,68,4,94,97,8,210,31,107,181,128,108,0,36,214,222,10,173,198,59,91,32,16,8,220,171,98,64,127,28,43,187,202,211,132,149,107,11,144,54,50,42,33,116,168,135,252,86,32,221,251,94,188,3,72,102,141,73,142,69,155,18,141,126,64,110,180,179,10,228,183,249,69,54,254,50,94,32,123,138,225,183,117,207,199,158,78,125,155,179,166,66,205,71,166,245,45,38,150,233,6,114,222,203,249,28,198,206,112,236,138,243,182,13,234,122,157,205,199,4,129,136,184,43,189,6,167,83,202,141,128,114,161,243,83,44,11,84,71,84,180,46,133,101,161,247,92,226,105,20,215,5,46,207,253,161,116,207,251,147,223,211,113,11,161,5,95,148,205,39,64,170,30,117,130,131,194,226,29,107,99,133,54,209,251,101,234,204,74,53,211,199,50,210,33,48,148,48,231,247,51,229,173,33,167,236,135,140,159,10,44,124,247,119,188,38,64,237,53,95,164,197,73,237,74,181,63,94,98,23,236,195,195,77,143,137,86,12,39,216,89,206,114,224,159,27,170,9,4,39,120,171,9,215,126,227,168,157,74,106,104,101,158,225,191,183,33,37,79,140,246,81,58,215,182,18,208,135,105,143,5,55,203,213,186,8,57,157,224,164,163,23,90,40,103,36,71,150,57,200,238,80,16,59,102,129,93,2,93,210,88,189,219,120,232,16,61,83,11,32,113,191,249,211,196,209,231,166,46,242,238,47,130,8,116,67,40,87,155,55,164,2,37,209,121,245,61,170,209,2,215,231,226,79,184,159,72,38,55,55,240,56,88,133,206,126,192,157,32,28,219,200,226,245,135,233,164,216,56,2,190,92,165,21,206,250,110,34,226,176,48,77,141,234,244,232,240,233,136,128,236,212,64,14,46,125,86,80,138,244,219,142,162,70,90,223,222,7,140,102,226,232,170,48,12,39,168,201,76,177,249,200,192,105,95,205,207,168,44,171,129,88,65,1,92,159,54,222,4,149,123,218,24,166,28,218,105,216,26,245,1,240,53,29,169,38,97,222,58,51,134,128,119,134,17,254,236,72,76,138,212,120,211,181,113,175,41,149,32,124,223,174,174,244,0,7,229,201,166,172,74,63,59,254,104,68,17,251,79,15,205,48,173,125,195,81,120,57,219,83,180,120,25,5,32,60,11,151,200,226,7,104,169,118,129,152,72,68,58,185,238,71,135,83,95,240,228,32,219,131,147,117,31,76,61,179,150,207,69,76,200,179,203,47,124,114,74,136,196,191,179,65,6,255,77,249,127,69,106,15,202,82,247,6,187,181,95,246,246,190,192,60,114,3,100,136,58,0,74,227,147,98,169,36,77,125,228,119,105,238,201,151,93,45,34,43,196,53,93,199,255,66,67,138,187,120,139,112,12,32,118,179,200,44,216,212,237,54,50,42,230,141,141,186,17,73,198,55,254,241,119,241,140,233,90,59,19,234,91,26,230,141,190,28,204,48,73,197,49,211,163,39,168,218,39,180,159,33,120,214,251,60,136,241,57,60,210,222,119,31,163,141,183,123,1,110,247,106,215,53,149,247,24,65,62,190,188,150,253,78,223,242,165,176,158,214,200,55,105,90,30,85,58,223,247,154,67,190,56,187,220,21,5,179,57,234,48,41,62,33,155,20,16,199,203,110,194,149,76,42,134,226,101,129,231,22,53,135,233,164,86,166,146,40,223,205,100,227,38,4,153,24,78,79,192,215,23,144,135,171,91,44,251,7,199,202,188,169,45,30,252,206,203,221,137,16,253,192,58,212,29,249,70,216,79,83,181,21,61,163,91,21,253,9,62,122,138,84,219,2,245,136,112,155,150,132,81,55,105,48,248,37,201,192,180,163,111,7,71,184,15,139,88,9,93,149,251,116,93,102,180,222,48,98,87,30,133,159,16,35,47,153,184,184,106,101,193,216,233,152,142,190,213,175,67,42,243,212,3,125,155,251,87,202,137,209,1,216,3,192,206,235,17,78,227,89,31,72,19,70,170,188,83,12,152,153,33,142,129,231,240,200,41,244,22,25,13,98,216,214,118,146,181,4,36,4,8,82,99,68,34,33,137,6,94,45,209,235,253,72,144,149,196,237,174,150,250,61,255,56,33,195,226,207,207,9,176,221,204,52,251,69,43,111,203,98,27,35,105,245,119,77,107,43,70,177,1,249,190,170,15,48,251,153,139,55,223,225,137,225,125,58,67,243,116,10,170,142,22,216,165,49,68,133,17,183,99,71,186,158,167},
  {163,197,56,91,63,2,92,241,168,69,3,44,83,89,170,63,64,171,237,231,24,209,250,50,47,66,57,186,230,24,99,127,129,142,214,102,165,229,124,206,198,30,84,40,75,86,255,138,201,113,0,37,35,6,20,56,162,188,181,91,3,252,49,52,174,17,2,96,59,236,40,107,173,112,148,44,111,236,91,115,117,92,129,108,102,70,2,67,143,85,21,185,33,0,95,212,187,0,167,255,3,174,104,112,233,5,70,242,214,196,39,85,135,186,180,14,49,9,30,193,47,165,220,229,214,72,87,241,102,169,232,96,167,106,234,125,193,118,140,18,73,8,67,175,149,111,133,174,174,235,127,42,78,106,75,246,105,204,228,90,127,7,235,221,125,45,197,11,30,187,210,40,98,13,115,215,45,219,27,114,49,80,68,48,145,71,146,65,83,125,151,54,13,194,138,189,29,7,176,197,2,245,97,0,57,56,179,119,5,11,158,74,13,5,45,151,115,210,240,36,203,128,106,221,52,179,46,83,246,217,198,115,24,1,121,46,89,103,56,170,11,148,2,78,70,96,219,94,215,1,65,241,35,178,213,203,175,79,38,35,182,50,242,216,124,58,110,223,176,34,43,103,31,242,179,46,114,43,74,126,171,244,43,59,28,191,84,163,31,154,56,190,48,238,233,61,255,254,192,100,20,214,59,219,221,87,58,140,94,252,200,15,115,2,245,204,176,83,150,228,243,55,125,133,112,159,67,21,185,46,95,103,148,73,234,110,19,129,41,181,170,172,84,4,90,98,1,157,113,43,18,238,24,108,231,115,144,105,79,75,210,91,182,8,75,69,140,127,24,20,167,122,88,110,151,88,28,244,207,169,12,229,62,37,179,235,63,200,170,201,223,36,52,114,254,101,18,140,47,137,84,229,0,227,109,83,183,242,123,205,208,139,189,181,62,253,83,255,49,12,43,233,232,249,193,208,58,93,87,101,20,215,133,132,89,112,136,252,2,15,200,21,204,154,61,170,133,153,184,28,226,68,9,169,132,177,223,162,103,151,166,61,193,167,200,253,94,165,229,75,183,201,123,201,148,171,13,77,222,49,75,1,216,31,221,124,114,222,24,236,61,209,252,141,216,24,108,7,228,63,45,255,251,51,137,107,250,219,145,82,220,44,108,5,52,54,99,63,53,67,126,232,16,71,9,18,235,236,52,220,173,106,217,129,184,161,146,26,109,62,33,184,32,226,181,151,26,34,233,97,125,213,43,219,196,47,203,77,182,155,6,187,62,132,148,167,95,198,54,183,126,37,215,214,203,142,39,52,240,160,62,192,254,35,88,165,245,177,137,144,157,231,245,94,203,137,142,69,101,20,26,18,65,210,190,99,181,109,60,135,77,245,248,122,237,158,235,89,197,39,151,168,157,253,62,9,129,45,238,164,224,127,249,109,186,13,17,59,43,7,251,253,203,1,185,201,172,42,208,22,102,133,7,218,165,44,84,95,37,9,147,229,137,252,68,50,33,172,83,57,32,162,183,76,83,193,134,88,61,210,34,33,32,203,2,215,228,183,164,60,60,202,114,171,25,200,89,167,48,90,188,206,250,120,158,106,134,58,137,73,204,227,120,88,26,101,228,129,104,195,226,154,97,58,157,121,141,190,172,13,190,81,235,150,122,235,250,217,57,24,73,46,60,245,252,211,196,6,233,164,89,100,85,150,194,5,53,158,34,89,201,32,236,144,255,191,41,35,72,65,15,49,178,40,210,241,180,92,145,237,151,225,172,160,156,103,14,207,61,189,41,252,176,77,91,255,33,31,165,62,169,173,10,203,28,95,89,139,66,81,72,149,125,208,245,13,83,176,5,48,121,196,28,173,97,42,115,234,78,49,244,231,104,254,187,59,4,197,156,70,92,53,109,208,82,86,133,73,44,239,254,129,71,97,228,8,7,216,8,52,243,159,39,153,220,22,79,166,33,170,206,105,182,102,135,63,141,44,55,250,180,215,62,86,112,189,242,241,159,110,216,75,32,127,105,37,39,27,100,191,23,199,6,193,130,175,227,251,132,108,9,250,117,69,199,197,220,152,232,60,171,155,121,215,237,215,246,114,207,151,37,50,162,133,189,114,188,203,74,219,170,1,47,101,158,54,198,60,121,11,121,2,175,35,151,213,203,210,151,169,136,33,115,128,190,56,126,122,195,242,58,211,219,202,83,54,49,108,168,151,178,51,254,19,214,214,185,99,74,197,222,97,214,13,140,249,57,152,208,28,85,195,105,148,236,255,211,242,109,200,0,243,253,6,108,14,181,126,33,95,141,215,236,196,132,135,79,185,50,69,54,184,59,193,2,147,237,60,62,11,54,101,197,130,78,93,71,34,166,113,124,245,126,199,176,225,49,117,32,70,197,217,4,188,91,77,146,153,128,173,179,212,55,189,160,187,56,24,84,34,59,233,92,114,20,162,27,59,105,174,28,94,197,135,224,111,94,143,25,155,43,110,50,151,126,100,34,17,70,130,14,155,67,204,138,203,76,26,4,12,230,11,110,40,104,137,189,235,89,189,158,45,177,24,163,139,102,134,161,81,81,249,119,11,71,87,240,191,143,99,72,212,218,136,229,2,55,80,51,116,126,151,10,227,108,83,221,115,7,180,56,22,5,32,77,11,220,217,242,144,50,52,3,251,144,60,182,36,246,15,89,29,64,134,57,190,51,191,215,113,237,78,29,163,145,22,61,119,91,3,107,241,225,43,49,178,150,37,138,136,202,219,113,80,235,63,153,59,109,163,124,136,135,140,102,67,201,212,194,110,201,192,198,88,65,191,72,129,55,233,208,191,39,48,159,110,53,128,19,123,12,124,156,27,140,155,127,77,85,176,3,63,201,23,147,157,28,156,175,233,248,95,173,255,45,65,67,50,109,50,188,166,253,86,81,42,187,32,26,213,64,147,98,250,166,84,46,55,33,180,152,255,111,39,135,180,77,122,79,164,54,214,32,177,103,37,77,238,44,235,16,130,243,143,220,5,10,85,235,76,115,185,214,51,46,195,175,35,172,249,222,13,216,114,109,80,128,161,112,140,245,81,58,43,97,43,68,85,254,229,35,68,210,40,211,62,147,229,179,2,155,200,85,127,53,34,146,57,4,180,93,84,92,75,96,140,183,189,23,85,169,136,101,209,38,97,174,23,234,5,202,38,37,158,199,251,246,25,47,249,217,142,213,223,45,157,94,52,80,27,65,201,73,132,183,137,216,134,226,89,227,151,155,117,170,241,146,201,216,86,38,251,82,62,246,217,115,126,59,140,49,139,175,138,115,231,228,124,118,210,116,206,47,181,147,81,72,237,112,18,144,3,19,13,88,91,3,166,69,245,183,12,184,249,178,1,168,249,218,46,118,139,239,234,154,132,104,0,21,158,49,193,72,118,169,126,85,80,118,94,79,119,109,14,235,132,244,94,72,30,81,81,222,196,14,117,40,40,69,25,245,112,205,241,80,235,114,140,109,111,205,228,218,34,140,8,127,2,71,131,161,49,232,166,106,174,62,253,189,237,170,56,174,39,248,33,53,92,33,211,99,194,188,189,250,48,30,167,38,233,67,91,206,68,164,116,225,185,42,149,203,231,96,200,51,40,226,135,137,192,75,250,153,89,36,20,207,70,159,28,43,120,209},
  {123,50,118,181,62,110,233,142,247,36,207,10,178,227,51,84,56,189,105,70,91,205,122,115,55,37,211,154,174,90,162,120,67,113,175,216,28,54,104,19,209,24,73,147,86,39,86,242,135,153,223,212,48,200,116,41,168,177,138,243,253,149,92,138,146,2,211,218,45,206,211,28,121,31,50,223,220,104,168,26,155,226,11,0,10,94,119,106,187,53,198,206,206,116,182,237,193,2,175,156,141,182,147,235,26,117,61,171,203,54,171,152,33,84,213,14,200,181,169,195,215,78,91,181,219,130,100,98,37,52,224,188,35,67,183,127,251,92,166,10,157,53,30,231,149,193,228,63,33,121,113,226,70,52,164,178,130,61,133,46,79,55,47,1,240,9,90,234,197,43,203,4,240,9,147,85,38,224,248,127,33,105,91,254,118,103,49,37,225,90,235,127,172,158,111,143,26,80,43,160,252,212,101,6,175,138,176,59,163,155,253,135,58,195,84,146,101,183,89,88,136,197,231,47,54,240,82,165,69,39,4,155,125,213,39,224,99,151,167,33,244,70,200,193,110,234,138,4,180,211,62,189,237,39,1,199,180,99,145,222,252,180,183,70,30,243,154,48,170,29,219,156,140,169,214,138,132,184,62,138,125,4,216,185,137,30,36,30,186,178,210,158,64,238,52,160,37,207,252,172,222,196,70,181,201,150,227,110,172,103,201,122,16,23,201,166,165,220,182,17,61,215,153,20,176,62,95,51,4,221,96,190,95,60,167,254,215,4,89,94,248,21,206,178,235,130,134,237,165,121,1,223,22,183,11,122,201,143,109,29,52,237,143,81,138,23,186,108,8,90,183,113,92,114,69,146,145,57,98,63,234,187,180,111,196,113,149,178,106,237,22,147,99,148,28,102,167,147,8,104,71,171,4,233,217,156,240,113,231,83,160,30,157,145,190,189,96,242,166,58,117,249,100,56,197,52,6,133,226,179,237,226,237,214,234,186,137,81,136,253,29,74,194,245,2,48,99,41,243,131,167,242,133,24,68,20,90,120,45,19,183,251,148,43,201,158,18,84,147,240,190,172,96,66,213,77,74,106,102,34,56,117,96,179,212,35,233,82,202,170,115,254,34,90,194,72,200,110,144,94,114,162,99,66,167,255,3,167,253,91,91,180,167,69,31,211,152,173,99,20,221,89,219,106,57,129,121,205,148,214,92,238,82,170,248,151,180,158,26,234,131,214,120,55,206,68,241,234,33,12,105,245,223,170,213,117,207,120,120,240,131,90,240,35,47,151,93,138,64,229,63,202,231,78,65,12,101,236,197,223,198,216,191,75,146,66,191,220,191,181,83,92,14,118,209,86,182,30,52,35,74,128,182,85,77,56,3,18,161,103,105,142,226,243,29,142,165,255,51,18,250,203,244,119,239,5,19,158,35,21,179,102,128,134,23,185,107,66,122,36,155,241,220,36,175,247,153,68,119,51,192,253,97,193,194,0,71,75,62,17,209,220,239,234,216,253,144,229,196,54,183,31,134,232,124,136,25,103,178,33,247,199,126,42,48,207,128,140,171,136,233,104,174,153,154,140,124,67,45,34,90,75,2,243,224,159,205,87,65,38,167,158,233,181,51,95,230,0,108,6,97,30,106,207,132,228,10,159,40,229,181,20,9,18,67,253,255,61,205,55,122,119,13,126,63,50,253,115,86,59,81,128,209,240,128,9,41,168,106,146,37,171,165,4,118,72,109,51,138,8,134,108,72,65,111,3,96,43,203,40,109,134,153,7,65,43,83,161,205,72,247,143,103,247,148,255,250,9,69,39,19,140,92,10,20,248,93,219,149,189,180,182,141,133,155,52,192,229,33,151,202,113,151,110,188,61,139,253,60,191,184,234,221,36,87,116,202,38,242,12,41,205,218,172,106,129,217,89,148,29,251,244,18,114,151,216,231,89,224,156,72,81,1,168,13,174,207,79,249,199,148,115,115,129,89,224,180,32,47,152,167,93,1,64,44,154,31,75,161,188,253,220,86,112,17,122,123,126,18,215,117,250,99,232,45,204,201,153,32,0,94,168,248,239,21,191,139,174,100,97,22,36,85,181,68,226,63,163,58,155,209,112,119,141,46,75,99,44,67,206,164,200,41,129,114,40,103,0,184,75,186,76,72,147,243,41,190,6,209,245,226,219,111,170,244,224,10,224,178,235,117,183,154,204,75,180,234,173,24,78,195,64,174,72,110,48,59,89,242,11,175,160,99,48,205,117,11,207,180,155,5,146,132,48,208,89,168,32,147,226,183,228,52,85,144,20,180,65,121,42,150,157,21,180,68,167,82,241,166,239,181,86,128,227,95,9,138,73,194,196,229,224,251,122,54,35,51,29,179,21,101,9,40,194,186,255,90,180,158,159,102,118,54,55,106,212,185,173,117,28,222,61,151,16,216,227,157,73,237,142,28,220,247,33,92,83,189,29,14,115,214,7,242,24,22,57,247,129,174,203,160,143,100,134,76,79,192,125,254,24,168,155,100,75,230,155,53,237,81,7,193,146,213,235,23,129,93,61,170,72,204,16,82,107,69,47,212,199,14,204,248,63,255,30,205,121,99,232,81,220,150,102,89,239,71,199,163,22,215,122,77,182,170,84,56,59,180,154,194,29,121,108,65,206,92,38,146,240,251,174,163,176,238,8,123,49,192,76,83,136,166,77,225,37,83,28,211,113,114,35,152,237,4,19,24,32,159,182,23,181,239,108,139,102,140,209,13,143,189,215,58,241,156,142,17,190,194,99,240,127,247,232,130,59,139,134,64,95,237,94,38,176,164,220,183,33,226,187,74,238,2,249,140,152,228,170,64,67,32,241,233,51,9,70,38,153,166,123,238,57,78,68,122,210,188,76,26,241,238,131,130,247,213,50,133,142,14,54,162,64,21,234,125,141,24,123,128,224,186,170,79,17,165,130,193,166,184,215,237,147,106,119,164,26,101,196,59,107,239,214,37,25,75,130,122,103,208,115,130,2,3,215,245,177,102,30,136,33,208,113,51,76,26,145,212,77,14,52,191,109,158,9,120,66,109,164,69,179,75,3,134,204,192,62,154,165,209,5,85,153,90,82,160,199,12,31,220,172,126,209,198,21,232,27,233,174,68,232,138,208,9,84,246,233,168,4,57,224,179,114,183,33,130,242,240,229,49,119,95,195,171,122,178,78,19,42,180,1,194,68,160,216,70,117,59,164,33,0,133,3,112,235,5,5,150,97,73,108,93,73,227,148,46,224,75,204,48,88,79,100,178,157,125,204,42,173,174,13,183,106,193,115,219,78,222,244,32,186,190,244,237,59,166,37,124,142,63,249,93,60,214,153,45,174,42,170,163,16,151,32,166,182,164,95,159,158,22,52,183,234,122,78,247,5,120,241,138,38,225,6,149,63,41,231,249,15,23,194,55,146,223,119,187,144,26,102,196,142,4,144,128,220,248,2,127,62,120,155,219,51,30,12,94,65,12,79,235,209,11,109,93,73,61,68,244,58,254,186,161,137,146,95,128,101,245,121,204,152,73,213,119,18,107,68,238,211,217,223,47,78,244,190,127,150,178,215,87,188,208,144,13,127,54,191,199,176,252,105,144,242,107,136,241,218,133,180,194,201,138,220,188,18,3,127,203,158,138,211,218,217,138,142,156},
  {170,108,107,60,131,132,128,43,44,250,95,132,116,16,223,162,161,55,237,52,228,212,14,86,143,141,153,11,116,18,94,5,119,140,186,127,56,128,64,207,136,149,69,156,55,117,209,72,120,224,85,78,213,80,103,86,32,107,177,19,123,148,174,169,181,51,140,79,174,25,217,184,232,22,225,117,196,58,180,13,23,94,185,90,2,197,50,77,31,111,218,59,131,220,231,152,162,5,21,226,117,119,83,42,219,18,16,19,42,25,236,135,111,16,241,132,108,157,184,229,174,98,21,124,198,11,112,173,82,27,52,120,40,110,146,83,56,191,111,42,15,154,84,140,98,167,137,249,138,161,207,77,220,173,228,181,180,186,83,222,22,197,175,235,238,14,58,158,1,183,187,236,64,183,27,208,217,87,121,255,150,216,124,215,106,115,107,213,169,153,52,166,160,195,195,1,7,43,0,173,22,195,161,142,225,233,254,187,125,212,128,152,35,245,19,202,192,21,186,68,20,85,166,63,110,226,232,183,164,192,26,239,23,82,27,177,222,240,21,250,30,201,248,218,82,197,170,4,124,174,251,41,111,65,120,66,28,116,160,238,111,8,187,253,137,40,181,39,170,68,192,105,203,94,207,202,60,206,220,27,134,228,211,223,121,158,211,17,248,170,125,214,60,217,236,159,242,10,220,74,145,120,42,94,249,222,99,173,189,229,195,136,128,149,55,133,128,128,244,196,95,234,189,120,104,52,95,189,24,201,106,146,189,129,119,190,178,70,220,158,49,77,103,173,213,160,238,130,255,219,208,241,190,18,206,4,167,5,88,243,144,167,188,101,214,207,98,28,0,161,64,230,204,229,177,122,162,61,81,184,124,175,19,216,183,41,37,84,140,52,79,25,239,55,57,38,34,79,57,235,65,156,130,199,93,28,154,151,46,50,173,7,30,98,182,188,92,12,155,248,85,155,137,178,148,133,104,124,164,78,85,92,141,34,28,180,246,187,77,54,36,13,188,225,255,197,143,21,161,120,56,74,137,60,8,55,28,95,175,237,241,203,220,20,96,128,47,74,64,55,186,172,168,214,101,63,147,221,43,90,249,17,229,118,141,176,18,109,71,41,174,136,30,27,43,182,72,238,51,89,74,116,50,170,155,130,209,43,13,138,123,235,17,130,85,55,220,188,113,35,222,103,234,63,200,255,21,223,99,111,214,244,178,35,67,78,52,99,113,168,83,153,147,30,170,107,51,82,17,57,215,82,45,141,252,75,168,43,113,179,107,72,207,131,69,59,207,17,122,172,110,29,235,103,169,46,166,185,100,233,138,167,215,149,170,238,242,26,123,172,214,2,68,128,164,189,24,20,244,142,170,90,233,36,234,156,3,199,69,119,134,24,197,219,226,166,75,197,97,193,19,170,39,16,17,36,10,116,240,170,129,34,193,220,214,22,32,109,209,31,200,154,160,19,42,100,60,143,198,90,115,91,91,52,234,107,244,99,59,45,161,181,13,255,45,78,33,209,73,138,181,184,103,197,226,123,93,182,83,18,199,74,65,220,62,150,13,110,197,3,55,228,221,98,195,185,55,57,165,174,29,74,210,144,245,36,252,47,205,163,67,80,229,104,252,0,94,38,142,216,66,124,68,234,91,147,180,11,218,132,38,57,36,228,90,218,198,71,145,20,225,122,247,215,100,174,71,41,150,252,83,179,53,233,216,201,137,236,255,104,62,44,35,248,95,87,120,242,154,183,110,58,109,194,104,117,114,129,32,101,156,220,155,20,84,86,182,139,207,108,15,222,72,38,53,236,57,206,56,42,231,139,7,161,142,9,95,45,198,123,230,73,64,221,191,213,87,17,124,165,155,164,219,58,70,177,251,160,8,89,193,6,71,165,57,204,51,169,165,61,185,67,153,11,185,253,233,167,210,118,67,168,239,50,155,136,58,173,148,221,239,154,158,244,39,194,46,239,45,145,195,101,93,63,165,116,159,73,229,51,6,35,129,188,250,166,51,54,92,118,255,94,236,60,168,92,143,207,209,173,206,118,9,50,15,215,81,99,154,176,151,124,89,165,165,20,83,147,139,99,210,191,32,127,205,91,225,1,192,38,167,223,237,80,254,80,53,103,161,143,79,239,248,92,55,23,153,179,33,24,152,138,250,93,0,250,67,143,105,160,173,237,117,163,82,165,195,69,47,180,234,242,228,38,95,161,33,136,71,32,51,34,24,124,197,192,131,195,1,63,96,26,146,133,49,198,33,228,237,11,165,243,58,25,69,170,28,230,131,46,196,111,205,19,157,154,144,209,172,244,52,243,75,220,213,55,20,81,30,17,231,82,5,55,16,205,151,125,247,191,47,239,35,97,17,155,22,209,169,210,33,26,6,244,129,179,227,7,187,27,116,221,240,130,194,225,67,215,239,139,134,239,0,220,248,94,91,154,222,223,139,47,58,150,32,241,37,132,171,203,175,59,225,137,242,56,69,10,173,142,248,83,10,76,180,64,208,215,89,115,53,68,186,229,248,62,157,244,116,195,170,81,60,241,225,162,191,156,29,41,211,36,207,150,140,17,3,146,157,109,93,224,124,74,195,219,1,228,217,186,175,212,227,120,255,118,22,98,182,82,229,25,98,165,185,230,170,21,229,152,74,175,170,86,243,23,226,117,36,165,80,77,239,34,255,123,85,126,156,185,62,67,78,102,55,76,8,161,223,30,73,72,95,113,105,171,248,219,177,23,159,93,21,250,204,63,11,185,212,80,50,27,244,46,12,251,237,87,9,25,255,41,129,182,209,104,56,230,177,234,105,177,214,95,84,248,198,79,114,88,45,175,70,246,116,31,177,211,59,0,9,189,53,222,46,20,180,155,154,136,121,113,43,38,190,77,64,183,91,216,89,205,10,183,133,255,250,74,219,196,61,111,72,181,102,67,113,149,219,95,194,213,103,39,24,14,232,89,42,128,81,205,246,139,116,187,251,121,7,50,215,144,107,229,174,249,186,178,14,88,240,198,87,31,122,75,252,211,145,132,20,159,63,178,166,206,102,31,69,12,200,17,170,22,115,87,36,43,201,94,122,241,7,209,113,157,54,173,48,51,126,218,234,182,191,189,202,96,236,31,118,189,19,68,167,54,173,168,122,157,246,231,98,154,33,194,109,12,3,254,119,206,40,236,114,226,108,19,167,127,121,91,123,78,228,214,159,105,236,80,209,230,128,178,205,210,60,125,143,13,101,54,156,25,106,158,231,94,87,203,142,112,144,13,81,198,226,214,220,95,56,117,234,57,25,7,74,32,197,28,239,184,7,173,116,27,151,9,180,130,201,232,4,251,172,53,118,154,67,135,53,110,37,184,142,169,116,105,69,14,143,219,17,52,237,119,32,94,51,223,210,214,227,212,42,77,94,9,91,201,10,58,45,80,177,76,29,76,244,189,218,190,107,138,18,40,218,224,193,71,54,43,209,254,193,80,75,50,7,69,189,156,98,103,176,127,223,217,184,246,97,252,132,130,12,52,8,65,43,193,194,174,87,4,237,79,172,143,110,200,116,101,93,38,135,54,176,121,214,94,1,120,177,5,145,97,47,154,121,119,157,74,118,123,122,229,1,88,203,75,64,139,81,94,189,220,7,101,168,0,28,82,248,33,217,55,6,97,161,158,64,196,107},
} ;

static void test_decode_1013x7177_impl(long long impl)
{
  unsigned char *x = test_decode_1013x7177_x;
  unsigned char *s = test_decode_1013x7177_s;
  unsigned char *x2 = test_decode_1013x7177_x2;
  unsigned char *s2 = test_decode_1013x7177_s2;
  long long xwords = crypto_decode_ITEMS;
  long long xlen;
  long long slen = crypto_decode_STRBYTES;

  if (targeti && strcmp(targeti,".") && strcmp(targeti,ntruprime_dispatch_decode_1013x7177_implementation(impl))) return;
  if (targetn && atol(targetn) != impl) return;
  if (impl >= 0) {
    crypto_decode = ntruprime_dispatch_decode_1013x7177(impl);
    printf("decode_1013x7177 %lld implementation %s compiler %s\n",impl,ntruprime_dispatch_decode_1013x7177_implementation(impl),ntruprime_dispatch_decode_1013x7177_compiler(impl));
  } else {
    crypto_decode = ntruprime_decode_1013x7177;
    printf("decode_1013x7177 selected implementation %s compiler %s\n",ntruprime_decode_1013x7177_implementation(),ntruprime_decode_1013x7177_compiler());
  }
  for (long long checksumbig = 0;checksumbig < 2;++checksumbig) {
    long long loops = checksumbig ? 4096 : 1024;

    checksum_clear();

    for (long long loop = 0;loop < loops;++loop) {
      xlen = xwords*crypto_decode_ITEMBYTES;

      output_prepare(x2,x,xlen);
      input_prepare(s2,s,slen);
      secret(s,slen);
      crypto_decode(x,s);
      public(s,slen);
      public(x,xlen);
      endianness(x,xwords,crypto_decode_ITEMBYTES);
      checksum(x,xlen);
      output_compare(x2,x,xlen,"crypto_decode");
      input_compare(s2,s,slen,"crypto_decode");

      double_canary(x2,x,xlen);
      double_canary(s2,s,slen);
      secret(s2,slen);
      crypto_decode(x2,s2);
      public(s2,slen);
      public(x2,xlen);
      endianness(x2,xwords,crypto_decode_ITEMBYTES);
      if (memcmp(x2,x,xlen) != 0) fail("failure: crypto_decode is nondeterministic\n");
    }
    checksum_expected(decode_1013x7177_checksums[checksumbig]);
  }
  for (long long precomp = 0;precomp < precomputed_decode_1013x7177_NUM;++precomp) {
    output_prepare(x2,x,crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
    input_prepare(s2,s,crypto_decode_STRBYTES);
    memcpy(s,precomputed_decode_1013x7177_s[precomp],crypto_decode_STRBYTES);
    memcpy(s2,precomputed_decode_1013x7177_s[precomp],crypto_decode_STRBYTES);
    crypto_decode(x,s);
    if (memcmp(x,precomputed_decode_1013x7177_x[precomp],crypto_decode_ITEMS*crypto_decode_ITEMBYTES)) {
      fail("failure: crypto_decode fails precomputed test vectors\n");
      printf("expected x: ");
      for (long long pos = 0;pos < crypto_decode_ITEMS*crypto_decode_ITEMBYTES;++pos) printf("%02x",((unsigned char *) precomputed_decode_1013x7177_x[precomp])[pos]);
      printf("\n");
      printf("received x: ");
      for (long long pos = 0;pos < crypto_decode_ITEMS*crypto_decode_ITEMBYTES;++pos) printf("%02x",x[pos]);
      printf("\n");
    }
    output_compare(x2,x,crypto_decode_ITEMS*crypto_decode_ITEMBYTES,"crypto_decode");
    input_compare(s2,s,crypto_decode_STRBYTES,"crypto_decode");
  }
}

void test_decode_1013x7177(void)
{
  long long maxalloc = 0;
  if (targeto && strcmp(targeto,"decode")) return;
  if (targetp && strcmp(targetp,"1013x7177")) return;
  storage_decode_1013x7177_x = callocplus(crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
  test_decode_1013x7177_x = aligned(storage_decode_1013x7177_x,crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
  if (crypto_decode_ITEMS*crypto_decode_ITEMBYTES > maxalloc) maxalloc = crypto_decode_ITEMS*crypto_decode_ITEMBYTES;
  storage_decode_1013x7177_s = callocplus(crypto_decode_STRBYTES);
  test_decode_1013x7177_s = aligned(storage_decode_1013x7177_s,crypto_decode_STRBYTES);
  if (crypto_decode_STRBYTES > maxalloc) maxalloc = crypto_decode_STRBYTES;
  storage_decode_1013x7177_x2 = callocplus(maxalloc);
  test_decode_1013x7177_x2 = aligned(storage_decode_1013x7177_x2,crypto_decode_ITEMS*crypto_decode_ITEMBYTES);
  storage_decode_1013x7177_s2 = callocplus(maxalloc);
  test_decode_1013x7177_s2 = aligned(storage_decode_1013x7177_s2,crypto_decode_STRBYTES);

  for (long long offset = 0;offset < 1;++offset) {
    if (targetoffset && atol(targetoffset) != offset) continue;
    if (offset && valgrind) break;
    printf("decode_1013x7177 offset %lld\n",offset);
    for (long long impl = -1;impl < ntruprime_numimpl_decode_1013x7177();++impl)
      forked(test_decode_1013x7177_impl,impl);
    ++test_decode_1013x7177_x;
    ++test_decode_1013x7177_s;
    ++test_decode_1013x7177_x2;
    ++test_decode_1013x7177_s2;
  }
  free(storage_decode_1013x7177_s2);
  free(storage_decode_1013x7177_x2);
  free(storage_decode_1013x7177_s);
  free(storage_decode_1013x7177_x);
}
#undef crypto_decode_STRBYTES
#undef crypto_decode_ITEMS
#undef crypto_decode_ITEMBYTES

