/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.netbeans.modules.maven.hints.pom.spi;

import java.util.List;
import javax.swing.JComponent;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.spi.editor.hints.ErrorDescription;

/**
 *
 * @author mkleint
 */
public interface POMErrorFixProvider extends POMErrorFixBase {

    /**
     *
     * @param model
     * @param prj can be null
     * @return
     */
    List<ErrorDescription> getErrorsForDocument(POMModel model, Project prj);
    
    /**
     * Returns the <code>POMErrorFixProvider</code>'s saved value for the
     * specific key.
     *
     * @param customizer the customizer returned from {@link POMErrorFixBase#getCustomizer(Preferences)} method
     * @param key the key for which the saved value is needed
     * @return the saved value or null
     */
    public String getSavedValue(JComponent customizer, String key);
    
    /**
     * Called when the user presses the Cancel button in the options window.
     */
    public void cancel();
    
}
