# Stefan Achatz 2012
#
# Tries to find libgtk2 and sets following variables according to found capabilities:
#
# GTK2_FOUND
# GTK2_INCLUDE_DIRS
# GTK2_LIBRARIES

FIND_PACKAGE(PkgConfig)
PKG_CHECK_MODULES(PKG_GTK2 gtk+-2.0)

FIND_PATH(GTK2_INCLUDE_DIRS gtk/gtk.h
  HINTS
    ${PKG_GTK2_INCLUDE_DIRS}
    ${PKG_GTK2_INCLUDEDIR}
  PATH_SUFFIXES gtk-2.0
)

FIND_LIBRARY(GTK2_LIBRARIES gtk-x11-2.0
  HINTS ${PKG_GTK2_LIBRARY_DIRS}
)

IF(GTK2_LIBRARIES AND GTK2_INCLUDE_DIRS)
  SET(GTK2_FOUND true)
ENDIF()

IF(GTK2_FIND_REQUIRED AND NOT GTK2_FOUND)
  MESSAGE(FATAL_ERROR "Could not find GTK2")
ENDIF()
