!{\src2tex{textfont=tt}}
!!****m* etsf_split/etsf_io_split_copy
!! NAME
!!  etsf_io_split_copy
!!
!! FUNCTION
!!    As for etsf_io_electrons_copy() for instance, it copy all values from split
!!    definitions of file @ncid_from to file @ncid_to. Arrays are copied only if
!!    their dimensions are neither etsf_no_dimension (see ETSF_IO_CONSTANTS) nor
!!    the associated full dimension value. The arrays in @ncid_to must already be
!!    defined, use etsf_io_split_def() to do it.
!!
!! COPYRIGHT
!!  Copyright (C) 2006-2010 (Damien Caliste)
!!  This file is distributed under the terms of the
!!  GNU Lesser General Public License, see the COPYING file
!!  or http://www.gnu.org/copyleft/lesser.txt .
!!
!! INPUTS
!! * ncid_to = 
!!     integer returned by an 'open' NetCDF call. This id must have write access
!!     granted. It will be modified by the routine. The file must be in write
!!     mode (see etsf_io_low_set_write_mode()).
!! * ncid_from = 
!!     integer returned by an 'open' NetCDF call. This id must have read access
!!     granted. It will be left untouched.
!! * dims <type(etsf_dims)> = 
!!     the special split arrays are copied if their corresponding dimension, read
!!     from @dims, are different from etsf_no_dimension and different from their
!!     non-split value.
!! OUTPUT
!! * lstat = 
!!     return .true. if all the actions succeed, if not the status
!!     of the file is undefined.
!! * error_data <type(etsf_io_low_error)> = 
!!     contains the details of the error is @lstat is false.
!!
!! NOTES
!!  This file has been automatically generated by the autogen_subroutines.py
!!  script. Any change you would bring to it will systematically be
!!  overwritten.
!!
!! SOURCE
subroutine etsf_io_split_copy(ncid_to, ncid_from, dims, lstat, error_data)

  !Arguments ------------------------------------
  integer, intent(in) :: ncid_to
  integer, intent(in) :: ncid_from
  type(etsf_dims), intent(in) :: dims
  logical, intent(out) :: lstat
  type(etsf_io_low_error), intent(out) :: error_data

  !Local variables-------------------------------
  character(len = *), parameter :: my_name = 'etsf_io_split_copy'
  integer,allocatable :: split_array(:)


  ! *************************************************************************

!DEBUG
!write (*,*) 'etsf_io_split_copy : enter'
!ENDDEBUG

  if (dims%my_number_of_kpoints /= etsf_no_dimension .and. &
    & dims%my_number_of_kpoints /= dims%number_of_kpoints) then 
    allocate(split_array(dims%my_number_of_kpoints))
    call etsf_io_low_read_var(ncid_from, "my_kpoints", &
                            & split_array, lstat, error_data = error_data)
    if (.not. lstat) then
      deallocate(split_array)
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
    call etsf_io_low_write_var(ncid_to, "my_kpoints", &
                             & split_array, lstat, error_data = error_data)
    if (.not. lstat) then
      deallocate(split_array)
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
    deallocate(split_array)
  end if
  if (dims%my_number_of_grid_points_vect3 /= etsf_no_dimension .and. &
    & dims%my_number_of_grid_points_vect3 /= dims%number_of_grid_points_vector3) then 
    allocate(split_array(dims%my_number_of_grid_points_vect3))
    call etsf_io_low_read_var(ncid_from, "my_grid_points_vector3", &
                            & split_array, lstat, error_data = error_data)
    if (.not. lstat) then
      deallocate(split_array)
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
    call etsf_io_low_write_var(ncid_to, "my_grid_points_vector3", &
                             & split_array, lstat, error_data = error_data)
    if (.not. lstat) then
      deallocate(split_array)
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
    deallocate(split_array)
  end if
  if (dims%my_number_of_spins /= etsf_no_dimension .and. &
    & dims%my_number_of_spins /= dims%number_of_spins) then 
    allocate(split_array(dims%my_number_of_spins))
    call etsf_io_low_read_var(ncid_from, "my_spins", &
                            & split_array, lstat, error_data = error_data)
    if (.not. lstat) then
      deallocate(split_array)
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
    call etsf_io_low_write_var(ncid_to, "my_spins", &
                             & split_array, lstat, error_data = error_data)
    if (.not. lstat) then
      deallocate(split_array)
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
    deallocate(split_array)
  end if
  if (dims%my_number_of_grid_points_vect1 /= etsf_no_dimension .and. &
    & dims%my_number_of_grid_points_vect1 /= dims%number_of_grid_points_vector1) then 
    allocate(split_array(dims%my_number_of_grid_points_vect1))
    call etsf_io_low_read_var(ncid_from, "my_grid_points_vector1", &
                            & split_array, lstat, error_data = error_data)
    if (.not. lstat) then
      deallocate(split_array)
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
    call etsf_io_low_write_var(ncid_to, "my_grid_points_vector1", &
                             & split_array, lstat, error_data = error_data)
    if (.not. lstat) then
      deallocate(split_array)
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
    deallocate(split_array)
  end if
  if (dims%my_number_of_grid_points_vect2 /= etsf_no_dimension .and. &
    & dims%my_number_of_grid_points_vect2 /= dims%number_of_grid_points_vector2) then 
    allocate(split_array(dims%my_number_of_grid_points_vect2))
    call etsf_io_low_read_var(ncid_from, "my_grid_points_vector2", &
                            & split_array, lstat, error_data = error_data)
    if (.not. lstat) then
      deallocate(split_array)
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
    call etsf_io_low_write_var(ncid_to, "my_grid_points_vector2", &
                             & split_array, lstat, error_data = error_data)
    if (.not. lstat) then
      deallocate(split_array)
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
    deallocate(split_array)
  end if
  if (dims%my_max_number_of_coefficients /= etsf_no_dimension .and. &
    & dims%my_max_number_of_coefficients /= dims%max_number_of_coefficients) then 
    allocate(split_array(dims%my_max_number_of_coefficients))
    call etsf_io_low_read_var(ncid_from, "my_coefficients", &
                            & split_array, lstat, error_data = error_data)
    if (.not. lstat) then
      deallocate(split_array)
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
    call etsf_io_low_write_var(ncid_to, "my_coefficients", &
                             & split_array, lstat, error_data = error_data)
    if (.not. lstat) then
      deallocate(split_array)
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
    deallocate(split_array)
  end if
  if (dims%my_number_of_components /= etsf_no_dimension .and. &
    & dims%my_number_of_components /= dims%number_of_components) then 
    allocate(split_array(dims%my_number_of_components))
    call etsf_io_low_read_var(ncid_from, "my_components", &
                            & split_array, lstat, error_data = error_data)
    if (.not. lstat) then
      deallocate(split_array)
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
    call etsf_io_low_write_var(ncid_to, "my_components", &
                             & split_array, lstat, error_data = error_data)
    if (.not. lstat) then
      deallocate(split_array)
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
    deallocate(split_array)
  end if
  if (dims%my_max_number_of_states /= etsf_no_dimension .and. &
    & dims%my_max_number_of_states /= dims%max_number_of_states) then 
    allocate(split_array(dims%my_max_number_of_states))
    call etsf_io_low_read_var(ncid_from, "my_states", &
                            & split_array, lstat, error_data = error_data)
    if (.not. lstat) then
      deallocate(split_array)
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
    call etsf_io_low_write_var(ncid_to, "my_states", &
                             & split_array, lstat, error_data = error_data)
    if (.not. lstat) then
      deallocate(split_array)
      call etsf_io_low_error_update(error_data, my_name)
      return
    end if
    deallocate(split_array)
  end if


!DEBUG
!write (*,*) 'etsf_io_split_copy : exit'
!ENDDEBUG

end subroutine etsf_io_split_copy
!!***
