!{\src2tex{textfont=tt}}
!!****m* etsf_io_data_group/etsf_io_data_copy
!! NAME
!!  etsf_io_data_copy
!!
!! FUNCTION
!!    High-level routine that copy all ETSF variables from one file to another.
!!
!! COPYRIGHT
!!  Copyright (C) 2006-2010 (Damien Caliste)
!!  This file is distributed under the terms of the
!!  GNU Lesser General Public License, see the COPYING file
!!  or http://www.gnu.org/copyleft/lesser.txt .
!!
!! INPUTS
!! * dest_file = 
!!     the path to the file to be written.
!! * source_file = 
!!     A path to the file from which copy the ETSF variables.
!! * dims <type(etsf_dims)> = 
!!     these dimensions correspond to the source_file ones and are used to allocate
!!     temporary arrays in memory during the copy.
!! * split <type(etsf_split)> = (optional) 
!!     if this argument is given, the values in the split definition (e.g. my_kpoints)
!!     are used to put the data in the destination file in a bigger array at the right
!!     placed.
!! OUTPUT
!! * lstat = 
!!     return .true. if all the actions succeed, if not the status
!!     of the file is undefined.
!! * error_data <type(etsf_io_low_error)> = 
!!     contains the details of the error is @lstat is false.
!!
!! NOTES
!!  This file has been automatically generated by the autogen_subroutines.py
!!  script. Any change you would bring to it will systematically be
!!  overwritten.
!!
!! SOURCE
subroutine etsf_io_data_copy(dest_file, source_file, dims, lstat, error_data, &
  & split)

  !Arguments ------------------------------------
  character(len=*), intent(in) :: dest_file
  character(len=*), intent(in) :: source_file
  type(etsf_dims), intent(in) :: dims
  logical, intent(out) :: lstat
  type(etsf_io_low_error), intent(out) :: error_data
  type(etsf_split), optional, intent(in) :: split
  !Local variables-------------------------------
  character(len=*),parameter :: my_name = 'etsf_io_data_copy'
  integer :: ncid, i
  type(etsf_split) :: my_split
  integer :: ncid_to


  ! *************************************************************************

!DEBUG
!write (*,*) 'etsf_io_data_copy : enter'
!ENDDEBUG

  lstat = .false.
  
  ! Open destination file for writing
  call etsf_io_low_open_modify(ncid_to, trim(dest_file), &
    & lstat, error_data = error_data)
  if (.not. lstat) then
    call etsf_io_low_error_update(error_data, my_name)
    return
  end if
  ! Open source file for reading
  call etsf_io_low_open_read(ncid, trim(source_file), &
    & lstat, error_data = error_data)
  if (.not. lstat) then
    call etsf_io_low_error_update(error_data, my_name)
    return
  end if
  
  ! We copy all the global attributes (ETSF and non-ETSF).
  call etsf_io_low_copy_all_att(ncid, ncid_to, etsf_io_low_global_att, etsf_io_low_global_att, &
                              & lstat, error_data = error_data)
  if (.not. lstat) then
    call etsf_io_low_error_update(error_data, my_name)
    return
  end if
  
  ! We switch to write mode.
  call etsf_io_low_set_write_mode(ncid_to, lstat, error_data = error_data)
  if (.not. lstat) then
    call etsf_io_low_error_update(error_data, my_name)
    return
  end if
  if (present(split)) then
    call etsf_io_gwdata_copy(ncid_to, ncid, dims, &
      & lstat, error_data, split)
  else
    call etsf_io_gwdata_copy(ncid_to, ncid, dims, &
      & lstat, error_data)
  end if
  if (.not. lstat) then
    call etsf_io_low_error_update(error_data, my_name)
    return
  end if
  if (present(split)) then
    call etsf_io_geometry_copy(ncid_to, ncid, dims, &
      & lstat, error_data, split)
  else
    call etsf_io_geometry_copy(ncid_to, ncid, dims, &
      & lstat, error_data)
  end if
  if (.not. lstat) then
    call etsf_io_low_error_update(error_data, my_name)
    return
  end if
  if (present(split)) then
    call etsf_io_kpoints_copy(ncid_to, ncid, dims, &
      & lstat, error_data, split)
  else
    call etsf_io_kpoints_copy(ncid_to, ncid, dims, &
      & lstat, error_data)
  end if
  if (.not. lstat) then
    call etsf_io_low_error_update(error_data, my_name)
    return
  end if
  if (present(split)) then
    call etsf_io_basisdata_copy(ncid_to, ncid, dims, &
      & lstat, error_data, split)
  else
    call etsf_io_basisdata_copy(ncid_to, ncid, dims, &
      & lstat, error_data)
  end if
  if (.not. lstat) then
    call etsf_io_low_error_update(error_data, my_name)
    return
  end if
  if (present(split)) then
    call etsf_io_electrons_copy(ncid_to, ncid, dims, &
      & lstat, error_data, split)
  else
    call etsf_io_electrons_copy(ncid_to, ncid, dims, &
      & lstat, error_data)
  end if
  if (.not. lstat) then
    call etsf_io_low_error_update(error_data, my_name)
    return
  end if
  if (present(split)) then
    call etsf_io_main_copy(ncid_to, ncid, dims, &
      & lstat, error_data, split)
  else
    call etsf_io_main_copy(ncid_to, ncid, dims, &
      & lstat, error_data)
  end if
  if (.not. lstat) then
    call etsf_io_low_error_update(error_data, my_name)
    return
  end if
  if (present(split)) then
    call etsf_io_dielectric_copy(ncid_to, ncid, dims, &
      & lstat, error_data, split)
  else
    call etsf_io_dielectric_copy(ncid_to, ncid, dims, &
      & lstat, error_data)
  end if
  if (.not. lstat) then
    call etsf_io_low_error_update(error_data, my_name)
    return
  end if
  !Close files.
  call etsf_io_low_close(ncid_to, lstat, error_data = error_data)
  if (.not. lstat) then
    call etsf_io_low_error_update(error_data, my_name)
    return
  end if
  call etsf_io_low_close(ncid, lstat, error_data = error_data)
  if (.not. lstat) then
    call etsf_io_low_error_update(error_data, my_name)
    return
  end if


!DEBUG
!write (*,*) 'etsf_io_data_copy : exit'
!ENDDEBUG

end subroutine etsf_io_data_copy
!!***
