/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.draw;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.emboss.jemboss.draw.DNADraw;
import org.emboss.jemboss.gui.form.TextFieldInt;

public class LineAttribute
extends JPanel {
    private Hashtable lineAttr = new Hashtable();
    private TextFieldInt start;
    private TextFieldInt end;
    private TextFieldInt lineSize;

    public LineAttribute(final DNADraw draw) {
        Dimension d = new Dimension(100, 25);
        Box bdown = Box.createVerticalBox();
        bdown.add(Box.createVerticalStrut(4));
        Box bacross = Box.createHorizontalBox();
        ButtonGroup group = new ButtonGroup();
        final JRadioButton jcirc = new JRadioButton("Circular");
        jcirc.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LineAttribute.this.lineAttr.put("circular", new Boolean(jcirc.isSelected()));
                if (draw != null) {
                    draw.repaint();
                }
            }
        });
        group.add(jcirc);
        JRadioButton jline = new JRadioButton("Linear");
        jline.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LineAttribute.this.lineAttr.put("circular", new Boolean(jcirc.isSelected()));
                if (draw != null) {
                    draw.repaint();
                }
            }
        });
        group.add(jline);
        if (draw.isCircular()) {
            jcirc.setSelected(true);
        } else {
            jline.setSelected(true);
        }
        this.lineAttr.put("circular", new Boolean(draw.isCircular()));
        bacross.add(jcirc);
        bacross.add(jline);
        bacross.add(Box.createHorizontalGlue());
        bdown.add(bacross);
        bdown.add(Box.createVerticalStrut(4));
        bacross = Box.createHorizontalBox();
        this.start = new TextFieldInt();
        this.start.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int s = LineAttribute.this.getStart();
                LineAttribute.this.lineAttr.put("start", new Integer(s));
                draw.setStart(s);
                if (draw != null) {
                    draw.repaint();
                }
            }
        });
        this.start.setValue(draw.getStart());
        this.start.setPreferredSize(d);
        this.start.setMaximumSize(d);
        bacross.add(new JLabel(" start:"));
        bacross.add(this.start);
        bacross.add(Box.createHorizontalGlue());
        bdown.add(bacross);
        bacross = Box.createHorizontalBox();
        this.end = new TextFieldInt();
        this.end.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                int e = LineAttribute.this.getEnd();
                LineAttribute.this.lineAttr.put("end", new Integer(e));
                draw.setEnd(e);
                if (draw != null) {
                    draw.repaint();
                }
            }
        });
        this.end.setPreferredSize(d);
        this.end.setMaximumSize(d);
        this.end.setValue(draw.getEnd());
        bacross.add(new JLabel(" stop:"));
        bacross.add(this.end);
        bacross.add(Box.createHorizontalGlue());
        bdown.add(bacross);
        bacross = Box.createHorizontalBox();
        this.lineSize = new TextFieldInt();
        int lsize = 5;
        if (draw != null) {
            lsize = draw.getLineSize();
        }
        this.lineAttr.put("lsize", new Integer(lsize));
        final JSlider slider = new JSlider(1, 20, lsize);
        this.lineSize.setColumns(3);
        this.lineSize.setValue(lsize);
        bacross.add(new JLabel(" line width:"));
        bacross.add(this.lineSize);
        bacross.add(Box.createHorizontalGlue());
        bdown.add(bacross);
        this.lineSize.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int size = LineAttribute.this.lineSize.getValue();
                slider.setValue(size);
                LineAttribute.this.lineAttr.put("lsize", new Integer(size));
                if (draw != null) {
                    draw.setLineSize(size);
                    draw.repaint();
                }
            }
        });
        bacross = Box.createHorizontalBox();
        slider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                int size = slider.getValue();
                LineAttribute.this.lineSize.setValue(size);
                LineAttribute.this.lineAttr.put("lsize", new Integer(size));
                if (draw != null) {
                    draw.setLineSize(size);
                    draw.repaint();
                }
            }
        });
        bacross.add(slider);
        bacross.add(Box.createHorizontalGlue());
        bdown.add(bacross);
        this.add(bdown);
    }

    protected JMenuBar createMenuBar(final JFrame f) {
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic(70);
        menuBar.add(fileMenu);
        JMenuItem closeMenu = new JMenuItem("Close");
        closeMenu.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        closeMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                f.dispose();
            }
        });
        fileMenu.add(closeMenu);
        return menuBar;
    }

    protected Hashtable getLineAttr() {
        this.lineAttr.put("start", new Integer(this.start.getValue()));
        this.lineAttr.put("end", new Integer(this.end.getValue()));
        this.lineAttr.put("lsize", new Integer(this.lineSize.getValue()));
        return this.lineAttr;
    }

    protected int getStart() {
        return this.start.getValue();
    }

    protected int getEnd() {
        return this.end.getValue();
    }
}

