RabbitMQ `3.9.22` is a maintenance release in the `3.9.x` release series.

Please refer to the **Upgrading to 3.9** section from [v3.9.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.9.0) if upgrading from a version prior to 3.9.0.

This release requires at least Erlang 24.x, and supports Erlang 25. [RabbitMQ and Erlang/OTP Compatibility Matrix](https://www.rabbitmq.com/which-erlang.html) has more details on Erlang version requirements for RabbitMQ.


## Changes Worth Mentioning

Release notes can be found on GitHub at [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v3.10.x/release-notes).


### Core Server

#### Enhancements

 * In environments where DNS resolution is not yet available at the time RabbitMQ nodes boot and try to perform [peer discovery](https://www.rabbitmq.com/cluster-formation.html),
   such as CoreDNS with default caching interval of 30s on Kubernetes, nodes now will retry
   hostname resolution (including of their own host) several times with a wait interval.

   The recommended solution is to [decrease CoreDNS caching interval](https://kubernetes.io/docs/concepts/workloads/controllers/statefulset/#stable-network-id).

   GitHub issue: [#5335](https://github.com/rabbitmq/rabbitmq-server/pull/5335)

#### Bug Fixes

 * Reduce log noise when `sysctl` cannot be accessed by node memory monitor.

   GitHub issue: [#5260](https://github.com/rabbitmq/rabbitmq-server/pull/5260)


### Prometheus Plugin

#### Enhancements

 * Prometheus plugin now exposes one more metric, `process_start_time_seconds`, the moment of node process
   startup in seconds.

   GitHub issue: [#4539](https://github.com/rabbitmq/rabbitmq-server/issues/4539)


## Shovel plugin

### Bug Fixes

 * Shovels now handle consumer delivery timeouts gracefully and restart.

   Contributed by @Haster2004.

   GitHub issue: [#5243](https://github.com/rabbitmq/rabbitmq-server/pull/5243)


## Dependency Upgrades

None in this release.


## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-3.9.22.tar.xz`
instead of the source tarball produced by GitHub.
